

<?php $__env->startSection('content'); ?>
    <style>
        th, td {
            border: 1px solid #ddd;
            text-align: center; 
            vertical-align: middle; 
            padding: 10px;
        }
    </style>

    <div>
        <div class="ps-section__content">
            <div class="row justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Cans Inventory</h3>
                    
                    <form method="GET" action="<?php echo e(route('admin.cans')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.cans')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>

                    <!-- Display Current Cans Inventory -->
                    <div class="alert alert-info">
                        <strong>Current Inventory:</strong> 
                        <?php echo e($totalCans); ?> cans available.
                    </div>

                    <!-- Manage Cans Form -->
                    <form action="<?php echo e(route('admin.update-cans')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="quantity" class="form-label">Adjust Quantity:</label>
                            <input type="number" id="quantity" name="quantity" class="form-control" placeholder="Enter number of cans">
                        </div>

                        <div class="mb-3">
                            <label for="action" class="form-label">Action:</label>
                            <select name="action" id="action" class="form-control">
                                <option value="add">Add Cans</option>
                                <option value="remove">Remove Cans</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-success">Update Inventory</button>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Full Name</th>
                                    <th>No. Of Cans</th>
                                    <th>Payment Id</th>
                                    <th>Amount</th>
                                    <th>Source</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $cans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $can): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($can->user->name); ?></td>
                                        <td><?php echo e($can->cans); ?></td>
                                        <td><?php echo e($can->payment_id); ?></td>
                                        <td><?php echo e($can->amount. ' ' . $can->currency); ?></td>
                                        <td><?php echo e($can->source); ?></td>
                                        <td><?php echo e($can->created_at->format('d-m-Y h:i:s A')); ?></td>
                                        <td><?php echo e($can->payment_status); ?></td>
                                        <td>
                                            <form action="<?php echo e(route('cans.status-update', $can->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="row p-0">
                                                    <div class="col-6" style="min-width: fit-content">
                                                        <select name="status" class="form-control" style="width: fit-content">
                                                            <option value="Pending" <?php echo e(($can->status == 'Pending') ? 'selected' : ''); ?>>Pending</option>
                                                            <option value="Approved" <?php echo e(($can->status == 'Approved') ? 'selected' : ''); ?>>Approved</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-6" style="min-width: fit-content">
                                                        <input type="submit" value="Update" class="btn btn-primary w-100" <?php echo e(($can->status == 'Approved') ? 'disabled' : ''); ?>>
                                                    </div>
                                                </div>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($cans->count() === 0): ?>
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Can Request . . . !</p>
                                        </td>                                    
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $cans->withQueryString()->links('pagination::bootstrap-5'); ?>

                </div>
            </div>
        </div>    
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/cans.blade.php ENDPATH**/ ?>