<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
  <title>Payment</title>
  <style>
    body{
      background-color: #f5f5f5;
    }
    .wrapper {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      background-color: #f5f5f5;
    }

    .payment-container {
      padding: 20px;
      display: flex;
      flex-direction: row;
      max-width: 800px;
      width: 100%;
      background: #fff;
      border-radius: 10px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      overflow: hidden;
    }

    .order-summary {
      flex: 1;
      padding: 20px;
      background-color: #f8f9fa;
    }

    .order-summary h2 {
      font-size: 1.5rem;
      margin-bottom: 20px;
    }

    .order-summary ul {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    .order-summary ul li {
      margin-bottom: 10px;
      display: flex;
      justify-content: space-between;
      font-size: 1rem;
    }

    .payment-form {
      flex: 1;
      padding: 20px;
    }

    .payment-form h3 {
      margin-bottom: 20px;
      font-size: 1.2rem;
    }

    .form-group {
      margin-bottom: 15px;
    }

    .form-group label {
      display: block;
      margin-bottom: 5px;
      font-size: 0.9rem;
    }

    .form-group input, .form-group select {
      width: 100%;
      padding: 10px;
      font-size: 1rem;
      border: 1px solid #ccc;
      border-radius: 5px;
    }

    .form-group input[type="checkbox"] {
      width: auto;
      margin-right: 10px;
    }

    .pay-btn {
      width: 100%;
      padding: 15px;
      background-color: #007bff;
      color: #fff;
      font-size: 1rem;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }

    .pay-btn:hover {
      background-color: #0056b3;
    }

    @media (max-width: 768px) {
      .payment-container {
        flex-direction: column;
      }
    }
  </style>
</head>
<body>
    <div class="px-4 pt-3">
        <a href="/store" class="btn btn-primary">Back</a>
    </div>
    <div class="wrapper">
        <div class="payment-container p-3">
            <div class="order-summary">
            <h2>Lovecans</h2>
            <ul>
                <li><span>No. Of Cans</span> <span><?php echo e($quantity); ?></span></li>
            </ul>
            <h2>Total Price: $<?php echo e($price); ?></h2>
            </div>
            <div class="payment-form">
            <h3>Pay with card</h3>
            <form id='checkout-form' method='post' action="<?php echo e(route('cans-payment')); ?>">   
                <?php echo csrf_field(); ?>    

                <strong>Name:</strong>
                <input type="input" class="form-control" name="name" placeholder="Enter Name">

                <input type="hidden" name="quantity" value="<?php echo e($quantity); ?>">
                <input type="hidden" name="price" value="<?php echo e($price); ?>">
                <input type='hidden' name='stripeToken' id='stripe-token-id'>                              
                <br>
                <div id="card-element" class="form-control" ></div>
                <button 
                    id='pay-btn'
                    class="btn btn-success mt-3"
                    type="button"
                    style="margin-top: 20px; width: 100%;padding: 7px;"
                    onclick="createToken()">PAY $<?php echo e($price); ?>

                </button>
            <form>
            
            </div>
        </div>
    </div>

    <script src="https://js.stripe.com/v3/"></script>
    <script type="text/javascript">
      
        var stripe = Stripe('<?php echo e(env('STRIPE_KEY')); ?>')
        var elements = stripe.elements();
        var cardElement = elements.create('card');
        cardElement.mount('#card-element');
      
        /*------------------------------------------
        --------------------------------------------
        Create Token Code
        --------------------------------------------
        --------------------------------------------*/
        function createToken() {
            document.getElementById("pay-btn").disabled = true;
            stripe.createToken(cardElement).then(function(result) {
      
                if(typeof result.error != 'undefined') {
                    document.getElementById("pay-btn").disabled = false;
                    alert(result.error.message);
                }
      
                /* creating token success */
                if(typeof result.token != 'undefined') {
                    document.getElementById("stripe-token-id").value = result.token.id;
                    document.getElementById('checkout-form').submit();
                }
            });
        }
    </script>
</body>
</html>
<?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/seller/store/checkout.blade.php ENDPATH**/ ?>