

<?php $__env->startSection('content'); ?>
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>

    
    <div>
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                <div class="col-lg-12 mt-3">
                    <h3>Seller Product Offers</h3>
                    <form method="GET" action="<?php echo e(route('admin.seller-offers')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.seller-offers')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped" >
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Price</th>
                                    <th>Received</th>
                                    <th>Delivery Status</th>
                                    <th>Payment Status</th>
                                    <th>View</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="align-content-center">
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <a href="<?php echo e(asset('storage/ads/'.$item->image)); ?>" target="_blank">
                                        <img src="<?php echo e(asset('storage/ads/'.$item->image)); ?>" alt="" style="width: 50px;border-radius:50px">
                                        </a>
                                    </td>
                                    <td><?php echo e($item->title); ?></td>
                                    <td>$<?php echo e($item->price); ?></td>
                                    <td>
                                        <?php if($item->is_received == 1): ?>
                                            <p class="badge bg-success">Received</p>
                                        <?php else: ?>
                                            <p class="badge bg-danger">Not Received</p>
                                        <?php endif; ?>
                                    </td>
                                    
                                    <td><?php echo e($item->offer_sent_status); ?></td>
                                    <td><?php echo e($item->payment_status?'Paid':'Unpaid'); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.seller-ad-view',$item->id)); ?>" class="btn btn-dark">
                                            View
                                        </a>
                                    </td>
                                    <td >
                                        <form action="<?php echo e(route('admin.update-offer-status',$item->id)); ?>" class="d-flex flex-wrap mx-auto" style="width: fit-content" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <select name="offer_status" id="" class="form-control" style="width: fit-content">
                                                <option value="Accepted" <?php echo e($item->offer_status == 'Accepted' ? 'selected' : ''); ?>>Accept</option>
                                                <option value="Rejected" <?php echo e($item->offer_status == 'Rejected' ? 'selected' : ''); ?>>Decline</option>
                                            </select>
                                            <input type="submit" class="btn btn-primary mx-2" value="Update" <?php echo e($item->offer_status == 'Accepted' ? 'disabled' : ''); ?>  style="width: fit-content">
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($data->isEmpty()): ?>
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Product Offers ... !</p>                                        
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $data->withQueryString()->links('pagination::bootstrap-5'); ?>  

                </div>
            </div>
        </div>    
    </div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/seller-offers.blade.php ENDPATH**/ ?>