

<?php $__env->startSection('content'); ?>
    <style>
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

        .premium-border {
            border: 2px solid gold;
            box-shadow: 0px 0px 10px gold;
        }
    </style>
    
    <div>
        <div class="ps-section__content">
            <div class="row justify-content-center pt-3">
                <div class="col-lg-11 card p-4">
                    <h3>Customer List</h3>
                    <form method="GET" action="<?php echo e(route('admin.customerlist')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by Name, Phone, Address, etc." 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.customerlist')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>first_name</th>
                                    <th>last_name</th>
                                    <th>Email</th>
                                    <th>phone_number</th>
                                    <th>address</th>
                                    <th>city</th>
                                    <th>postcode</th>
                                    <th>status</th>
                                    <th>Action</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $i = 0;
                                ?>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="align-content-center">
                                    <td><?php echo e(++$i); ?></td>
                                    <td><?php echo e($item->first_name); ?></td>
                                    <td><?php echo e($item->last_name); ?></td>
                                    <td><?php echo e($item->email); ?></td>
                                    <td><?php echo e($item->phone_number); ?></td>
                                    <td><?php echo e($item->address); ?></td>
                                    <td><?php echo e($item->city); ?></td>
                                    <td><?php echo e($item->postcode); ?></td>
                                    <td><?php echo e($item->status); ?></td>
                                    <td>
                                        <button type="button" class="btn" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="<?php echo e(route('admin.deletecustomerlist',$item->id)); ?>">
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAKRJREFUSEvtlUEKgCAQRV93CYK6TsdpGXSZrlPQaYpAXVjDt8xd7mR03v8z6FQUXlXh/ChAD4xAYwjZgAGYLaEKsACtcLkC3VvA7i5aQlRclkglUPELwF/I7X1wHFsvDvDKpfXIonn+dfO+BsQK1T7wUx2ohNkl+gGXd/W0JH8P5NeUXSJFeAxIGTQx9HbwWC/5HJUTUCvpLm6OTjUyE/Pbx4oDDlBhOBmYaWrOAAAAAElFTkSuQmCC"/>
                                        </button>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('admin.customerlistupdate', $item->id)); ?>" method="POST" class="d-flex">
                                            <?php echo csrf_field(); ?>
                                            <select name="status" id="status" class="form-control mx-1" style="width: fit-content">
                                                <option value="unblock" <?php echo e($item->status == 'unblock' ? 'selected' : ''); ?>>Unblock</option>
                                                <option value="blocked" <?php echo e($item->status == 'blocked' ? 'selected' : ''); ?>>Blocked</option>
                                            </select>
                                        
                                            <input type="text" name="notes" class="form-control mx-1" placeholder="Add a note" value="<?php echo e(old('notes', $item->notes)); ?>" style="width: fit-content;">
                                        
                                            <input type="submit" class="form-control btn btn-primary" value="Update">
                                        </form>
                                        
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($customers->count() === 0 ): ?>
                                    <tr>
                                        <td colspan="12">
                                            <p class="text-center">No Sellers</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $customers->withQueryString()->links('pagination::bootstrap-5'); ?>  
                </div>
            </div>
        </div>    
    </div>


   <!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this item?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <a href="" id="deleteSeller">
                    <button type="submit" class="btn btn-danger">Delete</button>
                </a>
            </div>
        </div>
    </div>
</div>

    <!-- Modal -->
    <div class="modal fade" id="userDetailsModal" tabindex="-1" aria-labelledby="userDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="userDetailsModalLabel">User Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <img src="" alt="" id="modalImage" style="width: 70px;height:70px;border-radius:50px">
                    <p><strong>Name:</strong> <span id="modalUserName"></span></p>
                    <p><strong>Email:</strong> <span id="modalUserEmail"></span></p>
                    <p><strong>Age:</strong> <span id="modalAge"></span></p>
                    <p><strong>Figure:</strong> <span id="modalFigure"></span></p>
                    <p><strong>Type:</strong> <span id="modalType"></span></p>
                    <p><strong>Eye Color:</strong> <span id="modalEyeColor"></span></p>
                    <p><strong>Hair Color:</strong> <span id="modalHairColor"></span></p>
                    <p><strong>Address:</strong> <span id="modalAddress"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const modal = new bootstrap.Modal(document.getElementById('userDetailsModal'));

            document.querySelectorAll('.view-details-btn').forEach(button => {
                button.addEventListener('click', () => {
                    // Get user details from data attributes
                    const userImage = button.getAttribute('data-image');
                    const userName = button.getAttribute('data-name');
                    const userEmail = button.getAttribute('data-email');
                    const userAge = button.getAttribute('data-age');
                    const userType = button.getAttribute('data-type');
                    const userFigure = button.getAttribute('data-figure');
                    const userHairColor = button.getAttribute('data-hair_color');
                    const userEyeColor = button.getAttribute('data-eye_color');
                    const userAddress = button.getAttribute('data-address');

                    // Populate modal fields
                    // document.getElementById('modalImage').textContent = userImage;
                    document.getElementById('modalUserName').textContent = userName;
                    document.getElementById('modalUserEmail').textContent = userEmail;

                    document.getElementById('modalAge').textContent = userAge;
                    document.getElementById('modalFigure').textContent = userFigure;
                    document.getElementById('modalType').textContent = userType;
                    document.getElementById('modalEyeColor').textContent = userEyeColor;
                    document.getElementById('modalHairColor').textContent = userHairColor;
                    document.getElementById('modalAddress').textContent = userAddress;

                    document.getElementById('modalImage').src = `<?php echo e(asset('storage/avatars')); ?>/${userImage}`;


                    // const filesContainer = document.getElementById('modalUserFiles');
                    // filesContainer.innerHTML = '';
                    // userFiles.forEach(file => {
                    //     if (file) {
                    //         const filePath = `<?php echo e(asset('storage')); ?>/${file.trim()}`;
                    //         const fileElement = file.endsWith('.mp4') ?
                    //             `<video controls width="100%"><source src="${filePath}" type="video/mp4"></video>` :
                    //             `<img src="${filePath}" alt="File Image" style="max-width: 100%; margin-bottom: 10px;">`;
                    //         filesContainer.innerHTML += fileElement;
                    //     }
                    // });

                    // Show modal
                    modal.show();
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
        const deleteModal = document.getElementById('deleteModal');
        const deleteForm = document.getElementById('deleteForm');
        
        deleteModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const id = button.getAttribute('data-id');
            document.getElementById('deleteSeller').href = id;
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
    const statusSelect = document.getElementById('status');
    const notesModal = new bootstrap.Modal(document.getElementById('notesModal'));

    // Function to show the modal when 'blocked' is selected
    function toggleNotesField() {
        if (statusSelect.value === 'blocked') {
            notesModal.show();
        } else {
            notesModal.hide();
        }
    }

    // Listen for changes to the status select field
    statusSelect.addEventListener('change', toggleNotesField);
});


    </script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/customerlist.blade.php ENDPATH**/ ?>