

<?php $__env->startSection('content'); ?>
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Product Reports</h3>
                    
                    <form method="GET" action="<?php echo e(route('admin.reports')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search ......" 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.reports')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Product</th>
                                    <th>Title</th>
                                    <th>Report Reason</th>
                                    <th>Report Details</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td>
                                            <a href="<?php echo e(asset('storage/ads/'.$report->ad->image)); ?>" target="_blank">
                                            <img src="<?php echo e(asset('storage/ads/'.$report->ad->image)); ?>" alt="" style="width: 50px;border-radius:50px">
                                            </a>
                                        </td>
                                        <td><?php echo e($report->ad->title); ?></td>
                                        <td><?php echo e($report->user->name); ?></td>
                                        <td><?php echo e($report->report_details); ?></td>
                                        <td><?php echo e($report->created_at->format('d-m-Y h:i:s A')); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('admin.show_report',$report->id)); ?>" target="_blank" style="padding: 6px 12px;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M1 12S5 4 12 4s11 8 11 8-4 8-11 8S1 12 1 12z"/>
                                                    <circle cx="12" cy="12" r="3"/>
                                                  </svg>
                                            </a>
                                        </td>
                                        <td>
                                            <form action="<?php echo e(route('admin.update-product-status',$report->ad->id)); ?>" class="d-flex" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <select name="status" id="" class="form-control mx-1"  style="width: fit-content">
                                                    <option value="Approved" <?php echo e($report->ad->status=='Approved'?"selected":""); ?>>UnBlocked</option>
                                                    <option value="Blocked" <?php echo e($report->ad->status=='Blocked'?"selected":""); ?>>Blocked</option>
                                                </select>
                                                <input type="submit" name="" value="Update" class="form-control btn btn-primary">
                                            </form>
                                        </td>
                                        <td><button class="btn btn-secondary" onclick="captureScreenshot()">Capture Screenshot</button>
                                            <div id="screenshotContainer"></div></td>



                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($reports->isEmpty()): ?>
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Reports . . . !</p>
                                        </td>
                                    </tr>
                                    
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                     <?php echo $reports->withQueryString()->links('pagination::bootstrap-5'); ?>

                </div>
               
            </div>
        </div>    
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
function captureScreenshot() {
    html2canvas(document.body).then(canvas => {
        // Pehle wale screenshot ko remove karein (agar koi ho)
        document.getElementById('screenshotContainer').innerHTML = '';

        // Image banakar show karein
        let img = document.createElement("img");
        img.src = canvas.toDataURL("image/png"); // Convert canvas to image
        img.style.border = "1px solid black";
        img.style.width = "300px"; // Set width
        img.style.display = "block"; // Show image

        document.getElementById('screenshotContainer').appendChild(img);
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/reports.blade.php ENDPATH**/ ?>