
<?php $__env->startSection('content'); ?>

<div class="container">
<div class="d-flex justify-content-between align-items-center mb-4 pt-4">
    <h4>MemberShip</h4>
    <a href="<?php echo e(route('admin.add-membership')); ?>" class="btn btn-primary mb-3">Add New MemberShip Plan</a>
</div>
<form method="GET" action="<?php echo e(route('admin.membership')); ?>">
    <div class="input-group mb-3">
        <input 
            type="text" 
            name="search" 
            class="form-control" 
            placeholder="Search by title" 
            value="<?php echo e(request('search')); ?>">
        <button class="btn btn-primary" type="submit">Search</button>

        <a href="<?php echo e(route('admin.membership')); ?>" class="btn btn-secondary">Reset</a>
    </div>
</form>


    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Ad Limit</th>
                <th>Image Limit</th>
                <th>Duration (Days)</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $i = 0;
            ?>
            <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e(++$i); ?></td>
                <td><?php echo e($plan->name); ?></td>
                <td>$<?php echo e(number_format($plan->price, 2)); ?></td>
                <td><?php echo e($plan->image_limit); ?></td>
                <td><?php echo e($plan->duration_days); ?></td>
                <td>
                    <a href="<?php echo e(route('membership.edit', $plan->id)); ?>">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAThJREFUSEvl1b1KxEAUhuFnK7HSSgTBQgQt9AYsrO28A6/AUlErFWT97fQWbLW1F7wBsRNBEMRC0M5K3QNZiMlmmUS38kBIQma+d853zmRaBhytAev7S8AxXnCSX3QRsIwDzPbJ7BMrOM+NOcVq9r6ehxQBT5ioKT6GW8S9G1vZQksWfWUjUq0bxRumcY3xbP4GjuK5KFQHsIa4FjqWPWAKN9jDWTeVpoBN7Gciz1jEPUbw3q/IKRmEv+1CnQIyj9di/epmEJZEOxYjWjO6pxR1AKniS7iqW4MdbCesPMQvMVwHEMIBSLHlo1P8oXx3pljULXweUOV5qUmaACKb3Yrd/mvAj/9MD0gjQJ9fU+nTPwA8YrKOJz3G3mGuah/EgXOImYaQOBeiyy6qAA11q6elHiyNwQMHfAOdL0QZH51cjgAAAABJRU5ErkJggg=="/>
                    </a>
                    <button type="button" class="btn" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="<?php echo e($plan->id); ?>">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAKRJREFUSEvtlUEKgCAQRV93CYK6TsdpGXSZrlPQaYpAXVjDt8xd7mR03v8z6FQUXlXh/ChAD4xAYwjZgAGYLaEKsACtcLkC3VvA7i5aQlRclkglUPELwF/I7X1wHFsvDvDKpfXIonn+dfO+BsQK1T7wUx2ohNkl+gGXd/W0JH8P5NeUXSJFeAxIGTQx9HbwWC/5HJUTUCvpLm6OTjUyE/Pbx4oDDlBhOBmYaWrOAAAAAElFTkSuQmCC"/>
                    </button>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <td class="text-center text-capitalize" colspan="8">no membership found</td>
        <?php endif; ?>
        </tbody>
    </table>
    <?php echo $plans->withQueryString()->links('pagination::bootstrap-5'); ?>

</div>



<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this membership?
            </div>
            <div class="modal-footer">
                <form id="deleteForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>



<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteModal = document.getElementById('deleteModal');
        const deleteForm = document.getElementById('deleteForm');

        deleteModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const id = button.getAttribute('data-id');
            deleteForm.action = `/delete-membership/${id}`;
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/plans/all-plans.blade.php ENDPATH**/ ?>