

<?php $__env->startSection('content'); ?>
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center;
            vertical-align: middle; 
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                <div class="col-lg-12 mt-3">
                    <h3>All Orders</h3>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Product</th>
                                    <th>Title</th>
                                    <th>Quantity</th>
                                    <th>Total Price</th>
                                    <th>Payment Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="align-content-center">
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <a href="<?php echo e(asset('storage/ads/'.$order->image)); ?>" target="_blank"><img src="<?php echo e(asset('storage/ads/'.$order->image)); ?>" alt="" style="width: 50px;border-radius:50px"></a>
                                    </td>
                                    <td><?php echo e($order->title); ?></td>
                                    <td><?php echo e($order->quantity); ?></td>
                                    <td>$<?php echo e($order->price*$order->quantity); ?></td>
                                    <td><?php echo e($order->order_status); ?></td>
                                    <td>                                    
                                        <form action="<?php echo e(route('update-order-status')); ?>" method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" value="<?php echo e($order->order_detail_id); ?>">
                                            
                                            <select name="status" id="order_status" class="form-control mx-2" style="width: fit-content">
                                                <option value="pending" <?php echo e(($order->order_status == 'pending') ? 'selected' : ''); ?>>Pending</option>
                                                <option value="inprogress" <?php echo e(($order->order_status == 'inprogress') ? 'selected' : ''); ?>>In Progress</option>
                                                <option value="cancelled" <?php echo e(($order->order_status == 'cancelled') ? 'selected' : ''); ?>>Cancelled</option>
                                                <option value="sent" <?php echo e(($order->order_status == 'sent') ? 'selected' : ''); ?>>Sent</option>
                                            </select>
                                        
                                            <div id="pdf_input" style="display:none;">
                                                <label for="pdf_file">Upload PDF:</label>
                                                <input type="file" name="pdf" accept=".pdf" class="form-control">
                                            </div>
                                        
                                            <div id="video_input" style="display:none;">
                                                <label for="video_file">Upload Video:</label>
                                                <input type="file" name="media" accept="video/*" class="form-control">
                                            </div>
                                        
                                            <button type="submit" class="form-control btn btn-primary" 
                                            <?php echo e(($order->order_status == 'sent' || $order->order_status == 'cancelled') ? 'disabled' : ''); ?>>
                                            Update
                                        </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($orders->count() == 0): ?>
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Orders</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $orders->withQueryString()->links('pagination::bootstrap-5'); ?>

            </div>
        </div>    
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const orderStatus = document.getElementById('order_status');
            const pdfInput = document.getElementById('pdf_input');
            const videoInput = document.getElementById('video_input');
    
            function toggleFileInputs() {
                if (orderStatus.value === 'sent') {
                    pdfInput.style.display = 'block';
                    videoInput.style.display = 'block';
                } else {
                    pdfInput.style.display = 'none';
                    videoInput.style.display = 'none';
                }
            }
            toggleFileInputs();
    
            orderStatus.addEventListener('change', toggleFileInputs);
        });
    </script>
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/orders.blade.php ENDPATH**/ ?>