<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <title>Order Confirmation Email</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f7f7f7;
            padding: 30px;
            color: #555;
        }
        .container {
            background-color: #fff;
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            max-width: 650px;
            margin: 0 auto;
        }
        h3 {
            color: #4CAF50;
            font-size: 28px;
            font-weight: bold;
            text-align: center;
            margin-bottom: 20px;
        }
        h4 {
            color: #333;
            font-size: 20px;
            margin-top: 30px;
            margin-bottom: 10px;
            font-weight: 600;
        }
        p {
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 15px;
        }
        .table {
            margin-top: 20px;
            width: 100%;
        }
        th {
            background-color: #f8f9fa;
            color: #333;
            font-weight: bold;
            padding: 12px;
            text-align: left;
        }
        td {
            padding: 12px;
            border-bottom: 1px solid #f0f0f0;
        }
        .text-end {
            text-align: right;
        }
        .total-price {
            font-size: 18px;
            font-weight: 700;
            color: #ff5722;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            color: #777;
        }
        .footer a {
            text-decoration: none;
            color: #4CAF50;
            font-weight: 500;
        }
        .btn-primary {
            background-color: #4CAF50;
            color: #fff;
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            display: inline-block;
            font-weight: bold;
            text-align: center;
            margin-top: 20px;
        }
        .btn-primary:hover {
            background-color: #45a049;
        }
        .order-summary {
            background-color: #f1f8e9;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.05);
            margin-top: 20px;
        }
        .order-summary td, .order-summary th {
            border: none;
        }
        .order-summary th {
            font-weight: bold;
            color: #4CAF50;
        }
        .order-summary td {
            color: #555;
        }
    </style>
</head>
<body>
    <div class="container">
        <h3>Order Confirmation (Paid)</h3>
        <p>Dear <?php echo e($order_details->first_name . ' ' . $order_details->last_name); ?>,</p>
        <p>Thank you for your order! We are excited to confirm that your order has been successfully placed. Here's a summary of your order:</p>
        
        <div class="order-summary">
            <h4>Order Summary:</h4>
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Product (Quantity x Price)</th>
                        <th class="text-end">Total Price</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $total_price = 0;
                    ?>
                    <?php if(count($order_details->name) > 0): ?>
                        <?php $__currentLoopData = $order_details->name; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($value); ?>  (<?php echo e($order_details->quantity[$key]); ?> x <?php echo e($order_details->price[$key]); ?>)</td>
                                <?php
                                    $total_price += $order_details->quantity[$key] * $order_details->price[$key];
                                ?>
                                <td class="text-end">$<?php echo e(number_format($order_details->quantity[$key] * $order_details->price[$key], 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="2" class="text-center">No items in the order</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="2" class="text-end total-price">
                            Total Price: $<?php echo e(number_format($total_price, 2)); ?>

                        </th>
                    </tr>
                </tfoot>
            </table>
        </div>

        <div class="footer">
            <p>If you have any questions, feel free to <a href="mailto:support@yourdomain.com">contact us</a>.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/emails/order-confirmation.blade.php ENDPATH**/ ?>