

<?php $__env->startSection('content'); ?>
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    <h3>Customer Messages</h3>
                    
                    <form method="GET" action="<?php echo e(route('admin.customer-messages')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by name" 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.customer-messages')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Full Name</th>
                                    <th>Email</th>
                                    <th>Subject</th>
                                    <th>Message</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($message->name); ?></td>
                                        <td><?php echo e($message->email); ?></td>
                                        <td><?php echo e($message->subject); ?></td>
                                        <td><?php echo e($message->message); ?></td>
                                        <td><?php echo e($message->created_at->format('d M Y h:i:s A')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($messages->count() === 0): ?>
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No Messages . . . !</p>
                                        </td>                                    
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                     <?php echo $messages->withQueryString()->links('pagination::bootstrap-5'); ?>

                </div>
               
            </div>
        </div>    
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/customer-messages.blade.php ENDPATH**/ ?>