

<?php $__env->startSection('content'); ?>
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Arial', sans-serif;
        }

        .payment-card {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 14px 20px rgba(10, 10, 10, 0.1);
            padding: 20px;
            margin: 10px;
        }

        .cart__preview {
            border-radius: 20px;
            height: 20vh;
        }

        .cart__preview img {
            border-radius: 20px;
            height: 100%;

        }

        .product-details {
            background-color: #fff;
            box-shadow: 0 14px 20px rgba(10, 10, 10, 0.1);
            padding: 20px;
            /* margin:  10px; */
        }

        .cart__price {
            font-size: 25px;
        }

        #cart-items-container {
            border: 1px solid #dee2e6;
            border-radius: 20px;
            margin: 20px;
            padding: 20px;

        }

        .price-info {
            font-size: 1.2rem;
            font-weight: bold;
        }

        .pay-button {
            background-color: #EA016C;
            color: #fff;
            font-weight: bold;
            margin-top: 20px;
            width: 100%;
            padding: 7px;
            border: none;
            border: 2px solid #EA016C;
        }

        .pay-button:hover {
            background-color: #fff;
            border: 2px solid #EA016C;
            color: #EA016C;

        }

        .cart__product {
            color: black
        }

        .cart__product:hover {
            color: #EA016C;
        }

        .cart__product h4 {
            font-size: 25px;
            font-weight: 500;
            color: #000;
        }

        .cart__product h4:hover {
            color: #EA016C;
        }
    </style>

    <div class="p-4">
        <div class="container card m-auto" style="font-size: 16px;">
            <h2 style="color: black" class="text-center my-3">Thank you for Shopping with Us</h2>
            <div class="row justify-content-center my-5 py-5">
                <?php $__sessionArgs = ['error'];
if (session()->has($__sessionArgs[0])) :
if (isset($value)) { $__sessionPrevious[] = $value; }
$value = session()->get($__sessionArgs[0]); ?>
                    <p class="alert alert-danger col-12" role="alert">
                        <?php echo e(session('error')); ?>

                    </p>
                <?php unset($value);
if (isset($__sessionPrevious) && !empty($__sessionPrevious)) { $value = array_pop($__sessionPrevious); }
if (isset($__sessionPrevious) && empty($__sessionPrevious)) { unset($__sessionPrevious); }
endif;
unset($__sessionArgs); ?>
                <div class="col-12 col-lg-10 m-0 p-0">
                    <div class="my-5" id="cart-items-container"></div>

                    <div class="payment-card row">
                        <!-- Product Details Section -->
                        <div class="col-lg-6 product-details table-responsive">
                            <h4 style="color: black" class="mb-4">Lovecans</h4>
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Price</th>
                                        <th>Quantity</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data['name']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><b><?php echo e($item); ?></b></td>
                                            <td>$<?php echo e($data['price'][$key]); ?></td>
                                            <td><?php echo e($data['quantity'][$key]); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <hr>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">Total Price:</span>
                                <span class="price-info">$<?php echo e($total_price); ?></span>
                            </div>
                        </div>

                        <!-- Payment Section -->
                        <div class="col-lg-6">

                            <div class="payment-form align-content-center">
                                <h3 style="color: #000">Pay with card</h3>
                                <form id='checkout-form' method='post' action="<?php echo e(route('customer.payment')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="total_price" value="<?php echo e($total_price); ?>">
                                    <input type="hidden" name="data" value="<?php echo e(json_encode($data)); ?>">
                                    <input type='hidden' name='stripeToken' id='stripe-token-id'>
                                    <br>
                                    <div id="card-element" style="border: 1px solid #EAD5C4;; padding: 12px;"></div>
                                    <button id='pay-btn' class="pay-button" type="button" onclick="createToken()">PAY
                                        $<?php echo e($total_price); ?>

                                    </button>
                                    <form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Function to render cart items
        function renderCartItems() {
            const cartContainer = document.getElementById('cart-items-container');
            const cart = JSON.parse(localStorage.getItem('cart')) || [];

            if (cart.length === 0) {
                cartContainer.innerHTML = '<p>Your cart is empty.</p>';
            } else {
                cartContainer.innerHTML = ''; // Clear existing content
                cart.forEach(item => {
                    const itemDiv = document.createElement('div');
                    itemDiv.classList.add('cart-item');
                    itemDiv.innerHTML = `
                        <div class="cart__item row">
                            <!-- Product Image -->
                            <div class="col-12 col-md-4 cart__preview">
                                <img class="cart__preview-img img-fluid" src="storage/ads/${item.image}" alt="Product Image">
                            </div>

                            <!-- Product Info -->
                            <div class="col-12 col-md-8 cart__info my-2">
                                <div class="row">
                                    <!-- Product Text Information -->
                                    <div class="col-12 col-md-6 cart__text">
                                        <div class="cart__name">
                                            <a class="cart__product" href="product-details/${item.id}">
                                            <h4>  ${item.name} </h4>
                                            </a>
                                        </div>
                                    </div>

                                    <!-- Pricing Information -->
                                    <div class="col-12 col-md-2 cart__pricing">
                                        <span class="cart__price">€ ${item.price}</span>
                                    </div>
                                </div>
                            </div>
                        </div>


                    `;
                    cartContainer.appendChild(itemDiv);
                });
            }
        }

        // Call the function to render cart items when the page loads
        document.addEventListener('DOMContentLoaded', renderCartItems);
    </script>


    <script src="https://js.stripe.com/v3/"></script>
    <script type="text/javascript">
        var stripe = Stripe('<?php echo e(env('STRIPE_KEY')); ?>')
        var elements = stripe.elements();
        var cardElement = elements.create('card');
        cardElement.mount('#card-element');

        /*------------------------------------------
        --------------------------------------------
        Create Token Code
        --------------------------------------------
        --------------------------------------------*/
        function createToken() {
            document.getElementById("pay-btn").disabled = true;
            stripe.createToken(cardElement).then(function(result) {

                if (typeof result.error != 'undefined') {
                    document.getElementById("pay-btn").disabled = false;
                    alert(result.error.message);
                }

                /* creating token success */
                if (typeof result.token != 'undefined') {
                    document.getElementById("stripe-token-id").value = result.token.id;
                    document.getElementById('checkout-form').submit();
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/user/checkout.blade.php ENDPATH**/ ?>