<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Media Purchase Notification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            background-color: #f4f4f4;
            padding: 20px;
        }
        .container {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .header {
            font-size: 24px;
            font-weight: bold;
            color: #2d3e50;
            margin-bottom: 20px;
        }
        .content {
            margin-bottom: 20px;
        }
        .content p {
            margin: 5px 0;
        }
        .footer {
            font-size: 14px;
            color: #777;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #007bff;
            color: white;
        }
        .btn {
            background-color: #007bff;
            color: #fff !important;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            display: inline-block;
        }
        .btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            Media Purchase Confirmation
        </div>

        <div class="content">
            <p>Dear <?php echo e($purchase->name); ?>,</p>
            <p>Thank you for purchasing media from our platform! Below are your purchase details:</p>

            <p><strong>Order ID:</strong> <?php echo e($purchase->id); ?></p>
            <p><strong>Download Your Media:</strong></p>
            <p><a href="<?php echo e($mediaLink); ?>" class="btn">Download Now</a></p>

            <p><strong>All Your Media Purchases:</strong></p>
            <table>
                <thead>
                    <tr>
                        <th>Media ID</th>
                        <th>Media Name</th>
                        <th>Price</th>
                        <th>video</th>
                        <th>Download Link</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $media_purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($media->id); ?></td>
                            <td><?php echo e($media->media->name); ?></td>
                            <td>$<?php echo e($media->media->price); ?></td>
                            <td>
                                <a href="<?php echo e(asset('storage/' . $media->media->file_path)); ?>" class="btn">download Video</a>
                            </td>
                            <td>
                                <a href="<?php echo e($media->media->type == 'external_link' ? $media->media->external_link : url('storage/' . $media->media->file_path)); ?>" class="btn">
                                    Download
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/emails/purchase_notification.blade.php ENDPATH**/ ?>