

<?php $__env->startSection('content'); ?>
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="row justify-content-center pt-3">
                <div class="col-lg-11 card p-4">
                    <h3>Seller Gender Messages</h3>
                    <form method="GET" action="<?php echo e(route('admin.gendermessages')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.gendermessages')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <?php if($sellers->isEmpty()): ?>
                        <div class="alert alert-warning text-center">No record found matching your search criteria.</div>
                        <?php else: ?>
                        <table class="table table-bordered text-center">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Seller Name</th>
                                    <th>Email</th>
                                    <th>Current Gender</th>
                                    <th>Last Message</th>
                                    <th>Update Gender</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($seller->id); ?></td>
                                    <td><?php echo e($seller->name); ?></td>
                                    <td><?php echo e($seller->email); ?></td>
                                    <td><?php echo e(ucfirst($seller->profile->gender)); ?></td>
                                    <td>
                                        <?php if($seller->adminMessages->count() > 0): ?>
                                            <?php echo e($seller->adminMessages->last()->message); ?>

                                        <?php else: ?>
                                        No Messages
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('admin.update.seller.gender', $seller->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <select class="form-control" name="gender">
                                        <option value="male" <?php echo e($seller->profile->gender == 'male' ? 'selected' : ''); ?>>Male</option>
                                        <option value="female" <?php echo e($seller->profile->gender == 'female' ? 'selected' : ''); ?>>Female</option>
                                        </select>
                                    </td>
                                    <td>
                                    <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                    </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php endif; ?>
                    </div>
                    <?php echo $sellers->withQueryString()->links('pagination::bootstrap-5'); ?>  
                </div>
            </div>
        </div>    
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/gendermessges.blade.php ENDPATH**/ ?>