<?php $__env->startSection('title', 'Products'); ?>
<style>

    .image-container {
    position: relative;
    overflow: hidden;
    min-height: 255px;
    min-width: 255px;
}

.hover-icons {
    position: absolute;
    bottom: 10px;
    left: 10px;
    display: flex;
    gap: 10px;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.image-container:hover .hover-icons {
    opacity: 1;
}

.hover-icons .icon {
    background: rgba(0, 0, 0, 0.7);
    color: #fff;
    padding: 10px;
    border-radius: 50%;
    font-size: 16px;
    cursor: pointer;
    border: none;
    outline: none;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
}

.hover-icons .icon:hover {
    background-color: rgba(234, 1, 108, 0.9);
}


</style>
<?php $__env->startSection('content'); ?>
    
    <div class="container-fluid py-5 m-0l">
        <div class="ps-section__content">
            <h2 class="text-center mb-4">All Products</h2>
            <div class="row products" style="display: flex; flex-wrap: wrap; gap: 20px;">
                <div class="col-md-9" style="justify-content: center !important; flex: 1; display: flex; flex-wrap: wrap; gap: 20px;height:fit-content">
                    <?php $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="testing" style="height: 50%;">
                        <div class="image-container" style="position: relative;">
                            <a href="<?php echo e(route('user.product.details', $ad->id)); ?>">
                                <img src="<?php echo e(asset('storage/ads/' . $ad->image)); ?>" alt="<?php echo e($ad->title); ?>"
                                    style="max-height: 255px; border-radius: 20px; width: 100%;">
                            </a>
                    
                            <!-- Hover icons -->
                            <div class="hover-icons">
                                <a href="<?php echo e(route('user.product.details', $ad->id)); ?>" class="icon eye" title="View Details">
                                    <i class="fa fa-eye"></i>
                                </a>
                                <button class="icon cart add-to-cart-btn product-card" 
                                        data-id="<?php echo e($ad->id); ?>"
                                        data-name='<?php echo e($ad->title); ?>'
                                        data-price="<?php echo e($ad->price); ?>"
                                        data-image="<?php echo e($ad->image); ?>"
                                        data-desc="<?php echo e($ad->description); ?>"
                                        data-user_name="<?php echo e(optional($ad->user)->name); ?>"
                                        data-type="image"
                                        data-days="<?php echo e($ad->worn_days); ?>"
                                        title="Add to Cart">
                                    <i class="fa fa-shopping-cart"></i>
                                </button>
                            </div>
                        </div>
                    
                        <div style="padding-top: 12px; text-align: center;">
                            <h5 class="text-capitalize" style="font-weight: 900; font-size: 20px; color: black">
                                <?php echo e($ad->title); ?></h5>
                            <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">
                                <?php echo e($ad->worn_days ? 'Duration: ' . $ad->worn_days . ' days' : 'No duration available'); ?>

                            </p>
                            <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">price $<?php echo e($ad->price); ?></p>
                            
                        </div>
                    </div>
                    
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="col-md-3 order-last myorder-last  ms-auto" style="flex: 0 0 250px; background: #f8f9fa; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);height: fit-content;">
                    <form action="<?php echo e(route('products.filter')); ?>" method="GET">
                        <h4 class="fw-bold mt-3">Category</h4>
                        <select name="category" class="form-control mb-2 p-0">
                            <option value="select category">Select Category</option>
                            <?php
                                $categories = App\Models\Category::all();
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(request('category') == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->category); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <option disabled>No category found</option>
                            <?php endif; ?>
                        </select>
                        <h4 class="fw-bold mt-3">Days Worn</h4>
                        <select name="worn_days" class="form-control mb-2 p-0">
                            <option value="select worn days">Select Days Worn</option>
                            <?php
                                $days = [1,2,3,4,5,6,7];
                            ?>
                            <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($day); ?>" <?php echo e(request('worn_days') == $day? 'selected' : ''); ?>>
                                    <?php echo e($day); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <h4 class="fw-bold mt-3">Gender</h4>
                        <select name="gender" class="form-control mb-2 p-0">
                            <option value="select gender">Select Gender</option>
                            <option value="Male">Male</option>
                            <option value="Female">Female</option>
                            <option value="Other">Other</option>
                        </select>
                        <h4 class="fw-bold mt-3">Size</h4>
                        <select name="clothing_size" class="form-control mb-2 p-0">
                            <option value="select clothing size">Select Clothing Size</option>
                            <?php
                                $sizes = ['xs', 's', 'm', 'l', 'XL', 'xxl', 'xxxl'];
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($size); ?>" <?php echo e(request('clothing_size') == $size? 'selected' : ''); ?>>
                                    <?php echo e($size); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <h4 class="fw-bold mt-3">Price Range €</h4>
                        <div class="range-slider" style="text-align:center;">
                            <span class="range-values" id="rangeValue"><?php echo e(request('minPrice') ?? '0'); ?> - <?php echo e(request('maxPrice') ?? $max); ?></span>
                            <input type="range" id="minPrice" name="minPrice" class="form-range" style="accent-color: #A80150;width:20rem;" min="0" max="<?php echo e($max); ?>" value="<?php echo e(request('minPrice') ?? '0'); ?>">
                            <input type="range" id="maxPrice" name="maxPrice" class="form-range" style="accent-color: #A80150;width:20rem;" min="0" max="<?php echo e($max); ?>" value="<?php echo e(request('maxPrice') ?? $max); ?>">
                        </div>
                        <p class="my-5">
                            <b>Additional Refinements</b>
                        </p>
                        <?php
                            $options = [
                                'Wearing pictures',
                                'Waring videos',
                                'Worn during sport',
                                'Golden shower',
                                'Worn during sex',
                                'Worn inside',
                                'Lisptick',
                                'Parfume',
                                // 'Worn during masturbation',
                                'Kaviar',
                            ];
                        ?>
                       <div id="options-container">
                            <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="d-flex align-items-center mb-2">
                                    <div class="col-12">
                                        <input class="mx-2 my-2" type="checkbox" value="<?php echo e($option); ?>"
                                            name="refinement_title[<?php echo e($key); ?>]"
                                            <?php echo e(is_array(request('refinement_title')) && in_array($option, request('refinement_title')) ? 'checked' : ''); ?>>
                                        <label for="free_of_diseases"><?php echo e($option); ?></label>
                                        <span style="cursor: help"
                                            class="badge rounded-pill bg-secondary text-white"
                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                            title="<?php echo e($option); ?>"></span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    

                        <div class="d-flex justify-content-between mt-2" style="gap: 10px;">
                            <button type="submit" class="hoverable flex-fill me-2 text-white rounded-pill p-2" style="border:none">Filter</button>
                            <a href="<?php echo e(route('products.filter')); ?>" class="hoverable flex-fill text-white text-center rounded-pill p-2" style="border:none">Reset Filter</a>
                        </div>
                    </form>



                </div>

            </div>
        </div>

        <?php if($ads->isEmpty()): ?>
            <p class="text-center">No products found</p>
        <?php endif; ?>
    </div>
    <script>
        document.addEventListener('click', function (e) {
    if (e.target.closest('.add-to-cart-btn')) {
        const btn = e.target.closest('.add-to-cart-btn');
        const data = {
            id: btn.dataset.id,
            name: btn.dataset.name,
            price: btn.dataset.price,
            image: btn.dataset.image,
            desc: btn.dataset.desc,
            days: btn.dataset.days,
            type: btn.dataset.type
        };

        // Example action (replace this with actual add to cart logic)
        console.log('Adding to cart:', data);
    }
});

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/user/productss.blade.php ENDPATH**/ ?>