

<?php $__env->startSection('content'); ?>
    <div class="col-lg-8">
        <?php if(Auth::user()->ads()->where('status', 'blocked')->count() > 0): ?>
    <div class="ps-section__right">
        <!-- Show message for blocked account -->
        <p>Your account has been blocked. Please contact admin for unblocking.</p>
    </div>
<?php else: ?>
    <!-- Show form for non-blocked account -->
    <div class="ps-section__right">
        <form class="ps-form--account-setting" action="<?php echo e(route('profile.update', $profile)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
        <?php echo csrf_field(); ?>
        <div class="ps-form__header">
            <h3> User Information</h3>
        </div>
        <div class="ps-form__content">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Name</label>
                        <input class="form-control" type="text" value="<?php echo e($profile ? $profile->nickname: ''); ?>" name="nickname" placeholder="Please enter your Nickname...">
                        <?php if($errors->has('nickname')): ?>
                        <span class="help-block text-danger">
                            <strong><?php echo e($errors->first('nickname')); ?></strong>
                        </span>
                        <?php endif; ?>
                       <p class="text-muted mt-2">
                            You are a <b> <?php echo e(auth()->user()->isPSeller() ? 'Premium' : 'Standard'); ?> </b> seller 
                            <?php if($profile->membership_id): ?>
                            <p>And your membership expires on <b><?php echo e($profile->membership_expiry); ?></b></p>
                        <?php endif; ?>
                        </p>
                        
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Gender</label>
                        <input type="text" class="form-control" value="<?php echo e(ucfirst($profile->gender)); ?>" disabled>
                
                        <p class="text-muted mt-2">
                            If you want to change the gender, please contact the administrator. 
                            <a href="<?php echo e(route('seller.contact.admin')); ?>" class="text-primary">Contact Admin</a>
                        </p>
                    </div>
                </div>
                
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Age</label>
                        <input type="number" class="form-control" id="age_input" name="age" 
                            placeholder="Enter your age" value="<?php echo e($profile->age); ?>">
                        <?php if($errors->has('age')): ?>
                            <span class="help-block text-danger">
                                <strong><?php echo e($errors->first('age')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <input type="checkbox" id="show_age_checkbox" name="show_age" value="1" <?php echo e($profile->show_age ? 'checked' : ''); ?>>
                        <label>Show my age on my profile</label>
                    </div>
                </div>
                
<div class="col-sm-6">
                    <div class="form-group">
                        <label>Clothing Size</label>
                        <select class="form-control" id="clothing_size_select" name="clothing_size">
                            <option value="">Select Clothing Size</option>
                            <option value="xs" <?php echo e($profile->clothing_size == 'xs' ? 'selected' : ''); ?>>XS</option>
                            <option value="s" <?php echo e($profile->clothing_size == 's' ? 'selected' : ''); ?>>S</option>
                            <option value="m" <?php echo e($profile->clothing_size == 'm' ? 'selected' : ''); ?>>M</option>
                            <option value="l" <?php echo e($profile->clothing_size == 'l' ? 'selected' : ''); ?>>L</option>
                            <option value="xl" <?php echo e($profile->clothing_size == 'xl' ? 'selected' : ''); ?>>XL</option>
                            <option value="xxl" <?php echo e($profile->clothing_size == 'xxl' ? 'selected' : ''); ?>>XXL</option>
                            <option value="xxxl" <?php echo e($profile->clothing_size == 'xxxl' ? 'selected' : ''); ?>>XXXL</option>
                        </select>
                        <?php if($errors->has('clothing_size')): ?>
                            <span class="help-block text-danger">
                                <strong><?php echo e($errors->first('clothing_size')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <input type="checkbox" id="show_clothing_size_checkbox" name="show_clothing_size" value="1" <?php echo e($profile->show_clothing_size ? 'checked' : ''); ?>>
                        <label>Show my clothing size on my profile</label>
                    </div>
                </div>
                
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Type</label>
                        <select class="form-control" name="type">
                            <option value="German"  <?php echo e($profile->type == 'German' ? 'selected' : ''); ?>>German</option>
                            <option value="Western European"  <?php echo e($profile->type == 'Western European' ? 'selected' : ''); ?>>Western European</option>
                            <option value="European"  <?php echo e($profile->type == 'European' ? 'selected' : ''); ?>>European</option>
                            <option value="Scandinavian"  <?php echo e($profile->type == 'Scandinavian' ? 'selected' : ''); ?>>Scandinavian</option>
                            <option value="Eastern European"  <?php echo e($profile->type == 'Eastern European' ? 'selected' : ''); ?>>Eastern European</option>
                            <option value="Southern European"  <?php echo e($profile->type == 'Southern European' ? 'selected' : ''); ?>>Southern European</option>
                            <option value="Asian"  <?php echo e($profile->type == 'Asian' ? 'selected' : ''); ?>>Asian</option>
                            <option value="South and Latin American"  <?php echo e($profile->type == 'South and Latin American' ? 'selected' : ''); ?>>South and Latin American</option>
                            <option value="Oriental"  <?php echo e($profile->type == 'Oriental' ? 'selected' : ''); ?>>Oriental</option>
                            <option value="African American"  <?php echo e($profile->type == 'African American' ? 'selected' : ''); ?>>African American</option>
                            <option value="Exotic"  <?php echo e($profile->type == 'Exotic' ? 'selected' : ''); ?>>Exotic</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Figure</label>
                        <select class="form-control" name="figure">
                            <option value="Athletic" <?php echo e($profile->figure == 'Exotic' ? 'selected' : ''); ?>>Athletic</option>
                            <option value="Normal" <?php echo e($profile->figure == 'Normal' ? 'selected' : ''); ?>>Normal</option>
                            <option value="Slim" <?php echo e($profile->figure == 'Slim' ? 'selected' : ''); ?>>Slim</option>
                            <option value="Chubby" <?php echo e($profile->figure == 'Chubby' ? 'selected' : ''); ?>>Scandinavian</option>
                            <option value="Fat" <?php echo e($profile->figure == 'Fat' ? 'selected' : ''); ?>>Fat</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Hair Color</label>
                        <select class="form-control" name="hair_color">
                            <option value="Blonde"  <?php echo e($profile->hair_color == 'Blonde' ? 'selected' : ''); ?>>Blonde</option>
                            <option value="Brunette"  <?php echo e($profile->hair_color == 'Brunette' ? 'selected' : ''); ?>>Brunette</option>
                            <option value="Black"  <?php echo e($profile->hair_color == 'Black' ? 'selected' : ''); ?>>Black</option>
                            <option value="Red"  <?php echo e($profile->hair_color == 'Red' ? 'selected' : ''); ?>>Red</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Eye color</label>
                        <select class="form-control" name="eye_color">
                            <option value="Blue"  <?php echo e($profile->eye_color == 'Blue' ? 'selected' : ''); ?>>Blue</option>
                            <option value="Brown"  <?php echo e($profile->eye_color == 'Brown' ? 'selected' : ''); ?>>Brown</option>
                            <option value="Green"  <?php echo e($profile->eye_color == 'Green' ? 'selected' : ''); ?>>Green</option>
                            <option value="Grey"  <?php echo e($profile->eye_color == 'Grey' ? 'selected' : ''); ?>>Grey</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Address</label>
                        <input class="form-control" type="text" name="address" value="<?php echo e($profile ? $profile->address: ''); ?>" placeholder="Please enter your address...">
                        <?php if($errors->has('address')): ?>
                        <span class="help-block text-danger">
                            <strong><?php echo e($errors->first('address')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Profile Picture</label>
                        <input type="file" alt="" name="profile_picture" class="form-control" style="padding: 10px 20px;">
                         <?php if($errors->has('profile_picture')): ?>
                        <span class="help-block text-danger">
                            <strong><?php echo e($errors->first('profile_picture')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Instagram Link</label>
                        <input type="text" alt="" value="<?php echo e($profile ? $profile->instagram: ''); ?>" name="instagram" class="form-control" placeholder="instagram profile link">
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Onlyfans Link</label>
                        <input type="text" alt="" name="onlyfans" value="<?php echo e($profile ? $profile->onlyfans: ''); ?>" class="form-control" placeholder="onlyfans profile link">
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Snapchat Link</label>
                        <input type="text" alt="" name="snapchat" value="<?php echo e($profile ? $profile->snapchat: ''); ?>" class="form-control" placeholder="snapchat profile link">
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control" name="description" cols="30" rows="5"><?php echo e($profile ? $profile->description: ''); ?></textarea>
                        <?php if($errors->has('description')): ?>
                        <span class="help-block text-danger">
                            <strong><?php echo e($errors->first('description')); ?></strong>
                        </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group submit">
            <button class="ps-btn">Update</button>
        </div>
    </form>
</div>
<?php endif; ?>

    </div>
   <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('#show_age_checkbox').change(function () {
            if ($(this).is(':checked')) {
                // Checkbox selected → Age input me default age set karo
                $('#age_input').val("<?php echo e($profile->age ?? ''); ?>");
            } else {
                // Checkbox unselected → Age input ko empty karo
                $('#age_input').val('');
            }
        });
    });
    $(document).ready(function () {
        $('#show_clothing_size_checkbox').change(function () {
            if ($(this).is(':checked')) {
                // Checkbox selected → Clothing size ko default value de do
                $('#clothing_size_select').val("<?php echo e($profile->clothing_size ?? ''); ?>");
            } else {
                // Checkbox unselected → Clothing size empty kar do
                $('#clothing_size_select').val('');
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('seller.profile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/profile_components/user_information.blade.php ENDPATH**/ ?>