<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor3">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="<?php echo e(asset("app/favicon")); ?>/favicon-32.png" type="image/png" />
	<!--plugins-->
	<!-- Favicon -->


<!-- Plugins -->
<link href="<?php echo e(asset('admin/assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(asset('admin/assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(asset('admin/assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet" />

<!-- Loader -->
<link href="<?php echo e(asset('admin/assets/css/pace.min.css')); ?>" rel="stylesheet" />
<script src="<?php echo e(asset('admin/assets/js/pace.min.js')); ?>"></script>

<!-- Bootstrap & Core CSS -->
<link href="<?php echo e(asset('admin/assets/css/bootstrap.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(asset('admin/assets/css/bootstrap-extended.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(asset('admin/assets/css/app.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(asset('admin/assets/css/icons.css')); ?>" rel="stylesheet" />

<!-- Select2 (CDN) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet" />

<!-- Theme Style CSS -->
<link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/dark-theme.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/semi-dark.css')); ?>" />

	<link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/header-colors.css')); ?>" />
    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(env('GOOGLE_RECAPTCHA_KEY')); ?>"></script>
	<title>Dashboard - <?php echo e(env("APP_NAME", "Boilers2U")); ?></title>
	
    <link rel="stylesheet" href="//cdn.datatables.net/2.1.8/css/dataTables.dataTables.min.css">
    <?php echo $__env->yieldPushContent("css"); ?>
	<style>
		.submenu {
            display: none;
        }
		.submenu.active {
            display: block;
        }
		.switcher-btn{
			display: none;
		}


		.dropdown-menu {
    position: absolute;
    top: 50px;
    right: 0;
    display: none;
    width: 300px;
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 5px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
    z-index: 999;
    max-height: 400px;
    overflow-y: auto;
}

.dropdown-menu.show {
    display: block;
}

.dropdown-item {
    padding: 10px;
    border-bottom: 1px solid #eee;
    font-size: 14px;
    color: #333;
}

.dropdown-item:last-child {
    border-bottom: none;
}

/* Optional animation */
@keyframes ring {
    0% { transform: rotate(0); }
    1% { transform: rotate(15deg); }
    3% { transform: rotate(-10deg); }
    5% { transform: rotate(5deg); }
    7% { transform: rotate(-5deg); }
    9% { transform: rotate(3deg); }
    11% { transform: rotate(-2deg); }
    13% { transform: rotate(0); }
}

.ringing {
    animation: ring 1s ease-in-out;
}

  .dark-mode-icon i {
    font-size: 24px;
    color: #000;
    cursor: pointer;
  }

  .dark-mode-icon i:hover {
    font-size: 24px;
    color: #8833ff;
    cursor: pointer;
  }

  .dropdown-header {
    font-weight: bold;
    padding: 8px 12px;
    background-color: #f1f1f1;
    color: #333;
    font-size: 14px;
    border-bottom: 1px solid #ddd;
}

.dropdown-divider {
    margin: 4px 0;
    border-top: 1px solid #ccc;
}
.logo_div{
	background-color: #fff;
	width:35%;
}



    </style>
</head>

<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<div class="sidebar-wrapper" data-simplebar="true">
			<div class="sidebar-header">
				<div class="logo_div">
					<img src="<?php echo e(asset("img/logo2.png")); ?>" class="logo-icon" alt="logo icon" style="filter: unset; width:100%;">
				</div>
				
				<div class="toggle-icon ms-auto"><i class='bx bx-first-page'></i>
				</div>
			</div>
			<!--navigation-->
			<ul class="metismenu" id="menu">
				<li>
					<a href="/">
						<div class="parent-icon"><i class='bx bx-home'></i>
						</div>
						<div class="menu-title">Website</div>
					</a>
				</li>
				<li>
					<a href="<?php echo e(route("admin.dashboard")); ?>">
						<div class="parent-icon"><i class='bx bx-home'></i>
						</div>
						<div class="menu-title">Dashboard</div>
					</a>
				</li>
				
				<li class="menu-label">Navigation</li>
				<li>
                    <a href="javascript:;" class="has-arrow seller-menu">
                        <div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
                        </div>
                        <div class="menu-title">Sellers</div>
                    </a>
                    <ul class="seller-dropdown" style="display: none;">
						<li> <a href="<?php echo e(route('admin.seller_profiles')); ?>"><i class="bx bx-right-arrow-alt"></i>All Sellers</a>
						</li>
						<li> <a href="<?php echo e(route('admin.pending_sellers')); ?>"><i class="bx bx-right-arrow-alt"></i>Pending Sellers</a>
						</li>
						<li> <a href="<?php echo e(route('admin.verified_sellers')); ?>"><i class="bx bx-right-arrow-alt"></i>Verified Sellers</a>
						</li>
						<li> <a href="<?php echo e(route('admin.locked_sellers')); ?>"><i class="bx bx-right-arrow-alt"></i>Locked Sellers</a>
						</li>
						<li> <a href="<?php echo e(route('admin.verify_seller')); ?>"><i class="bx bx-right-arrow-alt"></i>Verify Seller</a>
						</li>
						<li> <a href="<?php echo e(route('admin.profile.settings')); ?>"><i class="bx bx-right-arrow-alt"></i>Ad Limit Setting</a>
						</li>
						<li> <a href="<?php echo e(route('admin.get_seller_address')); ?>"><i class="bx bx-right-arrow-alt"></i>Seller Activity Log</a>
						</li>
						<li> <a href="<?php echo e(route('admin.gendermessages')); ?>"><i class="bx bx-right-arrow-alt"></i>Messages for Gender</a>
						</li>
						<li> <a href="<?php echo e(route('admin.seller_messages')); ?>"><i class="bx bx-right-arrow-alt"></i>Messages</a>
						</li>
					</ul>
				</li>
				<li>
					<a href="javascript:;" class="has-arrow">
						<div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
                            
						</div>
						<div class="menu-title">Products</div>
					</a>
					<ul>
						<li> <a href="<?php echo e(route('admin.products')); ?>"><i class="bx bx-right-arrow-alt"></i>All Products</a>
						</li>
						<li> <a href="<?php echo e(route('admin.add_category')); ?>"><i class="bx bx-right-arrow-alt"></i>Create New Category</a>
						</li>
						<li> <a href="<?php echo e(route('admin.categories')); ?>"><i class="bx bx-right-arrow-alt"></i>Categories</a>
						</li>
                        
						</li>
						
						</li>
						<li> <a href="<?php echo e(route('admin.cans')); ?>"><i class="bx bx-right-arrow-alt"></i>Cans</a>
						</li>
						<li> <a href="<?php echo e(route('admin.orders')); ?>"><i class="bx bx-right-arrow-alt"></i>Orders</a>
						</li>
						<li> <a href="<?php echo e(route('admin.reports')); ?>"><i class="bx bx-right-arrow-alt"></i>Reports</a>
						</li>
                        <li> <a href="<?php echo e(route('seller.testing')); ?>"><i class="bx bx-right-arrow-alt"></i>Seller Message</a>
						</li>
					</ul>
				</li>
				<li>
					<a href="javascript:;" class="has-arrow">
						<div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
						</div>
						<div class="menu-title">Lovecan Store</div>
					</a>
					<ul>
						<li> <a href="<?php echo e(route('admin.seller-offers')); ?>"><i class="bx bx-right-arrow-alt"></i>Seller Offers</a>
						</li>
					</ul>
				</li>
				<li>
					<a href="javascript:;" class="has-arrow">
						<div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
                            
						</div>
						<div class="menu-title">Payments</div>
					</a>
					<ul>
						<li> <a href="<?php echo e(route('admin.seller-payout-requests')); ?>"><i class="bx bx-right-arrow-alt"></i>Seller Requests</a>
						</li>
						<li> <a href="<?php echo e(route('admin.seller-released-payout')); ?>"><i class="bx bx-right-arrow-alt"></i>Released Seller Payouts</a>
						</li>
						<li> <a href="<?php echo e(route('admin.seller-rejected-payout-requests')); ?>"><i class="bx bx-right-arrow-alt"></i>Rejected Seller Requests</a>
						</li>
						<li> <a href="<?php echo e(route('admin.payment_getways')); ?>"><i class="bx bx-right-arrow-alt"></i>Payment Gateways</a>
						</li>
					</ul>
				</li>
				<li>
					<a href="javascript:;" class="has-arrow">
						<div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
						</div>
						<div class="menu-title">Customer</div>
					</a>
					<ul>
						<li> <a href="<?php echo e(route('admin.customer-messages')); ?>"><i class="bx bx-right-arrow-alt"></i>Customer Messages</a>
						</li>
						<li> <a href="<?php echo e(route('admin.customerlist')); ?>"><i class="bx bx-right-arrow-alt"></i>Customer List</a>
						</li>
					</ul>
				</li>
				<li>
					<a href="javascript:;" class="has-arrow">
						<div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
						</div>
						<div class="menu-title">Membership</div>
					</a>
					<ul>
						<li> <a href="<?php echo e(route('admin.membership')); ?>"><i class="bx bx-right-arrow-alt"></i>All membership</a>
						</li>
						
					</ul>
				</li>
				<li>
					<a href="javascript:;" class="has-arrow">
						<div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
						</div>
						<div class="menu-title">Ad Promotions</div>
					</a>
					<ul>
						<li> <a href="<?php echo e(route('admin.settings')); ?>"><i class="bx bx-right-arrow-alt"></i>All Ad Promotions </a>
						</li>
						
						</li>
					</ul>
				</li>
				
                <li>
					<a href="javascript:;" class="has-arrow">
						<div class="parent-icon">
                            <i class="text-white" data-feather="smartphone"></i>
						</div>
						<div class="menu-title">Banner Slider</div>
					</a>
					<ul>
						<li> <a href="<?php echo e(route('slider.index')); ?>"><i class="bx bx-right-arrow-alt"></i>Show Slider</a>
						</li>
					</ul>
				</li>
                
			</ul>
			<!--end navigation-->
		</div>
		<!--end sidebar wrapper -->
		<!--start header -->
		<header>
			<div class="topbar d-flex align-items-center">
				<nav class="navbar navbar-expand gap-3">
					<div class="mobile-toggle-menu"><i class='bx bx-menu'></i>
					</div>
					<div class="top-menu-left d-none d-lg-block">
				 	 <ul class="nav">
						<li class="nav-item">
						  
						</li>
						<li class="nav-item">
						  
						</li>
						<li class="nav-item">
						  
						</li>
						<li class="nav-item">
							
						</li>
					</ul>
				   </div>
					<div class="search-bar flex-grow-1">
						<div class="position-relative search-bar-box">
							<form>
							  <input type="text" class="form-control search-control" autofocus placeholder="Search for Sellers...."> <span class="position-absolute top-50 search-show translate-middle-y"><i class='bx bx-search'></i></span>
							   <span class="position-absolute top-50 search-close translate-middle-y"><i class='bx bx-x'></i></span>
						    </form>
						</div>
					</div>
					<div class="top-menu ms-auto">
						<ul class="navbar-nav align-items-center gap-1">
							<li class="nav-item dark-mode d-none d-sm-flex position-relative">
								<a class="nav-link dark-mode-icon" href="javascript:;" onclick="toggleNotifications(this)">
									<i class='bx bxs-bell-ring'></i>
								  </a>
								  
								  <div class="dropdown-menu" id="notificationDropdown">
									<div id="notificationContent">
									  <!-- JS will inject content here -->
									</div>
								  </div>
								  
							</li>
						</ul>
					</div>
					


					<div class="user-box dropdown">
						<a class="d-flex align-items-center nav-link dropdown-toggle dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
							
							<div class="user-info ps-3">
								<p class="user-name mb-0">Test User</p>
								<p class="designattion mb-0">Adminstrator</p>
							</div>
							<ul class="dropdown-menu dropdown-menu-end">
								<li>
									<div class="dropdown-divider mb-0"></div>
								</li>
								<li><a class="dropdown-item " href="<?php echo e(route('logout')); ?>"><i class='bx bx-log-out-circle'></i><span>Logout</span></a>
								</li>
							</ul>
						</a>

					</div>
				</nav>
			</div>
		</header>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
            <?php echo $__env->yieldContent("content"); ?>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2024. All right reserved <a href="<?php echo e(route("admin.dashboard")); ?>"><strong>AZsolutions</strong></a>.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<div class="switcher-wrapper">
		<div class="switcher-btn"> <i class='bx bx-cog bx-spin'></i>
		</div>
		<div class="switcher-body">
			<div class="d-flex align-items-center">
				<h5 class="mb-0 text-uppercase">Theme Customizer</h5>
				<button type="button" class="btn-close ms-auto close-switcher" aria-label="Close"></button>
			</div>
			<hr/>
			<h6 class="mb-0">Theme Styles</h6>
			<hr/>
			<div class="d-flex align-items-center justify-content-between">
				<div class="form-check">
					<input class="form-check-input" type="radio" name="flexRadioDefault" id="lightmode" checked>
					<label class="form-check-label" for="lightmode">Light</label>
				</div>
				<div class="form-check">
					<input class="form-check-input" type="radio" name="flexRadioDefault" id="darkmode">
					<label class="form-check-label" for="darkmode">Dark</label>
				</div>
				<div class="form-check">
					<input class="form-check-input" type="radio" name="flexRadioDefault" id="semidark">
					<label class="form-check-label" for="semidark">Semi Dark</label>
				</div>
			</div>
			<hr/>
			<div class="form-check">
				<input class="form-check-input" type="radio" id="minimaltheme" name="flexRadioDefault">
				<label class="form-check-label" for="minimaltheme">Minimal Theme</label>
			</div>
			<hr/>
			<h6 class="mb-0">Header Colors</h6>
			<hr/>
			<div class="header-colors-indigators">
				<div class="row row-cols-auto g-3">
					<div class="col">
						<div class="indigator headercolor1" id="headercolor1"></div>
					</div>
					<div class="col">
						<div class="indigator headercolor2" id="headercolor2"></div>
					</div>
					<div class="col">
						<div class="indigator headercolor3" id="headercolor3"></div>
					</div>
					<div class="col">
						<div class="indigator headercolor4" id="headercolor4"></div>
					</div>
					<div class="col">
						<div class="indigator headercolor5" id="headercolor5"></div>
					</div>
					<div class="col">
						<div class="indigator headercolor6" id="headercolor6"></div>
					</div>
					<div class="col">
						<div class="indigator headercolor7" id="headercolor7"></div>
					</div>
					<div class="col">
						<div class="indigator headercolor8" id="headercolor8"></div>
					</div>
				</div>
			</div>
			<hr/>
			<h6 class="mb-0">Sidebar Backgrounds</h6>
			<hr/>
			<div class="header-colors-indigators">
				<div class="row row-cols-auto g-3">
					<div class="col">
						<div class="indigator sidebarcolor1" id="sidebarcolor1"></div>
					</div>
					<div class="col">
						<div class="indigator sidebarcolor2" id="sidebarcolor2"></div>
					</div>
					<div class="col">
						<div class="indigator sidebarcolor3" id="sidebarcolor3"></div>
					</div>
					<div class="col">
						<div class="indigator sidebarcolor4" id="sidebarcolor4"></div>
					</div>
					<div class="col">
						<div class="indigator sidebarcolor5" id="sidebarcolor5"></div>
					</div>
					<div class="col">
						<div class="indigator sidebarcolor6" id="sidebarcolor6"></div>
					</div>
					<div class="col">
						<div class="indigator sidebarcolor7" id="sidebarcolor7"></div>
					</div>
					<div class="col">
						<div class="indigator sidebarcolor8" id="sidebarcolor8"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--end switcher-->
	<!-- Bootstrap JS -->
	<!-- Bootstrap Bundle -->
	<script src="<?php echo e(asset('admin/assets/js/bootstrap.bundle.min.js')); ?>"></script>
	<script src="<?php echo e(asset('admin/assets/js/jquery.min.js')); ?>"></script>

	<!-- Core Plugins -->
	<script src="<?php echo e(asset('admin/assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
	<script src="<?php echo e(asset('admin/assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
	<script src="<?php echo e(asset('admin/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>

	<!-- Select2 (CDN + Custom) -->
	<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
	<script src="<?php echo e(asset('admin/assets/plugins/select2/js/select2-custom.js')); ?>"></script>

    <script src="<?php echo e(asset("admin/assets/plugins/feature-icons/feature-icon.min.js")); ?>"></script>
    <script src="https://unpkg.com/feather-icons"></script>
	<script>
		feather.replace()
	</script>
	<!--app JS-->
	<script src="<?php echo e(asset("admin/assets/js/app.js")); ?>"></script>

	



    <script src="//cdn.datatables.net/2.1.8/js/dataTables.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script>
		let table = new DataTable('#datatable');
	</script>
    <?php echo $__env->yieldPushContent("scripts"); ?>

    <script>

window.routes = {
        sellerProfiles: "<?php echo e(route('admin.seller_profiles')); ?>",
        products: "<?php echo e(route('admin.products')); ?>"
    };


      document.addEventListener("DOMContentLoaded", function () {
    let dropdownMenus = document.querySelectorAll(".has-arrow");

    dropdownMenus.forEach(menu => {
        menu.addEventListener("click", function (e) {
            e.preventDefault();

            let subMenu = this.nextElementSibling;

            if (subMenu.style.display === "none" || subMenu.style.display === "") {
                subMenu.style.display = "block";
            } else {
                subMenu.style.display = "none";
            }
        });
    });
});


function toggleNotifications(el) {
    const icon = el.querySelector('i');
    icon.classList.remove('ringing');
    void icon.offsetWidth; // reflow
    icon.classList.add('ringing');

    const dropdown = document.getElementById('notificationDropdown');
    const content = document.getElementById('notificationContent');

    // Toggle dropdown
    const isOpen = dropdown.classList.contains('show');
    if (isOpen) {
        dropdown.classList.remove('show');
        return;
    } else {
        dropdown.classList.add('show');
    }

    // Show loading message
    content.innerHTML = '<div class="dropdown-item">Loading...</div>';

    // Fetch notifications from server
    fetch('/admin/notification')
        .then(res => {
            if (!res.ok) {
                throw new Error(`HTTP error! Status: ${res.status}`);
            }
            return res.json();
        })
        .then(data => {
            let html = '';

            // Display pending users
            if (data.users && data.users.length > 0) {
                html += '<h2 class="dropdown-header">Pending Users:</h2>';
                data.users.forEach(user => {
                    html += `
                        <a class="dropdown-item" href="${routes.sellerProfiles}">
                            ${user.name || 'Unnamed'}, ${user.email}
                        </a>
                    `;
                });
            }

            // Separator if both users and products exist
            if (data.users.length > 0 && data.products.length > 0) {
                html += '<hr class="dropdown-divider">';
            }

            // Display unapproved products
            if (data.products && data.products.length > 0) {
                html += '<h2 class="dropdown-header">Unapproved Products:</h2>';
                data.products.forEach(product => {
                    html += `
                        <a class="dropdown-item" href="${routes.products}">
                            ${product.title || 'Untitled'}
                        </a>
                    `;
                });
            }

            // If no data, display a message
            if (!html) {
                html = '<div class="dropdown-item">No notifications found.</div>';
            }

            content.innerHTML = html;
        })
        .catch(error => {
            console.error('Fetch error:', error);
            content.innerHTML = `<div class="dropdown-item text-danger">Error loading notifications: ${error.message}</div>`;
        });

    // Close dropdown if clicked outside
    setTimeout(() => {
        document.addEventListener('click', function outsideClick(e) {
            if (!el.contains(e.target) && !dropdown.contains(e.target)) {
                dropdown.classList.remove('show');
                document.removeEventListener('click', outsideClick);
            }
        });
    }, 10);
}






    </script>
</body>

</html>
<?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/layouts/admin.blade.php ENDPATH**/ ?>