

<?php $__env->startSection('content'); ?>
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>

    
    <div>
        <div class="ps-section__content pt-3">
            <div class="row justify-content-center card m-3">
                <div class="col-lg-12 mt-3">
                    <h3>All Products</h3>
                    <form method="GET" action="<?php echo e(route('admin.products')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search by title" 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.products')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Description</th>
                                    <th>Worn Days</th>
                                    <th>Price</th>
                                    <th>Payment Status</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $i = 0;
                                ?>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="align-content-center">
                                    <td><?php echo e(++$i); ?></td>
                                    <td>
                                        <a href="<?php echo e(asset('storage/ads/' . $item->image)); ?>" target="_blank">
                                            <img src="<?php echo e(asset('storage/ads/' . $item->image)); ?>" alt="" style="width: 50px;border-radius:50px">
                                        </a>
                                    </td>
                                    <td><?php echo e($item->title); ?></td>
                                    <td><?php echo e($item->type); ?></td>
                                    <td><?php echo e(\Illuminate\Support\Str::limit(strip_tags($item->description), 30, '...')); ?></td>
                                    <td><?php echo e($item->worn_days); ?></td>
                                    <td>$<?php echo e($item->price); ?></td>
                                    <td>
                                        <?php if($item->sellerpayment): ?>
                                            <p class="payment-status <?php echo e($item->sellerpayment->payment_status == 'Success' ? 'text-success' : ($item->sellerpayment->payment_status == 'Failed' ? 'text-danger' : 'text-success')); ?>">
                                                <?php echo e($item->sellerpayment->payment_status); ?>

                                        <?php else: ?>
                                            <p class="text-danger">Not Paid</p>
                                        <?php endif; ?>
                                    </td>
                                    
                                    <td>
                                        <form action="<?php echo e(route('admin.update-product-status', $item->id)); ?>" class="d-flex" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <select name="status" id="" class="form-control mx-1" style="width: fit-content">
                                                <option value="Approved" <?php echo e($item->status == 'Approved' ? "selected" : ""); ?>>Approved</option>
                                                <option value="Unapproved" <?php echo e($item->status == 'Unapproved' ? "selected" : ""); ?>>Unapproved</option>
                                                <option value="Blocked" <?php echo e($item->status == 'Blocked' ? "selected" : ""); ?>>Blocked</option>
                                            </select>
                                            <input type="submit" name="" value="Update" class="form-control btn btn-primary">
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($products->count() === 0): ?>
                                <tr>
                                    <td colspan="9">
                                        <p class="text-center">No Products</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $products->withQueryString()->links('pagination::bootstrap-5'); ?>

                </div>
            </div>
        </div>    
    </div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/products.blade.php ENDPATH**/ ?>