

<?php $__env->startSection('content'); ?>
    <style>
        
        th,td {
            border: 1px solid #ddd;
            text-align: center; /* Centers text horizontally */
            vertical-align: middle; /* Centers text vertically */
            padding: 10px;
        }

    </style>
    <div>
        <div class="ps-section__content">
            <div class="d-flex justify-content-between align-items-center ml-5 col-lg-12 mt-3 p-3">
            <h3>All Ad Promotion</h3>
            <a href="<?php echo e(route('admin.setting')); ?>" class="btn btn-primary mb-3">Add New Promotion</a>
            </div>
            <div class="row  justify-content-center">
                <div class="card col-lg-11 mt-3 p-3">
                    
                    <form method="GET" action="<?php echo e(route('admin.settings')); ?>">
                        <div class="input-group mb-3">
                            <input 
                                type="text" 
                                name="search" 
                                class="form-control" 
                                placeholder="Search ......" 
                                value="<?php echo e(request('search')); ?>">
                            <button class="btn btn-primary" type="submit">Search</button>
                            <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>

                    <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>promotion_fee</th>
                                    <th>promotion_duration</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($setting->id); ?></td>
                                        <td><?php echo e($setting->promotion_fee); ?></td>
                                        <td><?php echo e($setting->promotion_duration); ?></td>
                                        <td><?php echo e($setting->created_at->format('d-m-Y h:i:s A')); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('admin.settings.edit', $setting->id)); ?>">
                                                <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAThJREFUSEvl1b1KxEAUhuFnK7HSSgTBQgQt9AYsrO28A6/AUlErFWT97fQWbLW1F7wBsRNBEMRC0M5K3QNZiMlmmUS38kBIQma+d853zmRaBhytAev7S8AxXnCSX3QRsIwDzPbJ7BMrOM+NOcVq9r6ehxQBT5ioKT6GW8S9G1vZQksWfWUjUq0bxRumcY3xbP4GjuK5KFQHsIa4FjqWPWAKN9jDWTeVpoBN7Gciz1jEPUbw3q/IKRmEv+1CnQIyj9di/epmEJZEOxYjWjO6pxR1AKniS7iqW4MdbCesPMQvMVwHEMIBSLHlo1P8oXx3pljULXweUOV5qUmaACKb3Yrd/mvAj/9MD0gjQJ9fU+nTPwA8YrKOJz3G3mGuah/EgXOImYaQOBeiyy6qAA11q6elHiyNwQMHfAOdL0QZH51cjgAAAABJRU5ErkJggg=="/>
                                            </a>
                                            <button type="button" class="btn" data-bs-toggle="modal" data-bs-target="#deleteModal" data-id="<?php echo e($setting->id); ?>">
                                                <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAKRJREFUSEvtlUEKgCAQRV93CYK6TsdpGXSZrlPQaYpAXVjDt8xd7mR03v8z6FQUXlXh/ChAD4xAYwjZgAGYLaEKsACtcLkC3VvA7i5aQlRclkglUPELwF/I7X1wHFsvDvDKpfXIonn+dfO+BsQK1T7wUx2ohNkl+gGXd/W0JH8P5NeUXSJFeAxIGTQx9HbwWC/5HJUTUCvpLm6OTjUyE/Pbx4oDDlBhOBmYaWrOAAAAAElFTkSuQmCC"/>
                                            </button>                                            
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($settings->isEmpty()): ?>
                                    <tr>
                                        <td colspan="8">
                                            <p class="text-center">No settings . . . !</p>
                                        </td>
                                    </tr>
                                    
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                     <?php echo $settings->withQueryString()->links('pagination::bootstrap-5'); ?>

                </div>
               
            </div>
        </div>    
    </div>



<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this setting?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>




    <script>
        document.addEventListener('DOMContentLoaded', function () {
    const deleteModal = document.getElementById('deleteModal');
    const deleteForm = document.getElementById('deleteForm');

    deleteModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const id = button.getAttribute('data-id');
        deleteForm.action = `/admin/settings/${id}`;
    });
});

    </script>    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azsoluti/public_html/uecommerce.azsolutionspk.com/resources/views/admin/settings.blade.php ENDPATH**/ ?>