<?php

use App\Http\Controllers\AccountController;
use App\Http\Controllers\AdController;
use App\Http\Controllers\admin\PlanController;
use App\Http\Controllers\admin\MembershipController;
use App\Http\Controllers\admin\ProductController;
use App\Http\Controllers\admin\SellerController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\CanController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\MembershipPaymentController;
use App\Http\Controllers\LovecanController;
// use App\Http\Controllers\PaymentController;
use App\Http\Controllers\admin\PaymentController;
use App\Http\Controllers\BannerSliderController;
use App\Http\Controllers\PayoutController;
use App\Http\Controllers\PaypalController;
use App\Http\Controllers\UserMediaController;
use App\Http\Controllers\OTPController;
use App\Http\Controllers\SectionRightController;
use App\Http\Middleware\EnsureProfileOwnership;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StripePaymentController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\SwitchPaymentController;
// use App\Http\Middleware\EnsureProfileCreated;
use App\Http\Middleware\IsAdminMiddleware;
use App\Http\Middleware\IsLoggedIn;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use App\Models\Ad;
use App\Models\Category;
use App\Models\MediaFile;
use App\Models\BannerSlider;
use App\Models\SectionRight;
use App\Models\Plan;
use Illuminate\Support\Facades\Auth;
use Laravel\Cashier\Subscription;

// verify email

// Route::get('/verify-email/{token}', [UserController::class, 'verify'])->name('verify.email');
// Route::get('/email/verify', function () {
//     if(Auth::user()->hasVerifiedEmail()){
//         if(Auth::user()->role === 'admin'){
//             return redirect()->route('admin.dashboard');
//         }
//         return redirect('/profile');
//     }
//     return view('auth.verify-email');
// })->middleware('auth')->name('verification.notice');

// Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
//     $request->fulfill();

//     if(Auth::user()->role === 'admin'){
//         return redirect()->route('admin.dashboard');
//     }
//     return redirect('/profile');
// })->middleware(['auth', 'signed'])->name('verification.verify');

// Route::post('/email/verification-notification', function (Request $request) {
//     $request->user()->sendEmailVerificationNotification();
//     return back()->with('message', 'Verification link sent!');
// })->middleware(['auth', 'throttle:6,1'])->name('verification.send');


Route::get('/clear-all', function () {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear'); // optional: clears compiled Blade views
    return 'All caches cleared successfully!';
})->name('clear.all');



// Guest Routes
Route::get('/', function () {
    $ads = Ad::whereHas('user', function ($query) {
        $query->whereHas('profile', function ($query) {
            $query->where('status', 'verified');
        });
    })->where('is_promoted', 1)
    ->where('status','Approved')
    ->where('ad_status', 'active')
    ->orderBy('id', 'desc')
    ->get();
    $mediaItems = MediaFile::all();
    $categories = Category::all();
    $bannersliders = BannerSlider::all();
    $sectionrights = SectionRight::all();
    return view('user.index', compact('ads','mediaItems', 'categories', 'bannersliders', 'sectionrights'));
})->name('home');
Route::get('/product', function () {
    return view('user.product');
});
Route::get('/category', function () {
    return view('user.category');
});

// customer Routes
Route::get('/cart', function () {
    return view('user.cart');
});


Route::get('/product-details/{id}', function ($product_id) {
    $product = Ad::with('user')->where('id', $product_id)->first();
    // $product = Ad::findOrFail($product_id);
    if($product && $product->status == 'Approved'){
        return view('user.product-details',compact('product'));
    }
    return redirect()->back();
})->name('user.product.details');
Route::get('/about-us', function () {
    return view('user.about-us');
})->name('user.about-us');

Route::get('/product', function () {
    $ads = Ad::all();
    return view('user.productss', compact('ads'));
})->name('user.productss');

Route::get('/category', function () {
    $categorys = Category::all();
    return view('user.categories', compact('categorys'));
})->name('user.categories');

Route::get('/media', function () {
    $medias = MediaFile::all();
    return view('user.medias', compact('medias'));
})->name('user.medias');

Route::get('/vending-machines', function () {
    return view('user.vending-machines');
})->name('user.vending-machines');
Route::get('/contact-us', function () {
    return view('user.contact-us');
})->name('user.contact-us');

Route::get('/help-support', function () {
    return view('user.help-support');
})->name('user.help-support');
Route::get('/how-to-sell', function () {
    return view('user.how-to-sell');
})->name('user.how-to-sell');
Route::get('/term-condition', function () {
    return view('user.term-condition');
})->name('user.term-condition');
Route::get('/faqs', function () {
    return view('user.faqs');
})->name('user.faqs');

Route::get('/checkout', function () {
    return view('user.checkout');
});

Route::get('/privacyPolicy', function () {
    return view('user.privacyPolicy');
})->name('user.privacyPolicy');

Route::get('seller/{name}', function (string $name) {
    $profile = \App\Models\Profile::where('nickname', $name)->first();

    if (!$profile) {
        return redirect()->route('home');
    }

    $ads = \App\Models\Ad::where('user_id', $profile->user_id)->get();

    return view('user.sellerProfile', compact('profile', 'ads'));
})->name('user.sellerProfile');


Route::controller(CustomerController::class)->group(function(){
    Route::post('/checkout', 'checkout')->name('stripe.order-payment');
    Route::post('/payment', 'payment')->name('customer.payment');
    Route::post('/contact', 'contact')->name('customer.contact');
    Route::post('/verify-cart', 'verify_cart');
    Route::post('/search', 'detailed_search')->name('user.detailed-search');
});

// Seller Routes
Route::get('/login', function () {
    return view('seller.login');
})->name('login');
Route::post('/login', [UserController::class, 'login']);
Route::get('/register', function () {
    return view('seller.register');
})->name('register');
Route::post('/user-register', [UserController::class, 'register'])->name('user-register');
Route::post('/otp/verifys', [UserController::class, 'verifyOtp'])->name('otps.verifys');

// Route::middleware([IsLoggedIn::class])->group(function () {

// });

Route::get('/logout', [UserController::class, 'logout'])->name('logout');
Route::middleware(['auth'])->group(function () {
    Route::get('profile/create', [ProfileController::class, 'create'])->name('profile.create');
    Route::post('profile/store', [ProfileController::class, 'store'])->name('profile.store');
    Route::post('profile/create/account', [ProfileController::class, 'onPageRloadCreateAccountNumber'])->name('profile.create-account');
});

Route::controller(AdController::class)->group(function(){
    Route::get('createad', 'create')->name('ad.create');
    Route::post('createad','store')->name('ad.store');
    Route::get('editad/{ad}', 'edit')->name('ad.edit');
    Route::post('editad/{ad}','update')->name('ad.update');
    Route::post('/ad-status-update/{id}', 'ad_status_update')->name('ad.status-update');
    Route::delete('/ad/delete/{id}', 'destroy')->name('ad.delete');
    Route::get('/ad/return-back', 'return_back')->name('ad.return-back');
    Route::get('/ad/return-back-failed', 'return_back_failed')->name('ad.return-back-failed');
    Route::post('/report-product/{id}', 'report')->name('user.report');
    Route::get('/promote/{id}', 'promote')->name('ad.promote');
});

Route::middleware(['auth'])->group(function () {

    Route::controller(AccountController::class)->group(function(){
        Route::get('seller/add-account/{id}', 'add_account')->name('seller.create-account');
        Route::post('seller/add-account', 'add_seller_account')->name('seller.add-account');
        Route::get('seller/delete-account', 'delete_account')->name('seller.delete-account');

    });


    Route::controller(PaymentController::class)->group(function(){
        Route::post('/ads/promote/{id}','processPayment')->name('payment.pay');
        Route::get('/payment/success', 'paymentSuccess')->name('payment.success');
        Route::get('/payment/cancel', 'paymentCancel')->name('payment.cancel');
        Route::get('/ads/promote-form/{id}', 'addpromote')->name('payment.process');
    });


    Route::post('/change-password', [UserController::class, 'update_password'])->name('profile.update_password');
    Route::get('/get_seller_address', [UserController::class,'get_seller_address'])->name('admin.get_seller_address');
    Route::post('/verification', [UserController::class,'verification'])->name('profile.verifications');
    Route::get('verify-phone', [UserController::class, 'showVerifyForm'])->name('verify-phone');
    Route::post('verify-phone', [UserController::class, 'verifyPhone'])->name('verify-phone.post');
    Route::get('/otp-verify', [UserController::class, 'showOtpForm'])->name('otp.verify.form');
    Route::post('/otp-verifyed', [UserController::class, 'verifyOtp'])->name('otp.verify');

    Route::get('/verification', [ProfileController::class, 'verification'])->name('profile.verification');
    Route::get('profile/user-information', [ProfileController::class, 'user_information'])->name('profile.user_information');
    Route::get('profile/change-password', [ProfileController::class, 'change_password'])->name('profile.change_password');
    Route::get('profile/orders', [ProfileController::class, 'orders'])->name('profile.orders');
    Route::get('profile/offers', [ProfileController::class, 'offers'])->name('profile.offers');
    Route::post('profile/add-link', [ProfileController::class, 'add_link'])->name('profile.add-tracking-link');
    Route::post('profile/offer-sent-status', [ProfileController::class, 'offer_sent_status'])->name('profile.update-offer-status');
    Route::get('profile/balance', [ProfileController::class, 'balance'])->name('profile.balance');
    Route::get('profile/seller-account', [ProfileController::class, 'add_seller'])->name('profile.seller-account');
    Route::get('profile/read-messages', [ProfileController::class, 'read_messages'])->name('profile.read_messages');
    Route::get('/message',[ProfileController::class,'message'])->name('profile.message');
    Route::post('sendmessage', [ProfileController::class,'sendmessage'])->name('profile.sendmessage');

    Route::get('profile', [ProfileController::class, 'show'])->name('profile.show');
    Route::put('profile/{profile}', [ProfileController::class, 'update'])->name('profile.update');
    Route::put('profile/{profile}/image', [ProfileController::class, 'imageUpdate'])->name('profile.image.update');

    Route::get('store', function(){
        return view('seller.store.index');
    });

    // cans
    Route::controller(CanController::class)->group(function(){
        Route::post('store/buycans','buyCans')->name('store.cans.buy');
        Route::post('cans/checkout','checkout')->name('stripe.cans-payment');
        Route::post('cans/status-update/{id}','status_update')->name('cans.status-update');
    });


    Route::middleware([IsAdminMiddleware::class])
    ->controller(AdminController::class)
    ->group(function () {
        Route::get('/admin/dashboard', 'index')->name('admin.dashboard');
        Route::get('/admin/seller-profiles', 'seller_profiles')->name('admin.seller_profiles');
        Route::get('/admin/seller-activity-log', 'selleractivitylog')->name('admin.seller-activity-log');
        Route::get('/admin/verify-seller', 'verify_seller')->name('admin.verify_seller');
        Route::get('/admin/pending-sellers', 'pending_sellers')->name('admin.pending_sellers');
        Route::get('/admin/locked-sellers', 'locked_sellers')->name('admin.locked_sellers');
        Route::get('/admin/verified-sellers', 'verified_sellers')->name('admin.verified_sellers');
        Route::get('/admin/edit-seller/{id}', 'edit_seller')->name('admin.edit_seller');
        Route::get('/admin/lovecans/approve/{id}', 'approveLovecansAd')->name('admin.lovecans.approve');
        Route::get('/adminlovecanwomen','adminlovecanwomen')->name('admin.lovecanwomen');
        Route::get('/showMediaLinks', 'showMediaLinks')->name('admin.showMediaLinks');
        Route::get('admin/profile-settings', 'showProfileSettings')->name('admin.profile.settings');
        Route::post('admin/profile-update',  'updateProfileupdate')->name('admin.profile.update');
        Route::post('/admin/update-seller', 'update_seller')->name('admin.update_seller');
        Route::get('/admin/cans', 'cans')->name('admin.cans');
        Route::post('/admin/update-cans', 'updateCans')->name('admin.update-cans');
        Route::get('/admin/orders', 'orders')->name('admin.orders');
        Route::get('/admin/add-category', 'add_category')->name('admin.add_category');
        Route::get('/admin/edit-category/{id}', 'editcategory')->name('admin.edit-category');
        Route::post('/admin/update-category/{id}', 'updatecategory')->name('admin.update-category');
        Route::get('/admin/delete-category/{id}', 'delete_category')->name('admin.delete-category');
        Route::post('/admin/add-category', 'store_category')->name('admin.store_category');
        Route::get('/admin/reports', 'reports')->name('admin.reports');
        Route::get('/admin/categories', function(){
            $categories = Category::orderBy('id', 'desc')->paginate(10);
            return view('admin.categories', compact('categories'));
        })->name('admin.categories');

        Route::get('/admin/customer-messages', 'get_customer_messages')->name('admin.customer-messages');
        Route::get('/admin/notification', 'get_all_notification')->name('admin.notification');
        Route::get('/admin/customer-list', 'customerlist')->name('admin.customerlist');
        Route::get('/admin/customerlistdelete/{id}', 'deletecustomerlist')->name('admin.deletecustomerlist');
        Route::post('/admin/customer-update/{id}','customerlistupdate')->name('admin.customerlistupdate');
        Route::get('/admin/add-promotion', 'setting')->name('admin.setting');
        Route::get('/admin/promotions',  'settings')->name('admin.settings');
        Route::post('/admin/settings/add',  'addSettings')->name('admin.settings.add');
        Route::get('admin/edit-promotion/{id}',  'editSettings')->name('admin.settings.edit');
        Route::post('/admin/settingsupdate/{id}',  'updateSettings')->name('admin.settings.update');
        Route::delete('/admin/settings/{id}', 'deletesettings')->name('admin.deletesettings');
    });

    Route::controller(PayoutController::class)->group(function(){
        Route::post('/seller/payouts', 'payout_request')->name('seller.payout-request');
        Route::get('/admin/payout-requests', 'get_payout_requests')->name('admin.seller-payout-requests');
        Route::get('/admin/payment-getways', 'payment_getways')->name('admin.payment_getways');
        Route::get('/admin/released-payout', 'get_released_payout')->name('admin.seller-released-payout');
        Route::get('/admin/rejected-payout-requests', 'get_rejected_payout_requests')->name('admin.seller-rejected-payout-requests');
        Route::post('/admin/payout-status-update/{id}', 'payout_status_update')->name('payout.status-update');
    });

    Route::middleware([IsAdminMiddleware::class])
    ->controller(LovecanController::class)
    ->group(function () {
        Route::get('/admin/seller-offers', 'seller_offers')->name('admin.seller-offers');
        Route::get('/admin/seller-ad-view/{id}', 'seller_ad_view')->name('admin.seller-ad-view');
        Route::get('/admin/receive-seller-ad/{id}', 'receive_seller_ad')->name('admin.receive-seller-ad');
        Route::get('/admin/pay-seller-ad/{id}', 'pay_seller_ad')->name('admin.pay-seller-ad');
        Route::post('/admin/udpate-offer-status/{id}', 'udpate_offer_status')->name('admin.update-offer-status');
    });
    // seller
    Route::controller(SellerController::class)->group(function(){
        Route::get('/admin/delete-seller/{id}', 'delete_seller')->name('admin.delete-seller');
        Route::post('/admin/update-seller-status/{id}', 'update_seller_status')->name('admin.update-seller-status');
        Route::get('/admin/seller-messages/{id}', 'seller_messages')->name('admin.seller-messages');
        Route::get('/admin/show_profile/{id}', 'show_profile')->name('admin.show_profile');
        Route::get('/admin/show_report/{id}', 'show_report')->name('admin.show_report');
        Route::get('/admin/show-seller-activity-log/{id}','showselleractivitylog')->name('admin.show-seller-activity-log');
        Route::delete('/admin.selleractivitylogdelete/{id}', 'selleractivitylogdelete')->name('admin.seller-activity-log-delete');
        Route::post('/admin/seller-send-message/{id}', 'seller_send_message')->name('admin.send-message');
        Route::get('/admin/messages-sellers', 'messages')->name('admin.seller_messages');
        Route::get('/seller/sell-to-lovecans', 'sell_to_lovecans')->name('seller.sell-to-lovecans');
        Route::post('/seller/seller.sell-lovecans', 'create_ad')->name('seller.sell-lovecans');
        Route::get('/sell/sell-offers','sell_offers')->name('seller.sell-offers');
        Route::post('/seller/lovecans/submit', 'submitLovecansAd')->name('seller.lovecans.submit');
        Route::get('/lovecanwomen','lovecanwomen')->name('seller.lovecanwomen');
        Route::get('/sell/mediafile', 'mediafile')->name('seller.mediafile');
        Route::get('/sell/showmediafile', 'showmediafile')->name('seller.showmediafile');
        Route::get('/sell/showmediafeEdit/{id}', 'showmediafileEdit')->name('seller.showmediafileEdit');
        Route::post('/sell/showmediafeUpdate/{id}', 'showmediafileUpdate')->name('seller.showmediafileUpdate');
        Route::get('/sell/showmediafiledelete/{id}', 'showmediafileDelete')->name('seller.showmediafileDelete');
        Route::post('/sell/uploadMedia',  'uploadMedia')->name('seller.uploadMedia');
        Route::get('/mediapurchace/{id}', 'mediapurchace')->name('mediapurchace');
        Route::get('/sell/showMedia', 'showMedia')->name('seller.showMedia');
        Route::post('/send-media-link/{id}','sendMediaLink')->name('send.media.link');
        Route::get('/contact-admin', 'contactAdmin')->name('seller.contact.admin');
        Route::post('/contact-admin','sendAdminMessage')->name('seller.sendAdminMessage');
        Route::post('/delete-account', 'deleteAccount')->name('seller.deleteAccount');
        Route::get('/sell/membership', 'sellermembership')->name('seller.membership');
        Route::get('/seller/reports', 'testing')->name('seller.testing');
    });

    // products
    Route::middleware([IsAdminMiddleware::class])
    ->controller(ProductController::class)->group(function(){
        Route::get('/admin/products', 'index')->name('admin.products');
        Route::post('/admin/update-product-status/{id}', 'update_product_status')->name('admin.update-product-status');
    });

    // orders
    Route::controller(OrderController::class)->group(function(){
        Route::post('/update-order-status', 'update_order_status')->name('update-order-status');
    });

    // switch Payment Methods

    Route::controller(SwitchPaymentController::class)->group(function(){
       Route::post('/switch-payment', 'switch_payment')->name('switch-payment');
    });


    Route::get('/dashboard', function (){
        return view('seller.dashboard');
    })->name('seller.dashboard');


    Route::controller(SubscriptionController::class)->group(function(){
        Route::post('/subscribe', 'subscribe')->name('subscribe');
    });

    // Plans
   Route::controller(PlanController::class)->group(function () {
    Route::get('/plans', 'index')->name('admin.plans');
    Route::get('/add-plan', 'create')->name('admin.add-plan');
    Route::post('/add-plan', 'store')->name('plans.store');
    Route::get('/edit-plan/{id}','edit')->name('plans.edit');
    Route::post('/update-plan/{id}', 'update')->name('plans.update');
    Route::delete('/delete-plan/{id}', 'destroy')->name('plans.destroy');
});

});

Route::get('/products', [ProductController::class, 'filter'])->name('products.filter');



Route::controller(PaypalController::class)->group(function(){
    Route::post('/paypal-order-payment', 'order_payment')->name('paypal.order-payment');
    Route::get('/error-order-payment', 'order_errors');
    Route::get('/success-order-payment', 'order_success')->name('success-order-payment');
    Route::any('/payment-error', 'payment_error');
    Route::post('/paypal-can-payment', 'cans_payment')->name('paypal.cans-payment');
    Route::get('/error-payment', 'errors');
    Route::get('/success-payment/{quantity}', 'success');
    Route::get('/pay', 'pay');
});

Route::controller(StripePaymentController::class)->group(function(){
    Route::get('stripe', 'stripe');
    Route::post('stripe', 'stripePost')->name('stripe.post');
    Route::post('/stripe-can-payment', 'cans_payment')->name('cans-payment');
});

Route::controller(MembershipController::class)->group(function(){
    // Route::get('admin/memberships','index')->name('admin.memberships');
    // Route::post('admin/memberships/update', 'update')->name('admin.memberships.update');
    Route::get('/membership', 'index')->name('admin.membership');
    Route::get('/add-membership', 'create')->name('admin.add-membership');
    Route::post('/add-membership', 'store')->name('membership.store');
    Route::get('/edit-membership/{id}','edit')->name('membership.edit');
    Route::post('/update-membership/{id}', 'update')->name('membership.update');
    Route::delete('/delete-membership/{id}', 'destroy')->name('membership.destroy');
});

Route::get('/error/403', function() {
    return view('errors.403');
});


Route::get('/admin/showUserActivityLog',[AdminController::class,'showUserActivityLog'])->name('admin.showUserActivityLog');
Route::delete('/admin/admin.clearActivityLog/{id}',[AdminController::class,'clearActivityLog'])->name('admin.clearActivityLog');
Route::get('/admin/cleanup', [AdminController::class, 'cleanup'])->name('admin.cleanup');

Route::controller(UserMediaController::class)->group(function(){
    Route::get('/user/mediapurchace/{id}','mediapurchace')->name('user.mediapurchace');
    Route::post('/user/purchaseMedia/{id}','purchaseMedia')->name('user.purchaseMedia');
    Route::post('/user/stripe-payment/{mediaId}', 'stripePayment')->name('user.stripe.payment');
    Route::get('/user/payment-success/{purchaseId}', 'paymentSuccess')->name('user.payment.success');
    Route::get('/user/payment-cancel', 'paymentCancel')->name('user.payment.cancel');
});

    Route::get('/admin/gendermessages', [AdminController::class, 'gendermessages'])->name('admin.gendermessages');
    Route::post('/admin/seller/{id}/update-gender', [AdminController::class, 'updateSellerGender'])->name('admin.update.seller.gender');

    Route::get('/send-otp/{phone}', [OTPController::class, 'sendOTP']);
Route::get('/verify-otp/{phone}/{otp}', [OTPController::class, 'verifyOTP']);

Route::get('/membership/create-payment/{membership_id}', [MembershipPaymentController::class, 'createPayment'])->name('membership.creates');
Route::get('/membership/success', [MembershipPaymentController::class, 'success'])->name('membership.success');
Route::get('/membership/cancel', [MembershipPaymentController::class, 'cancel'])->name('membership.cancel');

Route::get('/subcategory',[SubCategoryController::class, 'index'])->name('admin.sub-categories.index');
Route::get('/subcategory/create',[SubCategoryController::class, 'create'])->name('admin.sub-categories.create');
Route::post('/subcategory/store',[SubCategoryController::class, 'store'])->name('admin.sub-categories.store');
Route::get('/subcategory/edit/{id}', [SubCategoryController::class, 'edit'])->name('admin.sub-categories.edit');
Route::post('/subcategory/update/{id}',[SubCategoryController::class, 'update'])->name('admin.sub-categories.update');
Route::delete('/subcategory/delete/{id}',[SubCategoryController::class, 'delete'])->name('admin.sub-categories.delete');
Route::get('/category/{id}/subcategories', [SubCategoryController::class, 'show'])->name('category.subcategories');

Route::controller(BannerSliderController::class)->group(function(){
    Route::get('/slider',  'index')->name('slider.index');
    Route::get('/slider/create',  'create')->name('slider.create');
    Route::post('/slider/store',  'store')->name('slider.store');
    Route::get('/slider/edit/{id}',  'edit')->name('slider.edit');
    Route::post('/slider/update/{id}',  'update')->name('slider.update');
    Route::get('/slider/delete/{id}',  'destroy')->name('slider.delete');
});

Route::controller(SectionRightController::class)->group(function(){
    Route::get('/sectionright', 'index')->name('sectionright.index');
    Route::get('/sectionright/create', 'create')->name('sectionright.create');
    Route::post('/sectionright/store', 'store')->name('sectionright.store');
    Route::get('/sectionright/edit/{id}', 'edit')->name('sectionright.edit');
    Route::post('/sectionright/update/{id}', 'update')->name('sectionright.update');
    Route::get('/sectionright/delete/{id}', 'destroy')->name('sectionright.delete');
});



// Route::get('/', function () {
//     return view('user.comming');
// })->name('coming.soon');
