@extends('layouts.app')
<style>
    #search_result{
        margin-top: 10vh;
    }
    .testing{
        margin: 20px;
    }

</style>

@section('content')
<div class="container my-5">
    <div class="row">

        <div class="col-md-2"></div>
        <div class="col-md-5">
            <h3>{{ $profile->nickname }}  @if($profile->status == 'verified') <i class="fa fa-check" style="color: royalblue;" aria-hidden="true"></i> @endif </h3>
            <div class="text-white d-flex flex-wrap mt-5" style="gap: 6px;">
                <span class="hoverable px-4 py-3">
                    Ethnicity: {{ $profile->type }}
                </span>
                <span class="hoverable px-4 py-3">
                    Figure: {{ $profile->figure }}
                </span>
                @if ($profile->show_age)
                <span class="hoverable px-4 py-3">
                    Age: {{ $profile->age }} years
                </span>
                @endif
                @if ($profile->show_clothing_size)
                <span class="hoverable px-4 py-3">
                    Size: {{ $profile->clothing_size }}
                </span>
                @endif
                <span class="hoverable px-4 py-3">
                    Hair Color: {{ $profile->hair_color }}
                </span>
                <span class="hoverable px-4 py-3">
                    Eye Color: {{ $profile->eye_color }}
                </span>
            </div>
            <div class="my-5">
                <h4>Description</h4>
                <p>
                    {{$profile->description}}
                </p>
            </div>
        </div>
        <div class="col-md-3 d-flex justify-content-center">
            <img style="border-radius: 10px" src="{{ asset('storage/avatars/' . $profile?->profile_picture) }}" alt="Profile Pic" class="">
        </div>
        {{-- <div class="col-md-1"></div> --}}
    </div>
    @if($ads->count() > 0)
    <div class="ps-product-list ps-clothings featured_products" id="search_result">
        <div class="heading"
                    style="text-align: center; font-size: 24px; font-weight: bold; margin-bottom: 20px;">
                    <h3 style="margin-left: 22px;">{{ $profile->nickname }} Products</h3>
        </div>
                
        <div class="ps-container p-0">
            <div class="ps-section__content mt-5 mb-5"
                style="display: flex; justify-content: space-around; align-items: center;">
                <div class="row" style="display: flex; flex-wrap: wrap; gap: 15px; justify-content: center;">
                    @foreach ($ads as $ad)
                        <div class="testing" style="width: calc(30% - 15px); min-width: 250px; background: #fff; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); overflow: hidden; transition: transform 0.3s ease, box-shadow 0.3s ease;">
                            <a href="{{ route('user.product.details', $ad->id) }}">
                                <img src="{{ asset('storage/ads/' . $ad->image) }}" alt="{{ $ad->title }}"
                                style="width: 100%; height: 200px; object-fit: cover;">
                            </a>
                            <div style="padding-top: 12px; text-align: center;">
                                <h5 class="text-capitalize" style="font-weight: 900; font-size: 20px;">
                                    {{ $ad->title }}</h5>
                                <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">
                                    {{ $ad->worn_days ? 'Duration: ' . $ad->worn_days . ' days' : 'No duration available' }}
                                </p>
                                <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">price
                                    ${{ $ad->price }}</p>
                                
                            </div>
                        </div>
                    @endforeach
                   
                </div>
                </a>
            </div>
        </div>
    </div>
    @endif

</div>

@endsection