@extends('layouts.app')

@section('title', 'Products')
<style>

    .image-container {
    position: relative;
    overflow: hidden;
    min-height: 255px;
    min-width: 255px;
}

.hover-icons {
    position: absolute;
    bottom: 10px;
    left: 10px;
    display: flex;
    gap: 10px;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.image-container:hover .hover-icons {
    opacity: 1;
}

.hover-icons .icon {
    background: rgba(0, 0, 0, 0.7);
    color: #fff;
    padding: 10px;
    border-radius: 50%;
    font-size: 16px;
    cursor: pointer;
    border: none;
    outline: none;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
}

.hover-icons .icon:hover {
    background-color: rgba(234, 1, 108, 0.9);
}


</style>
@section('content')
    
    <div class="container-fluid py-5 m-0l">
        <div class="ps-section__content">
            <h2 class="text-center mb-4">All Products</h2>
            <div class="row products" style="display: flex; flex-wrap: wrap; gap: 20px;">
                <div class="col-md-9" style="justify-content: center !important; flex: 1; display: flex; flex-wrap: wrap; gap: 20px;height:fit-content">
                    @foreach ($ads as $ad)
                    <div class="testing" style="height: 50%;">
                        <div class="image-container" style="position: relative;">
                            <a href="{{ route('user.product.details', $ad->id) }}">
                                <img src="{{ asset('storage/ads/' . $ad->image) }}" alt="{{ $ad->title }}"
                                    style="max-height: 255px; border-radius: 20px; width: 100%;">
                            </a>
                    
                            <!-- Hover icons -->
                            <div class="hover-icons">
                                <a href="{{ route('user.product.details', $ad->id) }}" class="icon eye" title="View Details">
                                    <i class="fa fa-eye"></i>
                                </a>
                                <button class="icon cart add-to-cart-btn product-card" 
                                        data-id="{{ $ad->id }}"
                                        data-name='{{ $ad->title }}'
                                        data-price="{{ $ad->price }}"
                                        data-image="{{ $ad->image }}"
                                        data-desc="{{ $ad->description }}"
                                        data-user_name="{{ optional($ad->user)->name }}"
                                        data-type="image"
                                        data-days="{{$ad->worn_days}}"
                                        title="Add to Cart">
                                    <i class="fa fa-shopping-cart"></i>
                                </button>
                            </div>
                        </div>
                    
                        <div style="padding-top: 12px; text-align: center;">
                            <h5 class="text-capitalize" style="font-weight: 900; font-size: 20px; color: black">
                                {{ $ad->title }}</h5>
                            <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">
                                {{ $ad->worn_days ? 'Duration: ' . $ad->worn_days . ' days' : 'No duration available' }}
                            </p>
                            <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">price ${{ $ad->price }}</p>
                            {{-- <div class="d-flex gap-5 product-card">
                                <button class="btn btn-primary btn-lg add-to-cart-btn"
                                    style="color: #fff;margin: auto;padding: 16px 60px;border: none;outline: none;font-weight: 600;width: 100%;font-size: 15px;">
                                    <i class="fa-solid fa-cart-shopping"></i> Add to Cart
                                </button>
                            </div> --}}
                        </div>
                    </div>
                    
                    @endforeach
                </div>
                <div class="col-md-3 order-last myorder-last  ms-auto" style="flex: 0 0 250px; background: #f8f9fa; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);height: fit-content;">
                    <form action="{{ route('products.filter') }}" method="GET">
                        <h4 class="fw-bold mt-3">Category</h4>
                        <select name="category" class="form-control mb-2 p-0">
                            <option value="select category">Select Category</option>
                            @php
                                $categories = App\Models\Category::all();
                            @endphp
                            @forelse ($categories as $category)
                                <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                    {{ $category->category }}
                                </option>
                            @empty
                                <option disabled>No category found</option>
                            @endforelse
                        </select>
                        <h4 class="fw-bold mt-3">Days Worn</h4>
                        <select name="worn_days" class="form-control mb-2 p-0">
                            <option value="select worn days">Select Days Worn</option>
                            @php
                                $days = [1,2,3,4,5,6,7];
                            @endphp
                            @foreach ($days as $day)
                                <option value="{{$day}}" {{ request('worn_days') == $day? 'selected' : '' }}>
                                    {{ $day }}
                                </option>
                            @endforeach
                        </select>
                        <h4 class="fw-bold mt-3">Gender</h4>
                        <select name="gender" class="form-control mb-2 p-0">
                            <option value="select gender">Select Gender</option>
                            <option value="Male">Male</option>
                            <option value="Female">Female</option>
                            <option value="Other">Other</option>
                        </select>
                        <h4 class="fw-bold mt-3">Size</h4>
                        <select name="clothing_size" class="form-control mb-2 p-0">
                            <option value="select clothing size">Select Clothing Size</option>
                            @php
                                $sizes = ['xs', 's', 'm', 'l', 'XL', 'xxl', 'xxxl'];
                            @endphp
                            @forelse ($sizes as $size)
                                <option value="{{ $size}}" {{ request('clothing_size') == $size? 'selected' : '' }}>
                                    {{ $size }}
                                </option>
                            @endforeach
                        </select>
                        <h4 class="fw-bold mt-3">Price Range €</h4>
                        <div class="range-slider" style="text-align:center;">
                            <span class="range-values" id="rangeValue">{{ request('minPrice') ?? '0' }} - {{ request('maxPrice') ?? $max }}</span>
                            <input type="range" id="minPrice" name="minPrice" class="form-range" style="accent-color: #A80150;width:20rem;" min="0" max="{{ $max }}" value="{{ request('minPrice') ?? '0' }}">
                            <input type="range" id="maxPrice" name="maxPrice" class="form-range" style="accent-color: #A80150;width:20rem;" min="0" max="{{ $max }}" value="{{ request('maxPrice') ?? $max }}">
                        </div>
                        <p class="my-5">
                            <b>Additional Refinements</b>
                        </p>
                        @php
                            $options = [
                                'Wearing pictures',
                                'Waring videos',
                                'Worn during sport',
                                'Golden shower',
                                'Worn during sex',
                                'Worn inside',
                                'Lisptick',
                                'Parfume',
                                // 'Worn during masturbation',
                                'Kaviar',
                            ];
                        @endphp
                       <div id="options-container">
                            @foreach ($options as $key => $option)
                                <div class="d-flex align-items-center mb-2">
                                    <div class="col-12">
                                        <input class="mx-2 my-2" type="checkbox" value="{{ $option }}"
                                            name="refinement_title[{{ $key }}]"
                                            {{ is_array(request('refinement_title')) && in_array($option, request('refinement_title')) ? 'checked' : '' }}>
                                        <label for="free_of_diseases">{{ $option }}</label>
                                        <span style="cursor: help"
                                            class="badge rounded-pill bg-secondary text-white"
                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                            title="{{ $option }}"></span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    

                        <div class="d-flex justify-content-between mt-2" style="gap: 10px;">
                            <button type="submit" class="hoverable flex-fill me-2 text-white rounded-pill p-2" style="border:none">Filter</button>
                            <a href="{{ route('products.filter') }}" class="hoverable flex-fill text-white text-center rounded-pill p-2" style="border:none">Reset Filter</a>
                        </div>
                    </form>



                </div>

            </div>
        </div>

        @if ($ads->isEmpty())
            <p class="text-center">No products found</p>
        @endif
    </div>
    <script>
        document.addEventListener('click', function (e) {
    if (e.target.closest('.add-to-cart-btn')) {
        const btn = e.target.closest('.add-to-cart-btn');
        const data = {
            id: btn.dataset.id,
            name: btn.dataset.name,
            price: btn.dataset.price,
            image: btn.dataset.image,
            desc: btn.dataset.desc,
            days: btn.dataset.days,
            type: btn.dataset.type
        };

        // Example action (replace this with actual add to cart logic)
        console.log('Adding to cart:', data);
    }
});

    </script>
@endsection
