@extends("layouts.app")

@section("content")
    <style>
        .product-image {
            max-height: 400px;
            object-fit: cover;
        }
        .btn-report {
            background-color: #d4aeb2;
            color: #fff;
            border: 2px solid #d4aeb2;
        }
        .btn-report:hover {
            background-color: #fff;
            color: #d4aeb2;
            border: 2px solid #d4aeb2;

        }

        .add-to-cart-btn{
            background-color: #DB0062;
            color: white;
            border: 2px solid #DB0062;
        }

        .add-to-cart-btn:hover{
            background-color: #fff;
            color: #DB0062;
            border: 2px solid #DB0062;

        }

        .back_btn {
            background-color: black;
            color: #fff;
            border: 2px solid black;
            font-size: 1.25rem;

        }
        
        .back_btn:hover {
            background-color: #fff;
            color: black;
            border: 2px solid black
        }


        .myP-3 {
    padding: 2rem !important;
}
    </style>
    
    <div class="container my-5 p-5">
        <div class="row m-auto shadow py-4">
            @session('success')
                <p class="col-12 alert alert-success" role="alert">
                    {{session('success')}}
                </p>
            @endsession

            
            @session('error')
                <p class="col-12 alert alert-danger" role="alert">
                    {{session('error')}}
                </p>
            @endsession
            <!-- Product Image -->
            <div class="col-md-6 text-center">
                <img src="{{ asset('storage/ads/' . $product->image) }}" alt="Product Image" class="img-fluid product-image rounded shadow w-100" style="object-fit: fill">
                <div class="d-flex">
                    @forelse ($product->gallery as $image)
                    <img src="{{asset('storage/ads/' . $image)}}" alt="" width="100" class="img-fluid product-image rounded shadow w-50" style="object-fit: fill">
                    @empty
                    
                    @endforelse
                </div>
            </div>

            <!-- Product Details -->
            <div class="col-md-6">
                <h1 class="mb-3 text-capitalize">{{$product->title}}</h1>	
                <p class="text-muted text-capitalize">Type: {{$product->type}}</p>
                <p class="text-muted text-capitalize">Worn Days: {{$product->worn_days}}</p>
                <p class="text-muted text-capitalize">Free Of Disease Days: {{$product->free_of_diseases?'Yes':'No'}}</p>
                <p class="text-muted text-capitalize">Drug Free: {{$product->drugs_free?'Yes':'No'}}</p>
                <p class="h4 text-muted text-capitalize mb-3" >${{$product->price}}</p>
                <p class="mb-4 text-muted text-capitalize">
                    {!! $product->description !!}
                </p>
                <p><b class="text-muted mb-3">Seller:</b> <a href="{{ route('user.sellerProfile', $product->user->profile->nickname) }}"> {{$product->user->profile->nickname}} - visit profile</a></p>
                <!-- Buttons -->
                <div class="d-flex gap-5 product-card product-cardButtons" style="gap: 30px;"  data-id="{{$product->id}}" data-name='{{$product->title}}' data-price="{{$product->price}}" data-image="{{ $product->image }}" data-desc="{{ $product->description }}"
                                        data-type="image" data-days="{{$product->worn_days}}">
                    <button class="btn btn-primary btn-lg add-to-cart-btn" style="width:50%">Add to Cart</button>
                    <button class="btn btn-report btn-lg ml-2" data-bs-toggle="modal" data-bs-target="#reportModal" style="width:20%">Report</button>
                    <a href="/" class="btn text-capitalize btn-sm ml-2 p-3 myP-3 back_btn" style="width:20%">back</a>
                </div>
            </div>

            {{-- <div class="col-md-8 d-flex">
                @forelse ($product->gallery as $image)
                    <img src="{{asset('storage/ads/' . $image)}}" alt="" width="100" class="w-50">
                @empty
                    
                @endforelse
            </div> --}}
        </div>
    </div>  

    <!-- Report Modal -->
    <div class="modal fade" id="reportModal" tabindex="-1" aria-labelledby="reportModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="reportModalLabel">Report Product</h5>
                </div>
                <form action="{{route('user.report',$product->id)}}" method="POST">
                    @csrf
                    <div class="modal-body"> 
                        
                        <div class="mb-3">
                            <label for="reportReason" class="form-label">Name</label>
                            <h5 style="color: black">Seller {{ $product->user->name }}</h5>
                            <input type="text" name="report_id" value="{{ $product->user->id }}" hidden>
                            @error('report_reason')
                                <p class="text-danger">
                                    {{$message}}
                                </p>
                            @enderror
                        </div>     
                        
                        <div class="mb-3">
                            <label for="reportReason" class="form-label">Reason for reporting:</label>
                            <textarea required class="form-control" name="report_details" id="reportReason" rows="4" placeholder="Enter your reason here..."></textarea>
                            @error('report_details')
                                <p class="text-danger">
                                    {{$message}}
                                </p>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">Submit Report</button>
                    </div>
                
                </form>
            </div>
        </div>
    </div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

@endsection