@extends('layouts.app')



@section('title', 'media')

@section('content')
    <style>
        .media-card:hover .watch-video-btn {
            display: block !important;
        }
    </style>

    <div class="container  featured_videos mt-5 mb-5">
        <h2 class="text-center mb-4">Medias</h2>
        <div class="row">
            @foreach ($medias as $media)
                <div class="col-md-3">
                    <div class=" video-container">

                        <div class="" style="position: relative; overflow: hidden;">
                            <div class="image">
                                <a href="javascript:void(0);"
                                    onclick="openVideoModal('{{ asset('storage/' . $media->file_path) }}')">
                                    <video loading="lazy" width="100%" height="200"
                                        style="border-radius: 6px; outline: none; width:100%;">
                                        <source src="{{ asset('storage/' . $media->file_path) }}" type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video>
                                </a>
                                <!-- <a href="javascript:void(0);" onclick="openVideoModal('{{ asset('storage/' . $media->file_path) }}')">
                                    <video loading="lazy" width="100%" height="150" style="border-radius: 6px; outline: none;">
                                        <source src="{{ asset('storage/' . $media->file_path) }}" type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video> -->
                                </a>
                            </div>
                            <div style="padding: 12px; text-align: center;">
                                <h5
                                    style="font-size: 14px; font-weight: bold; color: #333; margin-bottom: 6px; text-transform: capitalize;">
                                    {{ $media->name }}
                                </h5>
                                <p class="mt-4"
                                    style="font-size: 16px; font-weight: bold; margin-bottom: 0;color: #EA016C;">
                                    ${{ $media->price }}</p>
                            </div>

                            <div class="d-flex gap-5 product-card" data-id="{{ $media->id }}"
                                data-name='{{ $media->name }}' data-price="{{ $media->price }}"
                                data-image="{{ $media->file_path }}" data-type="video" data-days="">
                                <button class="btn btn-primary btn-lg add-to-cart-btn my-3"
                                    style="color: #fff;padding: 10px 60px;border: none;outline: none;margin: auto;font-weight: 900;font-size: 15px;">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    Add to Cart
                                </button>
                            </div>
                        </div>


                        <div class="middle">
                            <button class="watch-video-btn"
                                onclick="openVideoModal('{{ asset('storage/' . $media->file_path) }}')">Watch
                                Promo</button>
                        </div>
                    </div>
                </div>
            @endforeach

        </div>

    </div>
    </div>
    </div>


    <div id="videoModal"
        style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); justify-content: center; align-items: center; z-index: 1000;">
        <div
            style="position: relative; width: 80%; max-width: 700px; background: #fff; padding: 10px; border-radius: 10px;">
            <span class="closemodal" onclick="closeVideoModal()"
                style="position: absolute; top: 10px; right: 15px; font-size: 25px; cursor: pointer;">&times;</span>
            <video id="popupVideo" width="100%" controls>
                <source src="" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
    </div>
    </div>

    <script>
        function openVideoModal(videoSrc) {
            var videoModal = document.getElementById("videoModal");
            var videoPlayer = document.getElementById("popupVideo");

            videoPlayer.src = videoSrc;
            videoModal.style.display = "flex";
            videoPlayer.play();
        }

        function closeVideoModal() {
            var videoModal = document.getElementById("videoModal");
            var videoPlayer = document.getElementById("popupVideo");

            videoPlayer.pause();
            videoPlayer.src = "";
            videoModal.style.display = "none";
        }

        window.onclick = function(event) {
            var videoModal = document.getElementById("videoModal");
            if (event.target === videoModal) {
                closeVideoModal();
            }
        };
    </script>

@endsection
