@extends('layouts.app')

@section('content')
    <style>
        .image-container {
    position: relative;
    overflow: hidden;
    min-height: 255px;
    min-width: 255px;
}

.hover-icons {
    position: absolute;
    bottom: 10px;
    left: 10px;
    display: flex;
    gap: 10px;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.image-container:hover .hover-icons {
    opacity: 1;
}

.hover-icons .icon {
    background: rgba(0, 0, 0, 0.7);
    color: #fff;
    padding: 10px;
    border-radius: 50%;
    font-size: 16px;
    cursor: pointer;
    border: none;
    outline: none;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
}

.hover-icons .icon:hover {
    background-color: rgba(234, 1, 108, 0.9);
}


        .image-container {
    position: relative;
    overflow: hidden;
}

.hover-icons {
    position: absolute;
    bottom: 10px;
    left: 10px;
    display: flex;
    gap: 10px;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.image-container:hover .hover-icons {
    opacity: 1;
}

.hover-icons .icon {
    background: rgba(0, 0, 0, 0.7);
    color: #fff;
    padding: 10px;
    border-radius: 50%;
    font-size: 16px;
    cursor: pointer;
    border: none;
    outline: none;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
}

.hover-icons .icon:hover {
    background-color: rgba(234, 1, 108, 0.9);
}


        #close-modal {

            float: right;
            cursor: pointer;
            background: none;
            border: none;
            font-size: 24px;
            position: relative;
            z-index: 1;
            font-weight: 700;
            color: #665552;


        }

        .watch-video-btn {

            background: rgba(0, 0, 0, 0.7);
            color: #fff;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
        }



        .featured_videos .video-container {
            position: relative;
            /* width: 50%; */
        }

        .featured_videos .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .featured_videos .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 25%;
            left: 50%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .featured_videos .video-container:hover .image {
            opacity: 0.3;
            background: rgba(0, 0, 0, 0.9);
        }

        .featured_videos .video-container:hover .middle {
            opacity: 1;
        }

        .featured_videos .text {
            background-color: #04AA6D;
            color: white;
            font-size: 16px;
            padding: 16px 32px;
        }

        .alert-theme {
            background: #721c24;
            color: white;
        }

        .alert-theme h5 {

            color: white;
            padding: 10px 0px 1px 0px;

        }

        .alert-theme span .fa-solid.fa-triangle-exclamation {
            font-size: 20px;
            color: #fb8581;
        }

        .testing {
            width: calc(25% - 15px) !important;
            min-width: 250px !important;
            background: #fff !important;
            border-radius: 10px !important;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1) !important;
            overflow: hidden !important;
            transition: transform 0.3s ease, box-shadow 0.3s ease !important;
        }


        .testing img {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }

        .ad-details {
            padding: 10px;
        }

        /* Tooltip styling */
        .tooltip-text {
            visibility: hidden;
            opacity: 0;
            background-color: rgba(0, 0, 0, 0.8);
            color: #fff;
            text-align: center;
            padding: 8px 12px;
            border-radius: 5px;
            position: absolute;
            bottom: 110%;
            left: 50%;
            transform: translateX(-50%);
            width: max-content;
            max-width: 250px;
            font-size: 12px;
            white-space: nowrap;
            transition: opacity 0.3s;
        }

        /* Show tooltip on hover */
        .testing:hover .tooltip-text {
            visibility: visible;
            opacity: 1;
        }

        #age-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.5);
            /* Black Transparent */
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }

        #popup-box {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 300px;
        }



        .age-content {
            margin: 5px;
            background-color: #A18593;
            padding: 20px;
            border-radius: 5px;
            width: 50%;
            /*height: 50%;*/
            text-align: center;
        }
        @media (min-width: 340px) and (max-width: 768px){
            .age-content {
                width: 100% !important;
            }
        }
        .age-content img {

            margin-top: 10px;
        }

        .age-yes,
        .age-no {
            margin-top: 10px;
            padding: 10px 40px;
            background-color: #000000;
            color: #FFF;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            margin: 25px;

        }

        .closemodal {
            position: absolute;
            top: -15px;
            right: 10px;
            font-size: 50px;
            cursor: pointer;
            color: white;
            z-index: 1;
        }


        .top_categoreis .title {
            background-color: #000000 !important;



        }

        .top_categoreis .title .title-text {
            color #fff;
            text-transform: uppercase;
            margin-top: 10px;
        }
    </style>

    {{-- age verifictation --}}
    @if (!isset($search))
        <div class="age-container" id="age-container">
            <div class="age-content">
                <img src="{{ asset('img/logo2.png') }}" width="50%" alt="">
                <!--<div class="alert alert-danger mt-2 alert-theme" role="alert">-->
                    <h2 class="text-white"><span><i class="fa-solid fa-triangle-exclamation"></i> </span> Are you over 18 years old?</h2>
                <!--</div>-->

                <button class="hoverable age-yes" id="age-yes" onclick="allowAccess()">Yes</button>
                <button class="hoverable age-no" id="age-no" onclick="denyAccess()">No</button>
            </div>
        </div>
    @endif
    <div id="homepage-1">
        <div class="ps-home-banner ps-home-banner--1">
            <div class="ps-container banner-container">
                <div class="ps-section__left">
                    <div class="ps-carousel--nav-inside owl-slider" data-owl-auto="true" data-owl-loop="true"
                        data-owl-speed="5000" data-owl-gap="0" data-owl-nav="true" data-owl-dots="true" data-owl-item="1"
                        data-owl-item-xs="1" data-owl-item-sm="1" data-owl-item-md="1" data-owl-item-lg="1"
                        data-owl-duration="1000" data-owl-mousedrag="on" data-owl-animate-in="fadeIn"
                        data-owl-animate-out="fadeOut">
                        @forelse ($bannersliders as $bannerslider)
                            <div class="ps-banner bg--cover"
                                data-background="{{ asset('storage/' . $bannerslider->sliderimages) }}">
                                <a class="ps-banner__overlay" href="#"></a>
                            </div>
                        @empty
                            <p class="text-center text-capitalize">No bannersliders found</p>
                        @endforelse
                    </div>
                </div>
                {{-- <div class="ps-section__right">
                    @forelse ($sectionrights as $sectionright)
                        <a class="ps-collection imgsec" href="#">
                            <img src="{{ asset('storage/' . $sectionright->images) }}" alt="image not found">

                        </a>
                    @empty
                        <p class="text-center text-capitalize">no image found</p>
                    @endforelse
                </div> --}}
            </div>
        </div>

        <div class="ps-site-features">
            <div class="ps-container">
                <div class="ps-block--site-features">
                    <div class="ps-block__item">
                        <div class="ps-block__left mx-auto"><i class="icon-glasses"></i></div>
                        <div class="ps-block__right text-center">
                            <h4>Absolute Anonymity</h4>
                            {{-- <p>For all oders over $99</p> --}}
                        </div>
                    </div>
                    <div class="ps-block__item">
                        <div class="ps-block__left mx-auto"><i class="icon-sun"></i></div>
                        <div class="ps-block__right text-center">
                            <h4>100% Satisfaction</h4>
                            {{-- <p>If goods have problems</p> --}}
                        </div>
                    </div>
                    <div class="ps-block__item">
                        <div class="ps-block__left mx-auto"><i class="icon-lock"></i></div>
                        <div class="ps-block__right text-center">
                            <h4>Secure Payment</h4>
                            {{-- <p>100% secure payment</p> --}}
                        </div>
                    </div>
                    <div class="ps-block__item">
                        <div class="ps-block__left mx-auto"><i class="icon-truck"></i></div>
                        <div class="ps-block__right text-center">
                            <h4>Discreet Shipping</h4>
                            {{-- <p>Dedicated support</p> --}}
                        </div>
                    </div>
                    <div class="ps-block__item">
                        <div class="ps-block__left mx-auto"><i class="icon-check"></i></div>
                        <div class="ps-block__right text-center">
                            <h4>Verified Sellers</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="ps-product-list top_categoreis">
            <div class="ps-top-categories">
                <div class="ps-container p-0">
                    <div class="ps-section__header"
                        style="text-align: center; font-size: 24px; font-weight: bold; margin-bottom: 20px;">
                        <h3 class="text-center">{{ isset($search) ? 'Search Results' : 'TOP CATEGORIES' }}</h3>
                    </div>
                    <div class="row topCategoreis_contant mt-5 mb-5"
                        style="display: flex; flex-wrap: wrap; justify-content: center; gap: 15px;">
                        @forelse ($categories->slice(0, 4) as $category)
                            <div style="background: #fff; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); overflow: hidden; transition: transform 0.3s ease, box-shadow 0.3s ease;">
                                <a href="{{ route('category.subcategories', $category->id) }}"
                                    style="display: block; width: 100%; height: 100%; text-decoration: none;">
                                    <img src="{{ asset('storage/' . $category->image) }}" alt="Category Image"
                                        style="width: 100%; height: 300px">
                                    <div class="title" style="padding: 12px; text-align: center; background: #fff !important;">
                                        <p
                                            class="title-text"style="font-size: 20px;font-weight: 900;color: #000;margin-bottom: 8px;text-transform: capitalize;">
                                            {{ $category->category }}</p>
                                    </div>
                                </a>
                            </div>
                        @empty
                            <div style="width: 100%; text-align: center;">
                                <p style="color: red; font-size: 18px; font-weight: bold; margin-top: 20px;">No category
                                    found</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        <div class="ps-product-list ps-clothings featured_products" id="search_result">
            <div class="ps-container p-0">
                <div class="ps-section__header"
                    style="text-align: center; font-size: 24px; font-weight: bold; margin-bottom: 20px;">
                    <h3 style="margin-left: 22px;">{{ isset($search) ? 'Search Results' : 'FEATURED PRODUCTS' }}</h3>
                </div>
                <div class="ps-section__content mt-5 mb-5"
                    style="display: flex; justify-content: space-around; align-items: center;">
                    <div class="row" style="display: flex; flex-wrap: wrap; gap: 15px; justify-content: center;">
                        @foreach ($ads as $ad)
                        <div class="testing" style="height: 50%;">
                            <div class="image-container" style="position: relative;">
                                <a href="{{ route('user.product.details', $ad->id) }}">
                                    <img src="{{ asset('storage/ads/' . $ad->image) }}" alt="{{ $ad->title }}"
                                        style="height: 255px;; border-radius: 20px; width: 100%;">
                                </a>
                        
                                <!-- Hover icons -->
                                <div class="hover-icons">
                                    <a href="{{ route('user.product.details', $ad->id) }}" class="icon eye" title="View Details">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <button class="icon cart add-to-cart-btn product-card" 
                                            data-id="{{ $ad->id }}"
                                            data-name='{{ $ad->title }}'
                                            data-price="{{ $ad->price }}"
                                            data-image="{{ $ad->image }}"
                                            data-user_name="{{ optional($ad->user)->name }}"
                                            data-desc="{{ $ad->description }}"
                                            data-type="image"
                                            data-days="{{$ad->worn_days}}"
                                            title="Add to Cart">
                                        <i class="fa fa-shopping-cart"></i>
                                    </button>
                                </div>
                            </div>
                        
                            <div style="padding-top: 12px; text-align: center;">
                                <h5 class="text-capitalize" style="font-weight: 900; font-size: 20px; color:#000000">
                                    {{ $ad->title }}</h5>
                                <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">
                                    {{ $ad->worn_days ? 'Duration: ' . $ad->worn_days . ' days' : 'No duration available' }}
                                </p>
                                <p class="text-capitalize" style="font-weight: 900; font-size: 18px;">price ${{ $ad->price }}</p>
                                {{-- <div class="d-flex gap-5 product-card">
                                    <button class="btn btn-primary btn-lg add-to-cart-btn"
                                        style="color: #fff;margin: auto;padding: 16px 60px;border: none;outline: none;font-weight: 600;width: 100%;font-size: 15px;">
                                        <i class="fa-solid fa-cart-shopping"></i> Add to Cart
                                    </button>
                                </div> --}}
                            </div>
                        </div>
                        
                        @endforeach
                        @if ($ads->count() == 0)
                            <div style="width: 100%; text-align: center;">
                                <p>No Products Available!</p>
                            </div>
                        @endif
                    </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="ps-product-list ps-clothings" id="search_result">
            <div class="ps-container p-0">
                <div class="ps-section__header"
                    style="justify-content: space-between; align-items: center; margin-bottom: 15px;">
                    <h3 class="text-center" style="">{{ isset($search) ? 'Search Results' : 'Featured Videos' }}
                    </h3>
                </div>
                <div class="ps-section__content py-5 featured_videos">
                    {{-- <div class="row"> --}}


                    <div class="container">
                        <div class="row">
                            @foreach ($mediaItems->slice(0, 4) as $media)
                            <div class="col-md-3">
                                <div class="video-container" style="position: relative; overflow: hidden;">
                            
                                    <!-- Video + Hover Icons -->
                                    <div class="image-container" style="position: relative;">
                                        <a href="javascript:void(0);" onclick="openVideoModal('{{ asset('storage/' . $media->file_path) }}')">
                                            <video loading="lazy" width="100%" height="200" style="border-radius: 6px; outline: none;">
                                                <source src="{{ asset('storage/' . $media->file_path) }}" type="video/mp4">
                                                Your browser does not support the video tag.
                                            </video>
                                        </a>
                            
                                        <!-- Hover Icons -->
                                        <div class="hover-icons">
                                            <a href="javascript:void(0);" onclick="openVideoModal('{{ asset('storage/' . $media->file_path) }}')" class="icon eye" title="Watch Promo">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            <button class="icon cart product-card add-to-cart-btn"
                                                    data-id="{{ $media->id }}"
                                                    data-name='{{ $media->name }}'
                                                    data-price="{{ $media->price }}"
                                                    data-image="{{ $media->file_path }}"
                                                    data-type="video"
                                                    data-days=""
                                                    title="Add to Cart">
                                                <i class="fa fa-shopping-cart"></i>
                                            </button>
                                        </div>
                                    </div>
                            
                                    <!-- Title and Price -->
                                    <div style="padding: 12px; text-align: center;">
                                        <h5 style="font-size: 20px; font-weight: 900; color: #333; margin-bottom: 6px; text-transform: capitalize;">
                                            {{ $media->name }}
                                        </h5>
                                        <p class="mt-4" style="font-size: 18px; font-weight: 900; color: #EA016C; margin-bottom: 0;">
                                            ${{ $media->price }}
                                        </p>
                                    </div>
                            
                                    <!-- Button (non-hover) -->
                                    {{-- <div class="d-flex gap-5 product-card" data-id="{{ $media->id }}"
                                        data-name='{{ $media->name }}' data-price="{{ $media->price }}"
                                        data-image="{{ $media->file_path }}" data-type="video" data-days="">
                                        <button class="btn btn-primary btn-lg add-to-cart-btn my-3"
                                            style="color: #fff;padding: 10px 60px;border: none;outline: none;margin: auto;font-weight: 900;font-size: 18px;">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            Add to Cart
                                        </button>
                                    </div> --}}
                                </div>
                            </div>
                            


                                {{-- <div class="container">
                       
                       <div class="image">
                        <div class="video-container ">
                            <a href="javascript:void(0);" onclick="openVideoModal('{{ asset('storage/' . $media->file_path) }}')">
                                <video loading="lazy" width="100%" height="150" style="border-radius: 6px; outline: none;">
                                    <source src="{{ asset('storage/' . $media->file_path) }}" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                            </a>
                          
                        </div>
                        <div style="padding: 12px; text-align: center;">
                            <h5 style="font-size: 14px; font-weight: bold; color: #333; margin-bottom: 6px; text-transform: capitalize;">
                                {{ $media->name }}
                            </h5>
                            <p style="font-size: 16px; font-weight: bold; color: #C4A897;">${{ $media->price }}</p>
                        </div>
                        <div class="d-flex gap-5 product-card" data-id="{{$media->id}}" data-name='{{$media->name}}' data-price="{{$media->price}}" data-image="{{$media->file_path}}">
                            <button class="btn btn-primary btn-lg add-to-cart-btn my-3" style="background: #C4A897; color: #fff; padding: 10px 60px; border: none; outline: none; margin: auto; font-weight:600">
                                <i class="fa-solid fa-cart-shopping"></i>
                                Add to Cart
                            </button>
                        </div>
                        </div>
                        
                        <div class="middle">
                          <button class="watch-video-btn" onclick="openVideoModal('{{ asset('storage/' . $media->file_path) }}')">Watch Promo</button>
                        </div>
                      </div>
                      </div> --}}
                            @endforeach

                        </div>
                        @if ($mediaItems->count() == 0)
                            <div style="width: 100%; text-align: center;">
                                <p class="text-danger text-capitalize" style="font-size: 16px; font-weight: bold;">No
                                    media files available right now</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>


            <div id="videoModal"
                style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); justify-content: center; align-items: center; z-index: 1000;">
                <div
                    style="position: relative; width: 80%; max-width: 700px; background: #fff; padding: 10px; border-radius: 10px;">
                    <span class="closemodal" onclick="closeVideoModal()"
                        style="position: absolute; top: 10px; right: 15px; font-size: 25px; cursor: pointer;">&times;</span>
                    <video id="popupVideo" width="100%" controls>
                        <source src="" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </div>
            </div>
        </div>

        <!--    <div id="cookie-banner" style="position: fixed; bottom: 10px; left: 10px; right: 10px; background: #fff; padding: 10px; border: 1px solid #ccc; text-align: center; z-index: 1;">-->
        <!--    <p>This website uses cookies to ensure you get the best experience. <a href="/privacy-policy">Privacy Policy</a></p>-->
        <!--    <button onclick="acceptCookies()" style="background: black; color: white; padding: 5px 10px; border: none;">Accept</button>-->
        <!--    <button onclick="rejectCookies()" style="background: transparent; padding: 5px 10px; border: 1px solid black;">Preferences</button>-->
        <!--</div>-->

        <script>
          document.addEventListener("DOMContentLoaded", function () {
            let userChoice = localStorage.getItem("ageVerified");
        
            if (userChoice === "no") {
              window.location.href = "https://www.google.com"; // Redirect
            } else if (!userChoice) {
              document.getElementById("age-modal").style.display = "block";
            }
          });
        
          function allowAccess() {
            localStorage.setItem("ageVerified", "yes");
            document.getElementById("age-modal").style.display = "none";
          }
        
          function denyAccess() {
            localStorage.setItem("ageVerified", "no");
            window.location.href = "https://www.google.com"; // Redirect
          }
        </script>
        <script>
            function openVideoModal(videoSrc) {
                var videoModal = document.getElementById("videoModal");
                var videoPlayer = document.getElementById("popupVideo");

                videoPlayer.src = videoSrc;
                videoModal.style.display = "flex";
                videoPlayer.play();
            }

            function closeVideoModal() {
                // alert('click');

                var modal = document.getElementById("videoModal");
                var videoPlayer = document.getElementById("popupVideo");


                // Hide the modal
                modal.style.display = "none";

                // Stop the video playback and reset to the start
                videoPlayer.pause();
                videoPlayer.currentTime = 0;
            }

            window.onclick = function(event) {
                var videoModal = document.getElementById("videoModal");
                if (event.target === videoModal) {
                    closeVideoModal();
                }
            };

            // Show button on hover
            const videoContainers = document.querySelectorAll('.video-container');
            videoContainers.forEach(container => {
                container.addEventListener('mouseenter', () => {
                    const button = container.querySelector('.watch-video-btn');
                    button.style.display = 'block';
                });

                container.addEventListener('mouseleave', () => {
                    const button = container.querySelector('.watch-video-btn');
                    button.style.display = 'none';
                });
            });


            function scrollToSection(sectionId) {
                const section = document.getElementById(sectionId);
                section.scrollIntoView({
                    behavior: 'smooth'
                });
            }
            const is_search = "{{ isset($search) ? true : false }}";
            if (is_search) {
                scrollToSection('search_result');
            }


            function setAgeGateCookie() {
                const date = new Date();
                date.setFullYear(date.getFullYear() + 1);
                document.cookie = "age-gate-passed=no; expires=" + date.toUTCString() + "; path=/";
            }

            // Function to check if Age-Gate cookie is set
            function checkAgeGateCookie() {
                const cookies = document.cookie.split('; ');
                for (let i = 0; i < cookies.length; i++) {
                    const cookie = cookies[i].split('=');
                    if (cookie[0] === 'age-gate-passed' && cookie[1] === 'no') {
                        return true; // Cookie exists, don't show Age-Gate
                    }
                }
                return false; // Cookie doesn't exist, show Age-Gate
            }

            // Function to handle 'Yes' click
            document.getElementById('age-yes').addEventListener('click', function() {
                setAgeGateCookie(); // Set cookie when user confirms age
                document.getElementById('age-container').style.display = 'none'; // Hide Age-Gate
            });

            // Function to handle 'No' click
            document.getElementById('age-no').addEventListener('click', function() {
                setAgeGateCookie(); // Set cookie when user denies age
                window.location.href = "/error/403"; // Redirect to error page if underage
            });

            // On page load, check if Age-Gate cookie exists
            window.onload = function() {
                let ageContainer = document.getElementById("age-container");
                if (checkAgeGateCookie()) {
                    ageContainer.style.display = "none"; // Hide Age-Gate if cookie exists
                } else {
                    ageContainer.style.display = "flex"; // Fix: Use flex instead of block
                }
            };

            document.addEventListener("DOMContentLoaded", function() {
                document.querySelectorAll(".tooltip-icon").forEach(function(tooltip) {
                    tooltip.addEventListener("mouseover", function() {
                        this.nextElementSibling.style.display = "block";
                    });
                    tooltip.addEventListener("mouseout", function() {
                        this.nextElementSibling.style.display = "none";
                    });
                });
            });
        </script>


        <script>
            document.addEventListener("DOMContentLoaded", function() {
                document.querySelectorAll(".media-card").forEach(function(card) {
                    let watchButton = card.querySelector(".watch-video-btn");

                    card.addEventListener("mouseenter", function() {
                        watchButton.style.display = "block";
                    });

                    card.addEventListener("mouseleave", function() {
                        watchButton.style.display = "none";
                    });
                });
            });
        </script>


        {{-- <script>
    document.addEventListener("DOMContentLoaded", function () {
        if (!localStorage.getItem("cookieConsent")) {
            document.body.innerHTML += `
                <div id="cookie-consent" style="position: fixed; bottom: 20px; left: 70%; right: 20px; background: white; padding: 15px; box-shadow: 0 0 10px rgba(0,0,0,0.1); z-index: 1000;">
                    <p>This website uses cookies to ensure you get the best experience on our website. <a href="{{route('user.privacyPolicy')}}">Privacy Policy</a></p>
                    <button id="cookie-preferences" style="background: none; width:50%; border: 1px solid;">Preferences</button>
                    <button id="cookie-accept"style="background: #000; color:white;width:45%;">Accept</button>
                </div>
            `;
        }

    document.addEventListener("click", function (event) {
        if (event.target.id === "cookie-accept") {
            localStorage.setItem("cookieConsent", "accepted");
            document.getElementById("cookie-consent").remove();
        }
        if (event.target.id === "cookie-preferences") {
            showPreferencesModal();
        }
    });

    function showPreferencesModal() {
        document.body.innerHTML += `
            <div id="cookie-modal" style="position: fixed; top: 20px; left: 50%; transform: translateX(-50%); width: 50%; background: white; padding: 15px; box-shadow: 0 0 10px rgba(0,0,0,0.1); z-index: 1001;">
             <button id="close-modal"><i class="fa fa-close"></i></button>
                <h3>Choose Type of Cookies></h3>
                <label><input type="checkbox" checked disabled> Strictly Required Cookies</label><br>
                <p id="strict-cookie-category-text" class="KghTfRYs8xVDs5vaBv7s cc-cookie-category-text isense-cc-cookie-category-text">These cookies are required for the website to run and cannot be switched off. Such cookies are only set in response to actions made by you such as language, currency, login session, privacy preferences. You can set your browser to block these cookies but this might affect the way our site is working.</p>
                <label><input type="checkbox" id="analytics"> Analytics and Statistics</label><br>
                <p id="analytics-cookie-category-text" class="KghTfRYs8xVDs5vaBv7s cc-cookie-category-text isense-cc-cookie-category-text">These cookies allow us to measure visitors traffic and see traffic sources by collecting information in data sets. They also help us understand which products and actions are more popular than others.</p>
                <label><input type="checkbox" id="marketing"> Marketing and Retargeting</label><br>
                <p id="marketing-cookie-category-text" class="KghTfRYs8xVDs5vaBv7s cc-cookie-category-text isense-cc-cookie-category-text">These cookies are usually set by our marketing and advertising partners. They may be used by them to build a profile of your interest and later show you relevant ads. If you do not allow these cookies you will not experience targeted ads for your interests.</p>
                <label><input type="checkbox" id="functional"> Functional Cookies</label><br>
                <p id="functionality-cookie-category-text" class="KghTfRYs8xVDs5vaBv7s cc-cookie-category-text isense-cc-cookie-category-text">These cookies enable our website to offer additional functions and personal settings. They can be set by us or by third-party service providers that we have placed on our pages. If you do not allow these cookies, these or some of these services may not work properly.</p>
                <button id="save-preferences" style="background: none;border: 1px solid;width: 40%;">Save my choice</button>
                <button id="accept-all" style="background:#000; color: #fff; border: 1px solid;width: 40%;">Accept All</button>
               
                
            </div>
        `;
    }

    document.addEventListener("click", function (event) {
        if (event.target.id === "save-preferences") {
            let preferences = {
                analytics: document.getElementById("analytics").checked,
                marketing: document.getElementById("marketing").checked,
                functional: document.getElementById("functional").checked
            };
            localStorage.setItem("cookiePreferences", JSON.stringify(preferences));
            document.getElementById("cookie-modal").remove();
            document.getElementById("cookie-consent").remove();
        }
        if (event.target.id === "accept-all") {
            localStorage.setItem("cookieConsent", "accepted");
            localStorage.setItem("cookiePreferences", JSON.stringify({
                analytics: true,
                marketing: true,
                functional: true
            }));
            document.getElementById("cookie-modal").remove();
            document.getElementById("cookie-consent").remove();
        }
        if (event.target.id === "close-modal") {
            document.getElementById("cookie-modal").remove();
        }
        
    });
    });
</script> --}}
    @endsection
