@extends('layouts.app')

@section('content')
    <div class="ps-page--single" id="how-to-sell">
        <img src="img/bg/how-to-sell.jpg" alt="">
        <div class="ps-about-intro">
            <h2 class="text-center mb-4">How to Sell</h2>
            <div class="container pt-4">
                <div class="ps-section__header">
                    {{-- <h4>Welcome to Lovecans</h4> --}}
                    <h3>Start Selling on Lovecans Today</h3>
                    <p>At Lovecans, we empower entrepreneurs to grow their businesses and reach millions of buyers worldwide. Whether you're a seasoned seller or just starting, our platform offers all the tools and services you need to succeed. Let’s help you get started with selling on Lovecans.</p>
                </div>
                <div class="ps-section__content">
                    <div class="row">
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 col-6">
                            <div class="ps-block--icon-box"><i class="icon-user"></i>
                                <h4>Create Your Account</h4>
                                <p>Sign up for a Lovecans seller account and provide your details.</p>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 col-6">
                            <div class="ps-block--icon-box"><i class="icon-cube"></i>
                                <h4>List Your Products</h4>
                                <p>Upload your products with clear descriptions and attractive photos.</p>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 col-6">
                            <div class="ps-block--icon-box"><i class="icon-credit-card"></i>
                                <h4>Set Your Prices</h4>
                                <p>Choose competitive pricing for your products to attract buyers.</p>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 col-6">
                            <div class="ps-block--icon-box"><i class="fa fa-shopping-basket"></i>

                                <h4>Manage Your Orders</h4>
                                <p>Track your sales and fulfill orders promptly for happy customers.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="ps-about-awards">
            <div class="container">
                <div class="ps-section__header">
                    <h4>Awards & Recognition</h4>
                    <p>Our commitment to helping sellers succeed has earned us recognition in the industry. Here's some of our accolades.</p>
                </div>
                <div class="ps-section__content">
                    <div class="owl-slider" data-owl-auto="true" data-owl-loop="true" data-owl-speed="15000" data-owl-gap="0" data-owl-nav="false" data-owl-dots="false" data-owl-item="5" data-owl-item-xs="3" data-owl-item-sm="3" data-owl-item-md="3" data-owl-item-lg="4" data-owl-duration="1500" data-owl-mousedrag="off">
                        <a href="#"><img src="img/awards/1.png" alt=""></a>
                        <a href="#"><img src="img/awards/2.png" alt=""></a>
                        <a href="#"><img src="img/awards/3.png" alt=""></a>
                        <a href="#"><img src="img/awards/4.png" alt=""></a>
                        <a href="#"><img src="img/awards/5.png" alt=""></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
