@extends('layouts.app')

@section('title', 'categoreis')

@section('content')
    <div class="container py-4">


        <div class="ps-top-categories">
            <div class="ps-container">
                <h3 class="text-center">Top categories</h3>
                <div class="row" style="justify-content: center">
                    @forelse ($categorys as $category)
                        <div class="col-xl-2 col-lg-3 col-md-4 col-sm-4 col-6">
                            <div class="ps-block--category">
                                <a class="ps-block__overlay" href="{{ route('category.subcategories', $category->id) }}"></a>
                                <img src="{{ asset('storage/' . $category->image) }}" alt="Category Image" class="img-fluid">
                                <p class="text-capitalize">{{ $category->category }}</p>
                            </div>
                        </div>
                    @empty
                        <span class="text-center text-danger text-capitalize">No category found</span>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
@endsection
