@php
    $profile = auth()->user()->profile;
@endphp
@extends("seller.profile")
@section('content')
<div class="col-lg-8 mt-5">
    {{-- <div class="d-flex justify-content-between align-items-center">
        <h4 class="mb-4">Show Media & Files</h4>
        <a href="/profile" class="btn btn-dark">back</a>
    </div> --}}

    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="thead-dark">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Video</th>
                    {{-- <th>File Link</th> --}}
                    <th>Price</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($mediafiles as $index => $mediafile)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $mediafile->name }}</td>
                    <td>
                            <video width="200" controls>
                                <source src="{{ asset('storage/' . $mediafile->file_path) }}" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                    </td>
                    {{-- <td>
                        <iframe src="{{ $mediafile->external_link }}/preview" width="50%" height="60px"></iframe>
                    </td> --}}
                    
                    <td>${{ number_format($mediafile->price, 2) }}</td>
                    <td><a href="{{ route('seller.mediafile') }}" class="btn btn-primary">add</a>
                        <a href="{{ route('seller.showmediafileEdit', $mediafile->id) }}" class="btn btn-success">edit</a>
                        <a href="{{ route('seller.showmediafileDelete', $mediafile->id) }}" class="btn btn-danger">delete</a>
                    </td>
                </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center">
                            No any Media Files
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
