@extends('layouts.dashboard')

@section('dashboard')

{{-- Form for the seller to add a ad with following fields ['name', 'type', 'price', 'worn_days', 'approved'] --}}

<div class="ps-page--my-account">
    <div class="ps-breadcrumb">
        <div class="container">
            <ul class="breadcrumb">
                <li>My account</li>
            </ul>
        </div>
    </div>
    <div class="ps-my-account">
        <div class="container">
            <form class="ps-form--account ps-tab-root" action="{{ route('seller.sell-lovecans') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <a href="/profile" class="btn btn-dark">Back</a>
                <ul class="ps-tab-list">
                    <li class="active"><a href="#createad">Sell To Lovecans</a></li>
                </ul>
                @session('error')
                    <p class="alert alert-danger" role="alert">
                        {{ session('error') }}
                    </p>
                @endsession
                <div class="ps-tabs">
                    <div class="ps-tab active py-3" id="createad">
                        <div class="ps-form__content">
                            <h5>Create Ad</h5>
                            <div class="form-group">
                                <input class="form-control" type="text" value="{{ old('title') }}" name="title" placeholder="Title" required>
                                @if ($errors->has('title'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('title') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="form-group">
                                @php
                                    $categories = App\Models\Category::all();
                                @endphp
                                <select class="form-control" type="text" name="type" placeholder="type" required>
                                    @foreach ($categories as $category)
                                        <option value="{{$category->category}}" {{(old('type')==$category->category?"selected":"")}}>{{$category->category}}</option>
                                    @endforeach
                                </select>    
                                {{-- <select class="form-control" type="text" name="type" placeholder="type" required>
                                    <option value="socks">socks</option>
                                    <option value="thongs">thongs</option>
                                    <option value="lingerie">lingerie</option>
                                </select>     --}}
                                @if ($errors->has('type'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('type') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <input class="form-control" value="{{ old('worn_days') }}" type="number" name="worn_days" placeholder="Worn Days" required>
                                @if ($errors->has('worn_days'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('worn_days') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <input class="form-control" value="{{ old('price') }}" type="number" name="price" placeholder="Price" required>
                                @if ($errors->has('price'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('price') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <input class="form-control" value="{{ old('quantity') }}" type="number" name="quantity" placeholder="Quantity" required min="1">
                                @if ($errors->has('quantity'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('quantity') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <input class="form-control" type="text" value="{{ old('description') }}" name="description" placeholder="Description" required>
                                @if ($errors->has('description'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('description') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <input class="form-control" type="file" name="image" placeholder="Image" required>
                                @if ($errors->has('image'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('image') }}</strong>
                                </span>
                                @endif
                            </div>
                            <div class="d-flex align-items-start">
                                <input class="mx-2 my-2" type="checkbox" value="1" name="free_of_diseases" required {{ old('free_of_diseases') ? 'checked' : '' }}>
                                <label for="free_of_diseases">I hereby confirm that I am currently free of sexually transmitted diseases.</label>
                            </div>
                            <div class="d-flex align-items-start gap-2">
                                <input class="mx-2 my-2" type="checkbox" name="drugs_free" value="1" required {{ old('drugs_free') ? 'checked' : '' }}>
                                <label for="drugs_free">I hereby confirm that I am not currently using narcotics.</label>
                            </div>
                            <div class="form-group submtit">
                                <button class="ps-btn ps-btn--fullwidth">Create Ad</button>
                            </div>
                        </div>
                    </div>
            </form>
        </div>
    </div>
</div>

@endsection