@php
    $profile = auth()->user()->profile;
@endphp 
@extends('seller.profile')

@section('content')
<style>
    .card {
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        transition: transform 0.3s, box-shadow 0.3s;
        background-color: #fff;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
    }
    .card-title {
        font-size: 1.8rem;
        font-weight: 600;
        color: #333;
        margin-bottom: 10px;
    }

    .card-text {
        font-size: 1.5rem;
        color: #555;
    }

    .card-status {
        font-size: 1.5rem;
        color: #ff4d4d;
        font-weight: bold;
    }
    .card img {
        width: 100%;
        margin-bottom: 15px;
        border-radius: 8px;
    }
    .card {
        background-color: #f9f9f9;
    }

    .card-status {
        background-color: #ffdede;
        padding: 5px 10px;
        border-radius: 5px;
        display: inline-block;
        color: #d9534f;
    }

    .card-status.approved {
        background-color: #d4edda;
        color: #155724;
    }

    .card-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        padding: 20px;
    }


</style>
{{-- @php
    $can = App\Models\Can::where('user_id', Auth::user()->id)->first();    
@endphp --}}
<div class="col-lg-8 text-center">
    {{-- <div style="text-align: start">
        <a href="/profile" class="btn btn-dark">Back</a>
    </div> --}}
    <div class="py-5">
        @session('success')
            <p class="alert alert-success" role="alert">
                {{session('success')}}
            </p>
        @endsession
        <h2>Your Offers</h2>
        {{-- <p>Welcome to your dashboard</p> --}}
        {{-- @if (Auth::user()->role === 'admin')
        <a  class="btn btn-secondary" href="{{route('admin.dashboard')}}">Admin Dashboard</a>
        @endif

        @php
            $is_approved = false
        @endphp
        @if ((Auth::user()->profile->status === 'verified') && ($can->stock > 0))
            @php
                $is_approved = true
            @endphp
        @endif
        @if ($is_approved)
            <a  class="btn btn-secondary" href="/createad">Create Ad</a>
        @endif
        <a href="{{route('seller.sell-to-lovecans')}}" class="btn btn-secondary">Sell To Lovecans</a>
        <a href="/store" class="btn btn-secondary">Lovecans Store</a>
        <a href="/profile" class="btn btn-secondary">View Profile</a> --}}
        {{-- <a href="/" class="btn btn-secondary">Home</a>
        <a href="/logout" class="btn btn-secondary">Logout</a> --}}
    </div>

    @php
        // $ads = App\Models\Ad::where('user_id', Auth::user()->id)->orderBy('id', 'desc')->get();
        $can = App\Models\Can::where('user_id', Auth::user()->id)->first();
    @endphp

    {{-- <div class="text-right">
        <h4>No of Cans available: {{ $can ? $can->stock : 0 }}</h4>
    </div> --}}

    <div>
        
        <div class="row">
            @foreach ($offers as $offer)
                <div class="col-lg-4 col-md-6 col-sm-6">
                    <div class="card-container">
                        <div class="card">
                            <img src="{{asset('storage/ads/'.$offer->image)}}" class="card-img-top" alt="...">
                            <h3 class="card-title">{{ $offer->title }}</h3>
                            <p class="card-text">Type: {{ $offer->type }}</p>
                            <p class="card-text">Price: {{ $offer->price }}</p>
                            <p class="card-text">Days Worn: {{ $offer->worn_days }}</p>
                            <span class="{{$offer->offer_status == 'Accepted' ? 'card-status approved' : 'card-status'}}">{{$offer->offer_status}}</span>
                        </div>
                        <!-- Add more cards here -->
                    </div>
                </div>
            @endforeach
            
            @if ($offers->count() == 0)
                
                <div class="text-center col-12 ">
                    <hr>
                    <h5>No Offers</h5>
                </div>
            @endif
        </div>
    </div>
</div>
    
@endsection