@extends('layouts.app')

@section('content')

<style>
    
   header.header.header--1 {
    /* display: none; */
}
</style>

<div class="ps-page--my-account">
    <div class="ps-breadcrumb">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="/">Home</a></li>
                <li>My account</li>
            </ul>
        </div>
    </div>
    <div class="ps-my-account">
        <div class="container">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
            <form class="ps-form--account ps-tab-root" action="{{ route('user-register') }}" method="POST" id="registeration_form">
                @csrf
                <ul class="ps-tab-list">
                    <li class="active"><a href="#register">Register</a></li>
                </ul>
                <div class="ps-tabs">
                    <div class="ps-tab active py-3" id="register">
                        <div class="ps-form__content">
                            <h5>Register An Account</h5>
                            <div class="form-group">
                                <input class="form-control" type="email" name="email" placeholder="email address">
                                @if ($errors->has('email'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif
                            </div>
                            <div class="form-group">
                                <input class="form-control" type="text" name="name" placeholder="Name">
                                @if ($errors->has('name'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('name') }}</strong>
                                </span>
                            @endif
                            </div>
                            <div class="form-group">
                                <input class="form-control" type="tel" name="phone_number" placeholder="Enter Your Number" required pattern="\+[0-9]{10,15}">
                                @if ($errors->has('phone_number'))
                                    <span class="help-block text-danger">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif
                            </div>                            
                            {{-- <div class="form-group">
                                <input class="form-control" type="password" name="password" placeholder="Password">
                                @if ($errors->has('password'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                            @endif
                            </div> --}}


                            <div class="form-group position-relative">
                                <input id="password" class="form-control pr-5" type="password" name="password" placeholder="Password">
                                <span toggle="#password" class="fa fa-fw fa-eye field-icon toggle-password" style="position: absolute; right: 15px; top: 50%; transform: translateY(-50%); cursor: pointer;"></span>
                                @if ($errors->has('password'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                                @endif
                            </div>

                            

                            {{-- <div class="form-group">
                                <input class="form-control" type="password" name="password_confirmation" placeholder="Confirm Password">
                                @if ($errors->has('password_confirmation'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('password_confirmation') }}</strong>
                                </span>
                            @endif

                            </div> --}}



                            <div class="form-group position-relative">
                                <input id="confirm_password" class="form-control pr-5" type="password" name="password_confirmation" placeholder="Confirm Password">
                                <span toggle="#confirm_password" class="fa fa-fw fa-eye field-icon toggle-password" style="position: absolute; right: 15px; top: 50%; transform: translateY(-50%); cursor: pointer;"></span>
                                @if ($errors->has('password_confirmation'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('password_confirmation') }}</strong>
                                </span>
                                @endif
                            </div>

                            

                            <div class="form-group p-0 m-0">
                                <div class="d-flex align-items-start">
                                    <input class="mx-2  mt-2 mt-2" type="checkbox" value="1" name="is_adult" required>
                                    <label for="is_adult" class="p-0 m-0">I am at least 18 years old.</label>
                                </div>
                                    @if ($errors->has('is_adult'))
                                    <span class="help-block text-danger">
                                        <strong>{{ $errors->first('is_adult') }}</strong>
                                    </span>
                                    @endif
                            </div>
                            <div class="form-group p-0 my-2">
                                <div class="d-flex align-items-start">
                                    <input class="mx-2  mt-2" type="checkbox" value="1" name="is_disease_free" required>
                                    <label for="is_disease_free" class="p-0 m-0">I hereby confirm that I am currently free of sexually transmitted diseases.</label>
                                </div>
                                    @if ($errors->has('is_disease_free'))
                                    <span class="help-block text-danger">
                                        <strong>{{ $errors->first('is_disease_free') }}</strong>
                                    </span>
                                    @endif
                            </div>
                            <div class="form-group p-0 m-0">
                                <div class="d-flex align-items-start">
                                    <input class="mx-2  mt-2" type="checkbox" value="1" name="is_drug_free" required>
                                    <label for="is_drug_free" class="p-0 m-0">I hereby confirm that I am not currently using narcotics.</label>
                                </div>
                                    @if ($errors->has('is_drug_free'))
                                    <span class="help-block text-danger">
                                        <strong>{{ $errors->first('is_drug_free') }}</strong>
                                    </span>
                                    @endif
                            </div>
                            <div class="form-group p-0 my-2 ">
                                <div class="d-flex align-items-start">
                                    <input class="mx-2  mt-2 " type="checkbox" value="1" name="is_agree" required>
                                    <label for="is_agree" class="p-0 m-0">I have read and agree to the <a href="{{ route('user.term-condition') }}" target="_blank"  class="text-link text-uppercase">terms and conditions</a> and notes for sellers.</label>
                                </div>
                                    @if ($errors->has('is_agree'))
                                    <span class="help-block text-danger">
                                        <strong>{{ $errors->first('is_agree') }}</strong>
                                    </span>
                                    @endif
                            </div>
                                <br>
                                <p>
                                    Already Have An Account  ? <a href="{{route('login')}}" class="text-link text-uppercase">Login</a>
                                </p>
                            
                            @if ($errors->has('g-recaptcha-response'))
                                <p class="text-danger">{{ $errors->first('g-recaptcha-response') }}</p>
                            @endif    
                            <div class="form-group submtit">
                                <button class="ps-btn ps-btn--fullwidth">Register</button>
                            </div>
                        </div>
                    </div>
            </form>
        </div>
    </div>
</div>
    
<script>
    document.querySelectorAll('.toggle-password').forEach(function(toggleIcon) {
        toggleIcon.addEventListener('click', function() {
            const input = document.querySelector(this.getAttribute('toggle'));
            const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
            input.setAttribute('type', type);
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });
    });
</script>

@endsection

