<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Promote Ad</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <style>
        body {
            background-color: #f4f7fc;
            font-family: 'Arial', sans-serif;
        }

        .container {
            margin-top: 40px;
        }

        .ps-section__right {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .ps-section__content {
            margin-top: 20px;
        }

        .table {
            border-radius: 8px;
            border-collapse: separate;
            width: 100%;
        }

        .table-bordered {
            border: 1px solid #dee2e6;
        }

        .table-hover tbody tr:hover {
            background-color: #f1f1f1;
        }

        .thead-dark {
            background-color: #343a40;
            color: #fff;
        }

        .btn-primary {
            background-color: #4e73df;
            border-color: #4e73df;
        }

        .btn-primary:hover {
            background-color: #2e59d9;
            border-color: #2e59d9;
        }

        .text-dark {
            color: #343a40;
        }

        .form-control {
            border-radius: 5px;
            height: 36px;
        }

        .mb-2 {
            margin-bottom: 10px;
        }

        .row {
            margin-top: 10px;
        }

        .ps-section__right h2 {
            color: #4e73df;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="col-lg-12">
            <div class="d-flex justify-content-between mb-4">
                <strong>
                    Promote Ad
                </strong>
                <a href="{{ route('seller.dashboard') }}" class="btn btn-primary">back</a>
            </div>
            <div class="ps-section__right col-md-12">
                <h2 class="text-center">Manage Your Ads</h2>
                <div class="ps-section__content">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-dark">
                                <tr class="text-center">
                                    <th>Order No.</th>
                                    <th>User Name</th>
                                    <th>Ad Title</th>
                                    <th>Type</th>
                                    <th>Ad Image</th>
                                    <th>Description</th>
                                    <th>Worm Days</th>
                                    <th>Price</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="text-center">
                                    <td>{{ $ad->id }}</td>
                                    <td>{{ $ad->user->name }}</td>
                                    <td>{{ $ad->title }}</td>
                                    <td>{{ $ad->type }}</td>
                                    <td>
                                            <img src="{{ asset('storage/ads/' . $ad->image) }}" alt="Product Image" style="width: 50px; height: auto;" class="img-fluid">
                                    </td>
                                    <td>{!! $ad->description !!}</td>
                                    <td>{{ $ad->worn_days }}</td>
                                    <td>{{ $ad->price }}</td>
                                 <td>
                                    <a href="{{ route('payment.process', $ad->id) }}" class="btn btn-primary">Pay</a>
                                 </td>
                                </tr>
                            </tbody>
                            
                        </table>
                    </div>
                    <!-- Pagination will go here -->
                    {{-- <!-- Example: {!! $orders->withQueryString()->links('pagination::bootstrap-5') !!} --}}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
