@extends('layouts.dashboard')

@section('dashboard')

<main class="ps-page--my-account">
    <div class="ps-breadcrumb">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="/">Home</a></li>
                <li>User Information</li>
            </ul>
        </div>
    </div>
    <section class="ps-section--account">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ps-section__right">
                            <form class="ps-form--account-setting" action="{{ route('profile.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="ps-form__header">
                                <h3> User Information</h3>
                            </div>
                            <div class="ps-form__content">
                                <div class="row">
                                    {{-- Nickname --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Nickname</label>
                                            <input class="form-control" type="text" name="nickname" placeholder="Please enter your Nickname..." required>
                                            @if ($errors->has('nickname'))
                                            <span class="help-block text-danger">
                                                <strong>{{ $errors->first('nickname') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    {{-- Gender --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Gender</label>
                                            <select class="form-control" name="gender">
                                                <option value="female" >Female</option>
                                            </select>
                                            
                                            @if ($errors->has('gender'))
                                            <span class="help-block text-danger">
                                                <strong>{{ $errors->first('gender') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    {{-- Age --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Age</label>
                                            <input class="form-control" type="number" name="age" placeholder="Please enter your age..." required>
                                            @if ($errors->has('age'))
                                            <span class="help-block text-danger">
                                                <strong>{{ $errors->first('age') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Clothing Size</label>
                                            <select class="form-control" name="clothing_size" id="">
                                                <option value="xs">XS</option>
                                                <option value="s">S</option>
                                                <option value="m">M</option>
                                                <option value="l">L</option>
                                                <option value="xl">XL</option>
                                                <option value="xxl">XXL</option>
                                                <option value="xxxl">XXXL</option>
                                            </select>
                                            @if ($errors->has('clothing_size'))
                                            <span class="help-block text-danger">
                                                <strong>{{ $errors->first('clothing_size') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    {{-- Type --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Type</label>
                                            <select class="form-control" name="type">
                                                <option value="German">German</option>
                                                <option value="Western European">Western European</option>
                                                <option value="European">European</option>
                                                <option value="Scandinavian">Scandinavian</option>
                                                <option value="Eastern European">Eastern European</option>
                                                <option value="Southern European">Southern European</option>
                                                <option value="Asian">Asian</option>
                                                <option value="South and Latin American">South and Latin American</option>
                                                <option value="Oriental">Oriental</option>
                                                <option value="African American">African American</option>
                                                <option value="Exotic">Exotic</option>
                                            </select>
                                        </div>
                                    </div>
                                    {{-- Figure --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Figure</label>
                                            <select class="form-control" name="figure">
                                                <option value="Athletic">Athletic</option>
                                                <option value="Normal">Normal</option>
                                                <option value="Slim">Slim</option>
                                                <option value="Chubby">Scandinavian</option>
                                                <option value="Fat">Fat</option>
                                            </select>
                                        </div>
                                    </div>
                                    {{-- Hair Color --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Hair Color</label>
                                            <select class="form-control" name="hair_color">
                                                <option value="Blonde">Blonde</option>
                                                <option value="Brunette">Brunette</option>
                                                <option value="Black">Black</option>
                                                <option value="Red">Red</option>
                                            </select>
                                        </div>
                                    </div>
                                    {{-- Eye Color --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Eye color</label>
                                            <select class="form-control" name="eye_color">
                                                <option value="Blue">Blue</option>
                                                <option value="Brown">Brown</option>
                                                <option value="Green">Green</option>
                                                <option value="Grey">Grey</option>
                                            </select>
                                        </div>
                                    </div>
                                    {{-- Address --}}
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Address</label>
                                            <input class="form-control" type="text" name="address" placeholder="Please enter your address..." required>
                                            @if ($errors->has('address'))
                                            <span class="help-block text-danger">
                                                <strong>{{ $errors->first('address') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Profile Picture</label>
                                            <input type="file" alt="" name="profile_picture" required class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Instagram Link</label>
                                            <input type="text" alt="" name="instagram" class="form-control" placeholder="instagram profile link">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Onlyfans Link</label>
                                            <input type="text" alt="" name="onlyfans" class="form-control" placeholder="onlyfans profile link">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Snapchat Link</label>
                                            <input type="text" alt="" name="snapchat" class="form-control" placeholder="snapchat profile link">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Description</label>
                                            <textarea class="form-control" name="description" cols="30" rows="3"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group submit">
                                <button class="ps-btn">Create</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

@endsection