<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Payment Cancelled</title>
    <style>
        /* Google Font */
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap');

        /* Reset and Styling */
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8d7da;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .container {
            background: #ffffff;
            padding: 30px;
            max-width: 450px;
            text-align: center;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            border-radius: 12px;
            border: 2px solid #dc3545;
        }

        .crossmark {
            width: 80px;
            height: 80px;
            background-color: #dc3545;
            color: white;
            font-size: 50px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0 auto 20px;
            animation: pop 0.5s ease-in-out;
        }

        @keyframes pop {
            0% { transform: scale(0.8); opacity: 0; }
            100% { transform: scale(1); opacity: 1; }
        }

        h2 {
            color: #dc3545;
            margin-bottom: 10px;
        }

        p {
            color: #555;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .btn {
            background-color: #dc3545;
            color: white;
            text-decoration: none;
            padding: 12px 20px;
            display: inline-block;
            border-radius: 6px;
            font-size: 16px;
            transition: 0.3s ease-in-out;
        }

        .btn:hover {
            background-color: #a71d2a;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="crossmark">✖</div>
        <h2>Payment Cancelled!</h2>
        <p>Your payment was not completed. Please try again.</p>
        <a href="/" class="btn">Try Again</a>
    </div>

</body>
</html>
