<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Promote Ad</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        
        .container {
            max-width: 600px;
            margin: 50px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #333;
        }

        label {
            display: block;
            margin: 15px 0 5px;
            font-size: 16px;
            color: #333;
        }

        select {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            border-radius: 4px;
            border: 1px solid #ddd;
            margin-bottom: 20px;
            box-sizing: border-box;
        }

        select:disabled {
            background-color: #f1f1f1;
        }

        button {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
        }

        button:hover {
            background-color: #218838;
        }

        option[disabled] {
            color: #888;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Promote Your Ad</h1>
        <form action="{{ route('payment.pay', $ad->id) }}" method="POST">
            @csrf
            <label for="fee">Select Fee:</label>
            <select name="fee" id="fee">
                <option value="select one">select one</option>
                @forelse ($settings as $setting)
                    <option value="{{ $setting->promotion_fee }}" data-duration="{{ $setting->promotion_duration }}">
                        {{ $setting->promotion_fee }}
                    </option>
                @empty
                    <option disabled>No fee available</option>
                @endforelse
            </select>
        
            <label for="duration">Select Duration:</label>
            <select name="duration" id="duration" disabled>
                <option value="select one" disabled selected>select one</option>
                @forelse ($settings as $setting)
                    <option value="{{ $setting->promotion_duration }}">
                        {{ $setting->promotion_duration }}
                    </option>
                @empty
                    <option disabled>No Duration available</option>
                @endforelse
            </select>
        
            <button type="submit">Promote Ad</button>
        </form>
    </div>

    <script>
        document.getElementById('fee').addEventListener('change', function() {
            var selectedFee = this.options[this.selectedIndex];
            var selectedDuration = selectedFee.getAttribute('data-duration');
            var durationSelect = document.getElementById('duration');

            // Enable the duration select box when fee is selected
            durationSelect.disabled = false;

            // Loop through all options in the duration select box
            for (var i = 0; i < durationSelect.options.length; i++) {
                if (durationSelect.options[i].value === selectedDuration) {
                    durationSelect.selectedIndex = i;
                    break;
                }
            }
        });
    </script>
</body>
</html>
