@php
    $profile = auth()->user()->profile;
@endphp
@extends("seller.profile")
@section('content')
{{-- <div class="container mt-5"> --}}
<div class="col-lg-8 mt-5">
     <div class="d-flex justify-content-between align-items-center">
        <h4 class="my-4">Seller Membership Plans</h4>
        {{-- <a href="/profile" class="btn btn-dark">back</a> --}}
    </div>

    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="thead-dark">
                <tr>
                    <th>#</th>
                    <th>Plan Name</th>
                    <th>Ad Limit</th>
                    <th>Price</th>
                    <th>Image Limit</th>
                    <th>Duration (Days)</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($memberships as $index => $membership)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $membership->name }}</td>
                    <td>{{ $membership->ad_limit }}</td>
                    <td>${{ number_format($membership->price, 2) }}</td>
                    <td>{{ $membership->image_limit }}</td>
                    <td>{{ $membership->duration_days }}</td>
                    <td>
                        <a href="{{ route('membership.creates', ['membership_id' => $membership->id]) }}" class="text-white hoverable btn btn-lg">
                            Purchase Plan
                        </a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
