@extends("layouts.app")

@section("content")
    <style>
        .product-image {
            max-height: 400px;
            object-fit: cover;
        }
        .btn-report {
            background-color: #f8d7da;
            color: #842029;
        }
        .btn-report:hover {
            background-color: #f5c2c7;
        }
    </style>
    
    <div class="container my-5 p-5">
        <div class="row shadow">
            <div class="col-md-6">
                <video width="320" height="240" controls>
                    <source src="{{ asset('storage/' . $mediaItem->file_path) }}" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </div>

            <form action="{{ route('user.purchaseMedia', $mediaItem->id) }}" method="post" class="col-md-6">
                @csrf
               <div class="form-group">
                    <label for="Name">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="Enter buyer's name">
                </div>
                <div class="form-group">
                    <label for="Price">Buyer Email</label>
                    <input type="email" name="buyer_email" class="form-control" placeholder="Enter buyer's email" required>
                </div>
                <div class="form-group">
                    <label for="seller name">Seller Name</label>
                    <input type="text" name="" class="form-control" value="{{ $mediaItem->seller->name }}" disabled>
                </div>
                <div class="form-group">
                    <label for="Price">Price</label>
                    <input type="text" name="" class="form-control" value="{{ $mediaItem->price }}" disabled>
                </div>
                
                <button type="submit" class="btn btn-primary">Proceed to Payment</button>
                   <a href="/" class="btn btn-dark m-0">back</a>
            </form>
            
            
        </div>
    </div>  

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

@endsection
