@extends('layouts.dashboard')

@section('dashboard')

<div class="ps-page--my-account">
    <div class="ps-breadcrumb">
        <div class="container">
            <ul class="breadcrumb">
                <li>My account</li>
            </ul>
        </div>
    </div>
    <div class="ps-my-account">
        <div class="container">
            <form action="{{ route('seller.showmediafileUpdate', $mediafile->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <a href="{{ route('seller.showmediafile') }}" class="btn btn-dark">Back</a>
                <ul class="ps-tab-list">
                    <li class="active"><a href="#createad">Edit Media & Files</a></li>
                </ul>

                @if(session('error'))
                    <p class="alert alert-danger" role="alert">
                        {{ session('error') }}
                    </p>
                @endif
                
                <div class="ps-tabs">
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" name="name" id="name" value="{{ $mediafile->name }}" class="form-control">
                        @error('name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="media_file">Upload Media</label>
                        <input type="file" name="media_file" id="media_file" class="form-control">
                        @error('media_file')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                        <video width="200" controls>
                            <source src="{{ asset('storage/' . $mediafile->file_path) }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                    <div class="form-group">
                        <label for="media_link">Submit Link (Google Drive/OneDrive/Dropbox)</label>
                        <input type="url" name="external_link" value="{{ $mediafile->external_link }}" id="external_link" class="form-control" value="{{ old('external_link') }}">
                        @error('external_link')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="price">price</label>
                        <input type="number" name="price" value="{{ $mediafile->price }}" id="price" class="form-control" value="{{ old('price') }}">
                        @error('price')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group submit">
                        <button class="ps-btn ps-btn--fullwidth">Upload Media</button>
                    </div>
                </div> 
            </form>
        </div>
    </div>
</div>

@endsection
