@extends('seller.profile')
@php
    $profile = auth()->user()->profile;
@endphp
@section('content')
    <style>
        .card {
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            transition: transform 0.3s, box-shadow 0.3s;
            background-color: #fff;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
        }

        .card-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 10px;
        }

        .card-text {
            font-size: 1.5rem;
            color: #555;
        }

        .card-status {
            font-size: 1.5rem;
            color: #ff4d4d;
            font-weight: bold;
        }

        .card img {
            width: 100%;
            margin-bottom: 15px;
            border-radius: 8px;
        }

        .card {
            background-color: #f9f9f9;
        }

        .card-status {
            background-color: #ffdede;
            padding: 5px 10px;
            border-radius: 5px;
            display: inline-block;
            color: #d9534f;
        }

        .card-status.approved {
            background-color: #d4edda;
            color: #155724;
        }

        .card-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            padding: 20px;
        }
    </style>
    @php
        $can = App\Models\Can::where('user_id', Auth::user()->id)->first();
    @endphp
    {{-- <div class="container m-5 p-5 text-center"> --}}
    <div class="col-lg-8 text-center">
        <div class="py-2">
            {{-- @session('success')
        <p class="alert alert-success m-sm-5" role="alert">
            {{session('success')}}
        </p>
        @endsession --}}


            <h1>Ads</h1>
            <p>Welcome to your dashboard</p>
            {{-- @if (Auth::user()->role === 'admin')
        <a  class="btn btn-secondary" href="{{route('admin.dashboard')}}">Admin Dashboard</a>
        @endif

        @php
            $is_approved = false
        @endphp
        @if (Auth::user()->profile->status === 'verified' && $can->stock > 0)
            @php
                $is_approved = true
            @endphp
        @endif
        {{-- <a href="{{route('seller.sell-to-lovecans')}}" class="btn btn-secondary">Sell To Lovecans</a> --}}
            {{-- <a href="{{route('seller.sell-offers')}}" class="btn btn-secondary">Sell Offers</a> --}}
            {{-- <a href="/store" class="btn btn-secondary">Lovecans Store</a> --}}
            <a class="btn hoverable text-white btn-lg" href="/createad">Create Ad</a>
        </div>

        @php
            $ads = App\Models\Ad::where('user_id', Auth::user()->id)
                ->orderBy('id', 'desc')
                ->get();
            $can = App\Models\Can::where('user_id', Auth::user()->id)->first();
        @endphp

        {{-- <div class="text-right">
        <h4>No of Cans available: {{ $can ? $can->stock : 0 }}</h4>
    </div> --}}

        {{-- <div> --}}
        <div class="row">
            {{-- @session('error')
                <p class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </p>
            @endsession --}}
            @foreach ($ads as $ad)
                <div class="col-lg-4 col-md-4 col-sm-6">
                    <div class="card-container">
                        <div class="card" style="border: 1px solid {{ $ad->ad_status == 'active' ? 'green' : 'grey' }};">
                            @if ($ad->promotion_expiry > now())
                                <span class="my-3 p-2 mt-2 rounded main-theme"> Promoted</span>
                            @else
                                <span class="my-3 p-2 mt-2 rounded dark-theme">Not Promoted</span>
                            @endif


                            <img src="{{ asset('storage/ads/' . $ad->image) }}" class="card-img-top" style="height: 15rem;"
                                alt="...">
                            <h3 class="card-title">{{ $ad->title }}</h3>
                            <p class="card-text">Type: {{ $ad->type }}</p>
                            <p class="card-text">Price: {{ $ad->price }}</p>
                            <p class="card-text">Days Worn: {{ $ad->worn_days }}</p>
                            @if ($ad->status == 'Unapproved')
                                <span
                                    class="my-3 {{ $ad->status == 'Approved' ? 'card-status approved' : 'card-status' }}">{{ $ad->status }}</span>
                            @endif
                            @if ($ad->status == 'Approved')
                                <form action="{{ route('ad.status-update', $ad->id) }}" method="post">
                                    @csrf
                                    <p
                                        class="d-flex justify-content-around p-2 mt-2 rounded {{ $ad->ad_status == 'active' ? 'main-theme' : 'dark-theme' }} justify-content-between">
                                        <span>{{ ucfirst($ad->ad_status) }}</span>
                                        <button name="ad_status" type="submit"
                                            value="{{ $ad->ad_status == 'active' ? 'inactive' : 'active' }}"
                                            class="btn text-white {{ $ad->ad_status == 'active' ? 'dark-theme' : 'main-theme' }}">{{ $ad->ad_status === 'active' ? 'Inctive' : 'Active' }}</button>
                                    </p>
                                </form>
                            @endif
                            <div class="d-flex justify-content-between" style="font-size: 16px;">
                                <button class="btn btn-lg bg-danger border-0 rounded text-white" data-bs-toggle="modal"
                                    onclick="confirmDelete('{{ route('ad.delete', $ad->id) }}')"
                                    data-bs-target="#deleteProduct" style="cursor: pointer">
                                    Delete
                                </button>


                                <a href="{{ route('ad.edit', $ad->id) }}" class="btn hoverable btn-lg text-white">Edit</a>
                                <a href="{{ route('ad.promote', $ad->id) }}" class="btn btn-warning btn-lg">Promote ad</a>
                            </div>
                        </div>
                        <!-- Add more cards here -->
                    </div>
                </div>
            @endforeach
            @if ($ads->count() == 0)
                <div class="text-center col-12">
                    <hr>
                    <h5>No Ads</h5>
                </div>
            @endif
        </div>
        {{-- </div> --}}
    </div>
    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteProduct" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fs-5" id="exampleModalLabel">Delete Ad</h5>
                </div>
                <div class="modal-body">
                    <p>Are You Sure? You Want To Delete This Ad.</p>
                    <strong>Enter password to delete?</strong>
                    <br>
                    <input type="password" name="password" required="" class="form-control mt-3" id="password"
                        placeholder="Enter Password">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="confirmProductDelete">Delete</button>
                </div>
            </div>
        </div>
    </div>



    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        console.log("Full URL:", window.location.href);
        console.log("Query Parameters:", window.location.search);
        const urlParams = new URLSearchParams(window.location.search);
        console.log("Decoded Query Parameters:", decodeURIComponent(urlParams.toString()));

        const adId = urlParams.get('ad_id');
        const sessionId = urlParams.get('session_id');
        const promotionFee = urlParams.get('promotion_fee');
        const duration = urlParams.get('duration');

        console.log('Ad ID: ' + adId);
        console.log('Session ID: ' + sessionId);
        console.log('Promotion Fee: ' + promotionFee);
        console.log('Duration: ' + duration);
    </script>

    <script>
        function confirmDelete(url) {
            $('#confirmProductDelete').data('url', url); // Save the delete URL
        }

        $("#confirmProductDelete").click(function() {
            var url = $(this).data('url');
            var password = $('#password').val(); // Get password input

            $.ajax({
                url: url,
                type: "POST",
                data: {
                    _method: "DELETE",
                    _token: "{{ csrf_token() }}",
                    password: password // Include password here

                },
                success: function(response) {
                    localStorage.setItem('success_message', response.message);
                    window.location.href = response.redirect_url;
                },
                error: function(xhr) {
                    if (xhr.responseJSON && xhr.responseJSON.redirect_url) {
                        window.location.href = xhr.responseJSON.redirect_url;
                    }
                }
            });
        });
    </script>



@endsection
