<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Administrator</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        .container {
            max-width: 600px;
        }
        .card {
            border-radius: 12px;
            background: #fff;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .btn-primary {
            background-color: #007bff;
            border: none;
            transition: 0.3s ease-in-out;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>

<div class="container d-flex justify-content-center align-items-center min-vh-100">
    <div class="card w-50">
        <h2 class="text-center mb-4">Contact Administrator</h2>

        <div id="successMessage" class="alert alert-success text-center d-none">Message sent successfully!</div>

        <form id="contactForm" action="{{ route('seller.sendAdminMessage') }}" method="post">
            @csrf
            <div class="form-group mb-3">
                <label for="message" class="fw-bold mb-3">Your Message</label>
                <textarea id="message" class="form-control border rounded-3 p-2" name="message" rows="2" required></textarea>
            </div>

            <div class="text-center">
                <button type="submit" class="btn btn-primary px-4 py-2 rounded-pill">Send Message</button>
            </div>
        </form>
    </div>
</div>

</body>
</html>
