@extends('layouts.dashboard')

@section('dashboard')

{{-- Form for the seller to add a ad with following fields ['name', 'type', 'price', 'worn_days', 'approved'] --}}

<div class="ps-page--my-account">
    <div class="ps-breadcrumb">
        <div class="container">
            <ul class="breadcrumb">
                <li>My account</li>
            </ul>
        </div>
    </div>
    <div class="ps-my-account">
        @if(session('error'))
        <p class="alert alert-danger" role="alert">
            {{ session('error') }}
        </p>
        @endif

        <div class="container">
            <form class="ps-form--account ps-tab-root" style="max-width: 100%;" action="{{ route('ad.update', $ad->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                {{-- @method('PUT') --}}
                <ul class="ps-tab-list">
                    <li class="active"><a href="#editad">Edit Ad</a></li>
                </ul>
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
                <div class="ps-tabs">
                    <div class="ps-tab active py-3" id="editad">
                        <div class="ps-form__content">
                            {{-- <h5>Edit Ad</h5> --}}
                            <div class="row">
                                <div class="form-group col-12 col-lg-6">
                                    <label for=""><b>Title</b></label>
                                    <input class="form-control" type="text" name="title" placeholder="Title (max 100 characters)" required value="{{ old('title', $ad->title) }}" maxlength="100">
                                    @error('title')
                                        <span class="help-block text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-12 col-lg-6">
                                    @php
                                        $categories = App\Models\Category::all();
                                    @endphp
                                    <label for=""><b>Category</b></label>
                                    <select class="form-control" type="text" name="type" placeholder="type" required>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->category }}" {{ old('type', $ad->type) == $category->category ? 'selected' : '' }}>{{ $category->category }}</option>
                                        @endforeach
                                    </select>
                                    @error('type')
                                        <span class="help-block text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-12 col-lg-6">
                                    <label for=""><b>No: of Days Worn</b></label>
                                    <input class="form-control" type="number" name="worn_days" placeholder="Worn Days (1 - 7)" required value="{{ old('worn_days', $ad->worn_days) }}" min="1" max="7">
                                    @error('worn_days')
                                        <span class="help-block text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-12 col-lg-6">
                                    <label for=""><b>Price</b></label>
                                    <input class="form-control" type="number" name="price" placeholder="Price" required value="{{ old('price', $ad->price) }}">
                                    @error('price')
                                        <span class="help-block text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label for=""><b>Description</b></label>
                                    @if(auth()->user()->isPeller() == 2)
                                        <textarea name="description" id="editor" class="form-control" placeholder="Description">{{ old('description', $ad->description) }}</textarea>
                                    @else
                                        <input class="form-control" type="text" name="description" placeholder="Description" required value="{{ old('description', $ad->description) }}">
                                    @endif
                                    @error('description')
                                        <span class="help-block text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12 col-lg-6">
                                    <div class="input-group">
                                        <span for="image" class="input-group-text px-4" id="basic-addon1" style="font-size: 16px;">Image</span>
                                        <input class="form-control" type="file" name="image" placeholder="Image" style="padding-top: 10px;" aria-describedby="basic-addon1">
                                    </div>
                                    @error('image')
                                        <span class="help-block text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                @if($ad->image)
                                    <div class="col-12 col-lg-6">
                                        <p>Main Image:</p>
                                        <div class="d-flex flex-wrap">
                                            <img src="{{ asset('storage/ads/' . $ad->image) }}" alt="Ad Image" style="max-height: 100px; margin-right: 10px; margin-bottom:10px;">
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="row mb-4">
                                <div class="col-12 col-lg-6">
                                    <div class="input-group">
                                        <span for="gallery" class="input-group-text px-4" id="basic-addon2"
                                            style="font-size: 16px;">Gallery Images</span>
                                        <input class="form-control" type="file" name="gallery[]" placeholder="Gallery Images"
                                            style="padding-top: 10px;" aria-describedby="basic-addon2" multiple>
                                    </div>
                                    @if ($errors->has('gallery'))
                                        <span class="help-block text-danger">
                                            <strong>{{ $errors->first('gallery') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                @if($ad->gallery)
                                    <div class="col-12 col-lg-6">
                                        <p>Gallery Images:</p>
                                        <div class="d-flex flex-wrap">
                                            @foreach ($ad->gallery as $image)
                                                <img src="{{ asset('storage/ads/' . $image) }}" alt="Ad Image"
                                                    style="max-height: 100px; margin-right: 10px; margin-bottom:10px;">
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <p>
                                <b>Additional Refinements</b>
                            </p>
                            @php
                                $options = [
                                    'Wearing pictures',
                                    'Waring videos',
                                    'Worn during sport',
                                    'Golden shower',
                                    'Worn during sex',
                                    'Worn inside',
                                    'Lisptick',
                                    'Parfume',
                                    'Worn during masturbation',
                                    'Kaviar',
                                ];
                            @endphp
                            <div id="options-container">
                                @foreach ($options as $key => $option)
                                    <div class="d-flex align-items-center mb-2">
                                        <div class="col-7">
                                            <input class="mx-2 my-2" type="checkbox" value="{{ $option }}" name="refinement_title[{{ $key }}]" {{ in_array($option, $ad->additional_refinement->pluck('refinement_title')->toArray()) ? 'checked' : '' }}>
                                            <label for="free_of_diseases">{{ $option }}</label>
                                            <span style="cursor: help" class="badge rounded-pill bg-secondary text-white" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ $option }}">?</span>
                                        </div>
                                        <div class="col-5">
                                            <input type="number" placeholder="Price" name="refinement_price[{{ $key }}]" class="form-control" value="{{ old("refinement_price.$key", $ad->additional_refinement->where('refinement_title', $option)->first() ? $ad->additional_refinement->where('refinement_title', $option)->first()->refinement_price : '') }}" min="0">
                                            @error("refinement_price.$key")
                                                <p class="text-danger">
                                                    {{ $message }}
                                                </p>
                                            @enderror
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="d-flex mt-3">
                                <input type="text" id="new-option-title" class="form-control me-2" placeholder="Enter Option Title">
                                <button type="button" id="add-option" class="ps-btn btn-sm" style="padding: 4px 20px;">Add Option</button>
                            </div>
                            <hr>
                            <div class="d-flex align-items-start">
                                <input class="mx-2 my-2" type="checkbox" value="1" name="free_of_diseases" required {{ old('free_of_diseases', $ad->free_of_diseases) ? 'checked' : '' }}>
                                <label for="free_of_diseases">I hereby confirm that I am currently free of sexually transmitted diseases.</label>
                            </div>
                            <div class="d-flex align-items-start gap-2">
                                <input class="mx-2 my-2" type="checkbox" name="drugs_free" value="1" required {{ old('drugs_free', $ad->drugs_free) ? 'checked' : '' }}>
                                <label for="drugs_free">I hereby confirm that I am not currently using narcotics.</label>
                            </div>
                            <div class="form-group submtit d-flex justify-content-center mt-2">
                                <button class="ps-btn">Update Ad</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.ckeditor.com/4.22.1/full-all/ckeditor.js"></script>


<script>
        setTimeout(function() {
        document.querySelectorAll('.cke_notification').forEach(el => el.remove());
    }, 1000);
    CKEDITOR.replace('editor', {
        extraPlugins: 'emoji',
        removePlugins: 'elementspath',
        toolbar: [
            ['Bold', 'Italic', 'Underline', 'EmojiPanel'],
            ['TextColor', 'BGColor'],
            ['Font', 'FontSize'],
            ['RemoveFormat']
        ],
        height: 200
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let container = document.getElementById('options-container');
        let addOptionButton = document.getElementById('add-option');
        let newOptionTitleInput = document.getElementById('new-option-title');

        let optionIndex = {{ count($options) }}; // Start index for new options

        // Add Option
        addOptionButton.addEventListener('click', function () {
            let title = newOptionTitleInput.value.trim(); // Get title from input
            if (!title) {
                alert('Please enter a valid option title.');
                return;
            }

            let newOption = document.createElement('div');
            newOption.classList.add('d-flex', 'align-items-center', 'mb-2', 'option-item');
            newOption.innerHTML = `
                <div class="col-6">
                    <input class="mx-2 my-2" type="checkbox" value="${title}" name="refinement_title[${optionIndex}]">
                    <label>${title}</label>
                    <span style="cursor: help" class="badge rounded-pill bg-secondary text-white"  data-bs-toggle="tooltip" data-bs-placement="top" title="${title}">?</span>
                </div>
                <div class="col-1">
                    <button type="button" class="btn btn-danger btn-sm remove-option rounded p-2">X</button>
                </div>
                <div class="col-5">
                    <input type="number" placeholder="Price" name="refinement_price[${optionIndex}]" class="form-control">
                </div>
                
                
            `;

            container.appendChild(newOption);
            optionIndex++;

            newOptionTitleInput.value = ''; // Clear input field
            attachRemoveListeners(); // Reattach remove listeners for new elements
        });

        // Remove Option
        function attachRemoveListeners() {
            document.querySelectorAll('.remove-option').forEach(button => {
                button.removeEventListener('click', removeOption); // Prevent duplicate listeners
                button.addEventListener('click', removeOption);
            });
        }

        function removeOption(event) {
            let parent = event.target.closest('.option-item');
            if (parent) {
                parent.remove();
            }
        }

        attachRemoveListeners(); // Initial attachment for preloaded options
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    const form = document.querySelector('form');

    // Function to check and validate a checkbox and its corresponding input
    function checkCheckboxValidity(checkbox) {
        const key = checkbox.name.match(/\[(\d+)\]/)[1];
        const input = document.querySelector(`input[name="refinement_price[${key}]"]`);

        if (checkbox.checked && !input.value) {
            input.setCustomValidity('Please specify the price.');
        } else {
            input.setCustomValidity('');
        }
    }

    // Initial check of all checkboxes
    checkboxes.forEach(checkCheckboxValidity);

    // Add event listeners for checkbox changes
    checkboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', function() {
            checkCheckboxValidity(this); // Use 'this' to refer to the changed checkbox
        });
    });

    // Add event listener for form submission
    if (form) {
        form.addEventListener('submit', function(event) {
            checkboxes.forEach(function(checkbox) {
                const key = checkbox.name.match(/\[(\d+)\]/)[1];
                const input = document.querySelector(`input[name="refinement_price[${key}]"]`);

                if (checkbox.checked && !input.value) {
                    input.reportValidity();
                    event.preventDefault();
                }
            });
        });
    }
});
</script>
@endsection