@extends('seller.profile')
@section('content')

<div class="col-lg-8">

    @if ($isVerified)
        <div class="alert alert-success">
            You are a verified seller!
        </div>
    @else
        <div class="ps-section__right">
            <form class="ps-form--account-setting" action="{{ route('profile.verifications') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="ps-form__header">
                    <h3>Verification</h3>
                </div>
                <div class="ps-form__content">
                    <div class="row">
                        <div class="col-6 mb-3">
                            <h5>Example Verification Image</h5>
                            <img src="{{ asset('img/verification.jpeg') }}" class="rounded float-start" alt="" style="width: 50%">
                        </div>

                        @isset($images)
                            @foreach ($images as $item)
                                <div class="col-6 card p-3">
                                    <h5>Uploaded Image</h5>
                                    <img src="{{ asset('storage/'. $item) }}" alt="" width="100%">
                                </div>
                            @endforeach
                        @endisset

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Upload Image</label>
                                <input class="form-control" type="file" name="images">
                                @error('images')
                                <span class="help-block text-danger">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group submit">
                    <button class="ps-btn">Verify</button>
                </div>
            </form>
        </div>
    @endif
</div>

@endsection
