@extends('seller.profile')

@section('content')
    <div class="col-lg-8">
        @if (Auth::user()->ads()->where('status', 'blocked')->count() > 0)
    <div class="ps-section__right">
        <!-- Show message for blocked account -->
        <p>Your account has been blocked. Please contact admin for unblocking.</p>
    </div>
@else
    <!-- Show form for non-blocked account -->
    <div class="ps-section__right">
        <form class="ps-form--account-setting" action="{{ route('profile.update', $profile)}}" method="POST" enctype="multipart/form-data">
            @method('PUT')
        @csrf
        <div class="ps-form__header">
            <h3> User Information</h3>
        </div>
        <div class="ps-form__content">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Name</label>
                        <input class="form-control" type="text" value="{{ $profile ? $profile->nickname: '' }}" name="nickname" placeholder="Please enter your Nickname...">
                        @if ($errors->has('nickname'))
                        <span class="help-block text-danger">
                            <strong>{{ $errors->first('nickname') }}</strong>
                        </span>
                        @endif
                       <p class="text-muted mt-2">
                            You are a <b> {{ auth()->user()->isPSeller() ? 'Premium' : 'Standard' }} </b> seller 
                            @if($profile->membership_id)
                            <p>And your membership expires on <b>{{ $profile->membership_expiry }}</b></p>
                        @endif
                        </p>
                        
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Gender</label>
                        <input type="text" class="form-control" value="{{ ucfirst($profile->gender) }}" disabled>
                
                        <p class="text-muted mt-2">
                            If you want to change the gender, please contact the administrator. 
                            <a href="{{ route('seller.contact.admin') }}" class="text-primary">Contact Admin</a>
                        </p>
                    </div>
                </div>
                
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Age</label>
                        <input type="number" class="form-control" id="age_input" name="age" 
                            placeholder="Enter your age" value="{{ $profile->age }}">
                        @if ($errors->has('age'))
                            <span class="help-block text-danger">
                                <strong>{{ $errors->first('age') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <input type="checkbox" id="show_age_checkbox" name="show_age" value="1" {{ $profile->show_age ? 'checked' : '' }}>
                        <label>Show my age on my profile</label>
                    </div>
                </div>
                
<div class="col-sm-6">
                    <div class="form-group">
                        <label>Clothing Size</label>
                        <select class="form-control" id="clothing_size_select" name="clothing_size">
                            <option value="">Select Clothing Size</option>
                            <option value="xs" {{ $profile->clothing_size == 'xs' ? 'selected' : '' }}>XS</option>
                            <option value="s" {{ $profile->clothing_size == 's' ? 'selected' : '' }}>S</option>
                            <option value="m" {{ $profile->clothing_size == 'm' ? 'selected' : '' }}>M</option>
                            <option value="l" {{ $profile->clothing_size == 'l' ? 'selected' : '' }}>L</option>
                            <option value="xl" {{ $profile->clothing_size == 'xl' ? 'selected' : '' }}>XL</option>
                            <option value="xxl" {{ $profile->clothing_size == 'xxl' ? 'selected' : '' }}>XXL</option>
                            <option value="xxxl" {{ $profile->clothing_size == 'xxxl' ? 'selected' : '' }}>XXXL</option>
                        </select>
                        @if ($errors->has('clothing_size'))
                            <span class="help-block text-danger">
                                <strong>{{ $errors->first('clothing_size') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <input type="checkbox" id="show_clothing_size_checkbox" name="show_clothing_size" value="1" {{ $profile->show_clothing_size ? 'checked' : '' }}>
                        <label>Show my clothing size on my profile</label>
                    </div>
                </div>
                
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Type</label>
                        <select class="form-control" name="type">
                            <option value="German"  {{ $profile->type == 'German' ? 'selected' : '' }}>German</option>
                            <option value="Western European"  {{ $profile->type == 'Western European' ? 'selected' : '' }}>Western European</option>
                            <option value="European"  {{ $profile->type == 'European' ? 'selected' : '' }}>European</option>
                            <option value="Scandinavian"  {{ $profile->type == 'Scandinavian' ? 'selected' : '' }}>Scandinavian</option>
                            <option value="Eastern European"  {{ $profile->type == 'Eastern European' ? 'selected' : '' }}>Eastern European</option>
                            <option value="Southern European"  {{ $profile->type == 'Southern European' ? 'selected' : '' }}>Southern European</option>
                            <option value="Asian"  {{ $profile->type == 'Asian' ? 'selected' : '' }}>Asian</option>
                            <option value="South and Latin American"  {{ $profile->type == 'South and Latin American' ? 'selected' : '' }}>South and Latin American</option>
                            <option value="Oriental"  {{ $profile->type == 'Oriental' ? 'selected' : '' }}>Oriental</option>
                            <option value="African American"  {{ $profile->type == 'African American' ? 'selected' : '' }}>African American</option>
                            <option value="Exotic"  {{ $profile->type == 'Exotic' ? 'selected' : '' }}>Exotic</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Figure</label>
                        <select class="form-control" name="figure">
                            <option value="Athletic" {{ $profile->figure == 'Exotic' ? 'selected' : '' }}>Athletic</option>
                            <option value="Normal" {{ $profile->figure == 'Normal' ? 'selected' : '' }}>Normal</option>
                            <option value="Slim" {{ $profile->figure == 'Slim' ? 'selected' : '' }}>Slim</option>
                            <option value="Chubby" {{ $profile->figure == 'Chubby' ? 'selected' : '' }}>Scandinavian</option>
                            <option value="Fat" {{ $profile->figure == 'Fat' ? 'selected' : '' }}>Fat</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Hair Color</label>
                        <select class="form-control" name="hair_color">
                            <option value="Blonde"  {{ $profile->hair_color == 'Blonde' ? 'selected' : '' }}>Blonde</option>
                            <option value="Brunette"  {{ $profile->hair_color == 'Brunette' ? 'selected' : '' }}>Brunette</option>
                            <option value="Black"  {{ $profile->hair_color == 'Black' ? 'selected' : '' }}>Black</option>
                            <option value="Red"  {{ $profile->hair_color == 'Red' ? 'selected' : '' }}>Red</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Eye color</label>
                        <select class="form-control" name="eye_color">
                            <option value="Blue"  {{ $profile->eye_color == 'Blue' ? 'selected' : '' }}>Blue</option>
                            <option value="Brown"  {{ $profile->eye_color == 'Brown' ? 'selected' : '' }}>Brown</option>
                            <option value="Green"  {{ $profile->eye_color == 'Green' ? 'selected' : '' }}>Green</option>
                            <option value="Grey"  {{ $profile->eye_color == 'Grey' ? 'selected' : '' }}>Grey</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Address</label>
                        <input class="form-control" type="text" name="address" value="{{ $profile ? $profile->address: '' }}" placeholder="Please enter your address...">
                        @if ($errors->has('address'))
                        <span class="help-block text-danger">
                            <strong>{{ $errors->first('address') }}</strong>
                        </span>
                        @endif
                    </div>
                </div>
                {{-- <div class="col-sm-6">
                    <div class="form-group">
                        <label>Profile Picture</label>
                        <input type="file" alt="" name="profile_picture">
                    </div>
                </div> --}}
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Profile Picture</label>
                        <input type="file" alt="" name="profile_picture" class="form-control" style="padding: 10px 20px;">
                         @if ($errors->has('profile_picture'))
                        <span class="help-block text-danger">
                            <strong>{{ $errors->first('profile_picture') }}</strong>
                        </span>
                        @endif
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Instagram Link</label>
                        <input type="text" alt="" value="{{  $profile ? $profile->instagram: '' }}" name="instagram" class="form-control" placeholder="instagram profile link">
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Onlyfans Link</label>
                        <input type="text" alt="" name="onlyfans" value="{{  $profile ? $profile->onlyfans: '' }}" class="form-control" placeholder="onlyfans profile link">
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Snapchat Link</label>
                        <input type="text" alt="" name="snapchat" value="{{  $profile ? $profile->snapchat: '' }}" class="form-control" placeholder="snapchat profile link">
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control" name="description" cols="30" rows="5">{{ $profile ? $profile->description: '' }}</textarea>
                        @if ($errors->has('description'))
                        <span class="help-block text-danger">
                            <strong>{{ $errors->first('description') }}</strong>
                        </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group submit">
            <button class="ps-btn">Update</button>
        </div>
    </form>
</div>
@endif

    </div>
   <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('#show_age_checkbox').change(function () {
            if ($(this).is(':checked')) {
                // Checkbox selected → Age input me default age set karo
                $('#age_input').val("{{ $profile->age ?? '' }}");
            } else {
                // Checkbox unselected → Age input ko empty karo
                $('#age_input').val('');
            }
        });
    });
    $(document).ready(function () {
        $('#show_clothing_size_checkbox').change(function () {
            if ($(this).is(':checked')) {
                // Checkbox selected → Clothing size ko default value de do
                $('#clothing_size_select').val("{{ $profile->clothing_size ?? '' }}");
            } else {
                // Checkbox unselected → Clothing size empty kar do
                $('#clothing_size_select').val('');
            }
        });
    });
</script>
@endsection

