@extends('seller.profile')

@section('content')

    {{-- password change --}}
    <div class="col-lg-8">
        <div style="height: 60px">
            <strong>
                Accepted Offers
            </strong>
        </div>
        @error('tracking_link')
            <p class="text-danger">
                {{$message}}
            </p>
        @enderror
        <div class="ps-section__right ">
            <div class=" ps-section__content">
                <div class="table-responsive overflow-auto">
                    <table class="table table-striped">
                        <thead>
                            <tr class="text-center" align="center">
                                <th>Order No.</th>
                                <th>Product Image</th>
                                <th>Product</th>
                                <th>Price</th>
                                <th>Quantity</th>
                                <th>Total Price</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($offers as $offer)
                            <tr align="center">
                                <td>{{$loop->iteration}}</td>
                                <td>
                                    <a href="{{asset('storage/ads/'.$offer->image)}}"  target="_blank"><img src="{{asset('storage/ads/'.$offer->image)}}" alt="" style="width: 50px"></a>
                                </td>
                                <td>
                                    {{$offer->title}}
                                </td>
                                <td>
                                    ${{$offer->price}}
                                </td>
                                <td>{{$offer->quantity}}</td>
                                <td>${{$offer->price*$offer->quantity}}</td>
                                <td>
                                    <form action="{{route('profile.add-tracking-link')}}" method="POST"  class="d-flex justify-content-between">
                                        @csrf
                                        <input type="hidden" name="offer_id" value="{{$offer->id}}">
                                        <input type="text" name="tracking_link" placeholder="Tracking Link.." class="form-control" value="{{$offer->tracking_link}}" style="width: fit-content">
                                        <button type="submit" class="ps-btn form-control text-dark mx-1 py-2" style="width: fit-content" >Add Link</button>
                                    
                                    </form>
                                
                                    <form action="{{route('profile.update-offer-status')}}" method="POST"  class="d-flex justify-content-between my-1">
                                        @csrf
                                        <input type="hidden" name="offer_id" value="{{$offer->id}}">
                                        <select name="offer_sent_status" id="" class="form-control " style="width: fit-content">
                                            <option value="pending" {{($offer->offer_sent_status == 'pending')? 'selected' : ''}}>Pending </option>
                                            <option value="inprogress" {{($offer->offer_sent_status == 'inprogress')? 'selected' : ''}}>Inprogress </option>
                                            <option value="cancelled" {{($offer->offer_sent_status == 'cancelled')? 'selected' : ''}}>Cancelled </option>
                                            <option value="sent" {{($offer->offer_sent_status == 'sent')? 'selected' : ''}}>Sent  </option>
                                        </select>
                                        <button type="submit" class="ps-btn form-control text-dark mx-1" {{($offer->offer_sent_status == 'sent')? 'disabled' : ''}} style="width: fit-content">Update</button>
                                    
                                    </form>
                                </td>
                            </tr>
                            @endforeach 
                            
                            @if ($offers->count() == 0)
                                <tr>
                                    <td  class="text-center" colspan="7">
                                        <h4>No Offer Accepted</h4>
                                    </td>
                                </tr>
                            @endif 
                        </tbody>
                    </table>
                </div>
                {!! $offers->withQueryString()->links('pagination::bootstrap-5') !!}  
            </div>
        </div>
    </div>

@endsection