@extends('seller.profile')
@section('content')

    {{-- password change --}}
    <div class="col-lg-8">
        <div style="height: 60px">
            <strong>
                Orders
            </strong>
        </div>
        <div class="ps-section__right">
            <div class="ps-section__content">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr class="text-center" align="center">
                                <th>Order No.</th>
                                <th>Product Image</th>
                                <th>Product</th>
                                <th>Price</th>
                                <th>Quantity</th>
                                <th>Total Price</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($orders as $order)
                            <tr align="center">
                                <td>{{$loop->iteration}}</td>
                                <td>
                                    <a href="{{asset('storage/ads/'.$order->image)}}"  target="_blank"><img src="{{asset('storage/ads/'.$order->image)}}" alt="" style="width: 50px"></a>
                                </td>
                                <td>
                                    {{$order->title}}
                                </td>
                                <td>
                                    ${{$order->price}}
                                </td>
                                <td>{{$order->quantity}}</td>
                                <td>${{$order->price*$order->quantity}}</td>
                                <form action="{{route('update-order-status')}}" method="POST">
                                    @csrf
                                    <input type="hidden" name="order_id" value="{{$order->order_id}}">
                                    <input type="hidden" name="id" value="{{$order->id}}">
                                    <td class="row justify-content-around">
                                        @error('tracking_link')
                                            <p class="text-danger">
                                                {{$message}}
                                            </p>
                                        @enderror
                                        {{-- <input class="form-control col-sm-3" type="text" placeholder="Tracking link..." name="tracking_link" value="{{$order->tracking_link??''}}"> --}}
                                        <select name="status" id="" class="form-control col-sm-6">
                                            <option value="pending" {{($order->order_status == 'pending')? 'selected' : ''}}>Pending  </option>
                                            <option value="inprogress" {{($order->order_status == 'inprogress')? 'selected' : ''}}>Inprogress </option>
                                            <option value="cancelled" {{($order->order_status == 'cancelled')? 'selected' : ''}}>Cancelled </option>
                                            <option value="sent" {{($order->order_status == 'sent')? 'selected' : ''}}>Sent  </option>
                                        </select>
                                            <button type="submit" style="padding: 0 10px;"  class="ps-btn form-control text-dark col-sm-5" {{($order->order_status == 'sent')? 'disabled' : ''}}>Update</button>
                                    </td>
                                </form>
                            </tr>
                            @endforeach  
                            @if ($orders->count() == 0)
                                <tr>
                                    <td colspan="8">
                                        <p class="text-center">No Orders</p>
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                {!! $orders->withQueryString()->links('pagination::bootstrap-5') !!}  
            </div>
        </div>
    </div>

@endsection