@extends('seller.profile')

@section('content')

    {{-- password change --}}
    <div class="col-lg-8">
        <div class="ps-section__right">
                @isset($message)
                    {{$message}}
                @endisset
                <form class="ps-form--account-setting" action="{{ route('profile.update_password', $profile)}}" method="POST">
                @csrf
                <div class="ps-form__header">
                    <h3> Change Password</h3>
                </div>
                <div class="ps-form__content">
                    <div class="row">
                        {{-- old password --}}
                        <div class="col-12">
                            <div class="form-group">
                                <label>Old Password</label>
                                <input class="form-control" type="password" name="old_password" placeholder="Old Password...">
                                @if ($errors->has('old_password'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('old_password') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                        {{-- new password --}}
                        <div class="col-12">
                            <div class="form-group">
                                <label>New Password</label>
                                <input class="form-control" type="password" name="password" placeholder="New Password...">
                                @if ($errors->has('new_password'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('new_password') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                        {{-- Nickname --}}
                        <div class="col-12">
                            <div class="form-group">
                                <label>Confirm Password</label>
                                <input class="form-control" type="password" name="password_confirmation" placeholder="Confirm Password...">
                                @if ($errors->has('password'))
                                <span class="help-block text-danger">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group submit">
                    <button class="ps-btn">Change Password</button>
                </div>
            </form>
        </div>
    </div>

@endsection