@extends('seller.profile')

@section('content')
    {{-- password change --}}
    <div class="col-lg-8">
        <div style="height: 60px">
            <strong>
                Balance
            </strong>
        </div>
        <div class="ps-section__right">
            <div class="ps-section__content">
                @session('success')
                    <p class="col-12 alert alert-success" role="alert">
                        {{session('success')}}
                    </p>
                @endsession

                @session('error')
                    <p class="col-12 alert alert-danger" role="alert">
                        {{session('error')}}
                    </p>
                @endsession
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Current Balance</th>
                            <th>Last Paid out</th>
                            <th>Frozen</th>
                            <th>Total Earning</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>${{$details['current_balance']??0}}</td>
                            <td>${{$details['last_payout_amount']??0}}</td>
                            <td>${{$details['frozen_balance']??0}}</td>
                            <td>${{$details['total_earnings']??0}}</td>
                        </tr>
                    </tbody>
                </table>
              <form action="{{route('seller.payout-request')}}" method="POST">
    @csrf
    <input type="hidden" name="amount" value="{{$details['frozen_balance']??0}}">
    <button type="submit" class="ps-btn" {{(isset($details['frozen_balance']) && $details['frozen_balance'] >= 50) ? '' : 'disabled'}}>
        Send Payout Request (min $50)
    </button>
    @error('amount')
        <p class="text-danger">{{ $message }}</p>
    @enderror
</form>

                
                @isset($accountLink)
                    <button class="ps-btn mt-3" ><a href="{{$accountLink}}">Create Account</a></button>
                @endisset

                @if (!(isset($accountLink)))
                    <button class="ps-btn mt-3" ><a href="{{route('seller.delete-account')}}">Delete Account</a></button>
                @endif
            </div>
        </div>


        {{-- <div class="container mt-3">
            <div class="row">
                <div class="col-md-8 p-0">
                    <div class="card shadow-lg" style="border-radius: 15px;">
                        <div class="card-header" style="background-color: #B47377; color: #333333; text-align: center;">
                            <h4>Add Account</h4>
                        </div>

                        <div class="card-body" style="background-color: #F4F0F0; border-radius: 15px;">
                            <form method="POST" action="{{route('profile.create-account')}}">
                                @csrf
                                <div class="form-group mb-3">
                                    <label for="stripe_account" style="color: #333333; font-weight: bold;">Account ID</label>
                                    <input type="text" id="stripe_account" name="account_id" class="form-control" placeholder="Enter Account ID" required>
                                    @error('account_id')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="account_holder_name" style="color: #333333; font-weight: bold;">Account Holder Name</label>
                                    <input type="text" id="account_holder_name" name="account_holder_name" class="form-control" placeholder="Enter Account Holder's Name" required>
                                    @error('account_holder_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="account_holder_name" style="color: #333333; font-weight: bold;">Account Type </label>
                                    <select name="account_type" id="" class="form-control">
                                        <option value="">Select Account Type</option>
                                        <option value="stripe">Stripe</option>
                                        <option value="paypal">PayPal</option>
                                    </select>
                                    @error('account_type')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="d-flex justify-content-between">
                                    <button type="submit" class="btn" style="background-color: #FFE287; border-color: #FFE287; font-weight: bold; padding: 10px 20px;">Add Account</button>
                                </div>
                            </form>

                            @php
                                $accounts = App\Models\Account::where('user_id', Auth::user()->id)->get();
                            @endphp
                            @foreach ($accounts as $account)
                                <div class="mt-4 p-3 border" style="background-color: #FFE287; border-radius: 10px;">
                                    <h5>Account Details</h5>
                                    <p><strong>Account ID:</strong> {{$account->account_number}}</p>
                                    <p><strong>Account Holder:</strong>{{$account->account_name}}</p>
                                    <p><strong>Account Method:</strong>{{$account->method}}</p>
                                    <a href="" class="btn btn-dark">Remove Account</a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}

        

    </div>
<!-- jQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<script>
    $(document).ready(function () {

        // Send AJAX POST request on page reload
        $.ajax({
            url: '{{ route("seller.add-account") }}',
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}' // Required for Laravel POST
            },
            success: function (response) {
                console.log(response)
            },
            error: function (xhr, status, error) {
                console.error("Error:", xhr.responseText);
            }
        });
    });
</script>

</script>
@endsection