@extends('seller.profile')

@section('content')
    {{-- password change --}}
    <div class="col-lg-8">
        <div style="height: 60px">
            <h4 class="my-4">
                Seller Accounts
            </h4>
        </div>
        


        <div class="container mt-3">
            <div class="row">
                <div class="col-md-8 p-0">
                    <div class="card shadow-lg" style="border-radius: 15px;">
                        <div class="card-header" style="background-color: #212529; color: #333333; text-align: center;">
                            <h4 class="my-4" style="color: #fff">Add Account</h4>
                        </div>

                        <div class="card-body" style="background-color: #fff; border-radius: 15px;">
                            <form method="POST" action="{{route('profile.create-account')}}">
                                @csrf
                                <div class="form-group mb-3">
                                    <label for="stripe_account" style="color: #333333; font-weight: bold;">Account ID</label>
                                    <input type="text" id="stripe_account" name="account_id" class="form-control" placeholder="Enter Account ID" required>
                                    @error('account_id')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="account_holder_name" style="color: #333333; font-weight: bold;">Account Holder Name</label>
                                    <input type="text" id="account_holder_name" name="account_holder_name" class="form-control" placeholder="Enter Account Holder's Name" required>
                                    @error('account_holder_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="account_holder_name" style="color: #333333; font-weight: bold;">Account Type </label>
                                    <select name="account_type" id="" class="form-control">
                                        <option value="">Select Account Type</option>
                                        <option value="stripe">Stripe</option>
                                        <option value="paypal">PayPal</option>
                                    </select>
                                    @error('account_type')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="d-flex justify-content-between">
                                    <button type="submit" class="btn" style="background-color: #FFE287; border-color: #FFE287; font-weight: bold; padding: 10px 20px;">Add Account</button>
                                </div>
                            </form>

                            @php
                                $accounts = App\Models\Account::where('user_id', Auth::user()->id)->get();
                            @endphp
                            @foreach ($accounts as $account)
                                <div class="mt-4 p-3 border" style="background-color: #FFE287; border-radius: 10px;">
                                    <h5>Account Details</h5>
                                    <p><strong>Account ID:</strong> {{$account->account_number}}</p>
                                    <p><strong>Account Holder:</strong>{{$account->account_name}}</p>
                                    <p><strong>Account Method:</strong>{{$account->method}}</p>
                                    <a href="" class="btn btn-dark">Remove Account</a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        

    </div>

@endsection