<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="author" content="">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <title>Lovecans</title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="https://fonts.googleapis.com/css?family=Work+Sans:300,400,500,600,700&amp;amp;subset=latin-ext"
        rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/plugins/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/fonts/Linearicons/Linearicons/Font/demo-files/demo.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/plugins/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/plugins/owl-carousel/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/plugins/owl-carousel/assets/owl.theme.default.min.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/plugins/slick/slick/slick.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/plugins/nouislider/nouislider.min.css">
    <link rel="stylesheet"
        href="{{ asset('') }}assets/user/plugins/lightGallery-master/dist/css/lightgallery.min.css">
    <link rel="stylesheet"
        href="{{ asset('') }}assets/user/plugins/jquery-bar-rating/dist/themes/fontawesome-stars.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/plugins/select2/dist/css/select2.min.css">
    <link rel="stylesheet" href="{{ asset('') }}assets/user/css/style.css">
    <link rel="shortcut icon" href="{{ asset('') }}img/logos/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://www.google.com/recaptcha/api.js?render={{ env('GOOGLE_RECAPTCHA_KEY') }}"></script>



    <style>
        /* #EAD5C4 */
        .dropdown-menu {
            display: none;
            position: absolute;
            /*background: #D3A5A5;*/
            background: #ffff;
            border: 1px solid #2C2C2C;
            padding: 10px;
            list-style: none;
            width: 200px;
            /* Increase width */
            top: 100%;
            left: 20;
            z-index: 1000;
            border-radius: 5px;
        }

        .btn.focus,
        .btn:focus {
            outline: 0;
            box-shadow: none;
        }

        /* Show dropdown on hover */
        .nav-item.dropdown:hover .dropdown-menu {
            display: block;
        }

        /* Styling dropdown links */
        .dropdown-menu a {
            display: block;
            font-size: 15px;
            padding: 10px;
            color: #000000;
            text-decoration: none;
        }

        /* Hover effect */
        /*.dropdown-menu a:hover {*/
        /*    background: #fff;*/
        /*    color: black;*/
        /*}*/

        .dropdown-menu a:hover {
            background: #EA016C;
            color: #fff;
        }

        .mobile_menu_header {
    position: absolute;
    top: 60px; /* Adjust this based on your header height */
    left: 0;
    right: 0;
    background-color: rgba(234, 1, 108, 1)
    ; /* Transparent background */
    z-index: 1000; /* Make sure it sits on top */
    max-height: 0; /* Initially collapsed */
    overflow: hidden; /* Hide content when collapsed */
    transition: max-height 0.5s ease-in-out; /* Smooth transition */
    backdrop-filter: blur(5px); /* Optional: adds a blur effect to the background */
}


        .mobile_menu_ul {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            padding: 0 0 20px 0;
            text-align: center;
        }

        .mobile_menu_ul li {
            margin-top: 20px;
            position: relative; /* Needed for the ::after positioning */
            list-style: none;
        }

        .mobile_menu_ul li a {
            text-decoration: none;
            color: inherit;
            position: relative;
            padding-bottom: 5px;
            transition: color 0.3s ease;
        }

        /* Hover text color */
        .mobile_menu_ul li a:hover {
            color: black;
        }

        /* Animated underline on hover */
        .mobile_menu_ul li a::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 2px;
            background-color: black;
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }

        .mobile_menu_ul li a:hover::after {
            width: 100%;
        }





        .search-container {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.6);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            overflow: hidden;
        }


        .search-content {
            background: white;
            padding: 20px;
            border-radius: 10px;
            width: 400px;
            text-align: center;
            position: relative;
            max-height: 150vh;
            /* Limit the height */
            overflow-y: auto;
            /* Enable scrolling inside modal */
        }



        /* Center the filter form */


        /* Overlay effect */
        .filter-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: none;
            z-index: 999;


        }




        .filter-container {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 400px;
            height: auto;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
            display: none;
            /* Hide by default */
            z-index: 1000;
        }

        .filter-container.active {
            display: flex;
        }

        .filter-content {
            position: relative;
            width: 450px;
            padding: 20px;
            background: #ead5c4;
            color: #665552;
        }



        /* .filter-container.active{
            display: flex;
        }
        .filter-content {
            position: relative;
            width: 450px;
            padding: 20px;
            background: #ead5c4;
            color: #665552;
        } */


        .psLogoContanant {

            width: 50%;
        }

        .ps-cart--mini {

            font-size: 25px;
            /* margin: 0 0 0 100px !important; */
            cursor: pointer;
            position: absolute;
            top: 10px;

        }

        .ps-cart--mini .fa,
        .fa-solid {
            margin-left: 15px;
            color: #fff;
            text-decoration: none;
            /* font-size: 25px; */
        }

        .ps-cart--mini .fa:hover,
        .fa-solid:hover {
            color: #000;  /* Ensure color stays the same on hover */
            text-decoration: none;  /* Ensure text decoration stays the same on hover */
            /* font-size: 25px; */
        }

        

        .slc {
            background-color: #000000;
            border-radius: 20px;
            height: 33px;
            margin: 5px 20px;
            align-items: center;
        }



        li.slc a {
            color: white !important;
            padding: 5px 20px;
        }

        li.slc a:hover {
            background: none;
        }

        .header__left {
            max-width: 12%;
        }

        .ps-panel__header p {
            font-size: 30px;
            text-align: right;

        }

        .table-striped tbody tr:nth-of-type(odd) {

            background: #EAD5C4;
        }

        .btn-primary:hover {

            background: #A80150;
        }

        .watch-video-btn {

            background: rgba(0, 0, 0, 0.7);
            color: #fff;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
        }



        .featured_videos .video-container {
            position: relative;
            /* width: 50%; */
        }

        .featured_videos .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .featured_videos .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 25%;
            left: 50%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .featured_videos .video-container:hover .image {
            opacity: 0.3;
            background: rgba(0, 0, 0, 0.9);
        }

        .featured_videos .video-container:hover .middle {
            opacity: 1;
        }

        .featured_videos .text {
            background-color: #04AA6D;
            color: white;
            font-size: 16px;
            padding: 16px 32px;
        }

        .closemodal {
            position: absolute;
            top: -15px;
            right: 10px;
            font-size: 50px;
            cursor: pointer;
            color: white;
            z-index: 1;
        }

        @media (min-width: 400px) and (max-width: 1199px) {
            .header--mobile .header__top{
                display: none;
            }
        }

        .mobile_menu_header {
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.5s ease-in-out;
}

/* When active/open */
.mobile_menu_header.active {
    max-height: 1000px; /* Adjust based on content height */
}






/* Make sure the parent container takes up the full screen */
@media (min-width: 200px) and (max-width: 500px) {

.ccm-modal {
    display: flex;
    justify-content: center;  /* Center horizontally */
    align-items: center;      /* Center vertically */
    position: fixed;          /* Position it fixed on the screen */
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 1000;            /* Make sure it's above other elements */
    background-color: rgba(0, 0, 0, 0.5); /* Optional: for background overlay */
}

/* The modal content (inner) */
.ccm-modal-inner {
    width: 80%;   /* Adjust width as needed */
    max-width: 500px; /* Max width to prevent it from becoming too large on big screens */
    background: white; /* Modal background color */
    padding: 20px; /* Add some padding inside the modal */
    border-radius: 8px; /* Optional: round corners */
    box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.2); /* Optional: shadow */
    bottom: 10% !important;   
}


}


        /* .navigation--mobile ul i {

font-size: 10px;
} */
    </style>
</head>

<body>
    <header class="header header--1" data-sticky="true">
        <div class="header__top">
            <div class="ps-container" style="align-items: center;">
                <div class="header__left">
                    <div class="menu--product-categories">
                        <a href="/">
                            <div class="menu__toggle"><img src="{{ asset('img/logo2.png') }}" width="50%"
                                    alt="">
                            </div>
                        </a>
                    </div>
                    <div class="psLogoContanant">
                        <a class="ps-logo" href="/">
                            <img src="{{ asset('img/logo2.png') }}" style="width: 100%" alt="">
                        </a>
                    </div>
                </div>

                <div class="navigation">
                    <ul class="menu">
                        <li><a href="/" style="padding-left: 20px;">Home</a>
                        </li>
                        <li><a href="/about-us">About</a>
                        </li>

                        <li class="nav-item dropdown" style="position: relative;">
                            <a class="nav-link dropdown-toggle" href="#" role="button">
                                Categories
                            </a>
                            <ul class="dropdown-menu">
                                @php
                                    $categories = App\Models\Category::all();
                                @endphp
                                @forelse ($categories as $category)
                                    <li><a class="dropdown-item text-capitalize"
                                            href="{{ route('category.subcategories', $category->id) }}"
                                            value="{{ $category->id }}">{{ $category->category }}</a></li>
                                @empty
                                    <span class="text-center text-danger text-capitalize">No category found</span>
                                @endforelse
                            </ul>
                        </li>
                        {{-- <li><a href="{{ route('user.categories') }}">Category</a>
                        </li> --}}
                        <li><a href="{{ route('products.filter') }}">Products</a>
                        </li>
                        <li><a href="{{ route('user.medias') }}">Media</a>
                        </li>
                        <li><a href="/contact-us">Contact</a>
                        </li>

                        @if (!Auth::check())
                            {{-- <li><a href="/login">Login</a></li> --}}
                            <li class="slc" style="margin: 0 5px;"><a href="{{ route('register') }}"
                                    class="btn 
                            btn-sm text-light fs-1"
                                    style="padding: 5px 10px;">Sell on Lovecans</a></li>
                            <li class="slc" style="margin: 0 5px;"><a href="{{ route('login') }}"
                                    class="btn 
                                btn-sm text-light fs-1"
                                    style="padding: 5px 10px;">Login</a></li>
                        @else
                            <li class="slc" style="margin: 0 5px;"><a href="{{ route('profile.show') }}"
                                    class="btn 
                            btn-lg text-light fs-1">Dashboard</a></li>
                            <li class="slc" style="margin: 0 5px;"><a href="{{ route('logout') }}"
                                    class="btn 
                            btn-lg text-light fs-1">Logout</a></li>
                        @endif


                    </ul>
                </div>

                <div class="header__right">
                    <div class="header__actions">
                        <div class="ps-cart--mini">
                            <i id="open_filter" class="fa fa-filter fs-1" data-bs-toggle="tooltip"
                                title="Filter"></i>
                            {{-- <i id="open_search" class="fa fa-search"
                            aria-hidden="true" data-bs-toggle="tooltip" title="Search"></i> --}}
                            <a href="{{ route('products.filter') }}"><i class="fa fa-search"
                                    data-bs-toggle="tooltip" title="Search"></i></a>
                            <a class="header__extra" href="/cart">
                                <i class="fa-solid fa-bag-shopping"></i>
                                <span><i class="show-itmes-cart">0</i></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="header__center">
            <form class="ps-form--quick-search" action="{{ route('user.detailed-search') }}" method="POST">
                @csrf
                <div class="form-group--icon">
                    <div class="filter-container" id="filter_container" style="display: none;">
                        <!-- Initially Hidden -->
                        <div class="filter-content">
                            <h4>Filters</h4>
                            @php
                                $categories = App\Models\Category::all();
                            @endphp
                            <hr>
                            <svg id="close_filter" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" fill="white"
                                style="position: absolute; top: 19px; right: 10px; cursor: pointer;">
                                <path d="M6 6L18 18M6 18L18 6" stroke="black" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" />
                            </svg>

                            <label for="type" class="">Type</label>
                            <select name="type" id="type" class="bg-white form-control">
                                <option value="">Select Type</option>
                                @foreach ($categories as $category)
                                    <option value="{{ $category->category }}">{{ $category->category }}</option>
                                @endforeach
                            </select>

                            <label for="worn_days" class="mt-3">Worn Days</label>
                            <input type="number" class="form-control" name="worn_days" id="worn_days"
                                placeholder="Enter number of days">

                            <label for="price" class="mt-3 ">Price</label>
                            <input type="number" class="form-control" name="price" id="price"
                                placeholder="Enter price">

                            <div class="mt-3">
                                <button class="form-control text-white" style="background-color: #665552;">OK</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="search_container" class="search-container" style="display:none;">
                    <div class="search-content" style="background: #EAD5C4;">
                        <h4>Search</h4>
                        <input class="form-control" name="title" type="text" placeholder="Product name..."
                            id="input-search" />

                        <button id="search_button" class="btn btn-primary">Search</button>
                        <svg id="close_search" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                            viewBox="0 0 24 24" fill="black"
                            style="position: absolute; top: 10px; right: 10px; cursor: pointer;">
                            <path d="M6 6L18 18M6 18L18 6" stroke="black" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </svg>
                    </div>
                </div>
            </form>
        </div>
        <!--<nav class="navigation">-->
        <!--    <div class="ps-container">-->
        <!--        <div class="navigation__right">-->
        <!--            <ul class="menu col-lg-8">-->

        <!--                {{-- <li class="menu-item-has-children has-mega-menu"><a href="shop-default-2.html">Shop</a><span class="sub-toggle"></span>-->
        <!--                    <div class="mega-menu">-->
        <!--                        <div class="mega-menu__column">-->
        <!--                            <h4>Catalog Pages<span class="sub-toggle"></span></h4>-->
        <!--                            <ul class="mega-menu__list">-->
        <!--                                <li><a href="#">Shop Default</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Shop Fullwidth</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Shop Categories</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Shop Sidebar</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Shop Without Banner</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Shop Carousel</a>-->
        <!--                                </li>-->
        <!--                            </ul>-->
        <!--                        </div>-->
        <!--                        <div class="mega-menu__column">-->
        <!--                            <h4>Product Layout<span class="sub-toggle"></span></h4>-->
        <!--                            <ul class="mega-menu__list">-->
        <!--                                <li><a href="#">Default</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Extended</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Full Content</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Boxed</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Sidebar</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="#">Fullwidth</a>-->
        <!--                                </li>-->
        <!--                            </ul>-->
        <!--                        </div>-->

        <!--                    </div>-->
        <!--                </li> --}}-->
        <!--                <li class="menu-item-has-children has-mega-menu">-->
        <!--                    {{-- <a href="#">Marketplace</a><span class="sub-toggle"></span> --}}-->
        <!--                    {{-- <div class="mega-menu">-->
        <!--                        <div class="mega-menu__column">-->
        <!--                            <h4>Basic Page<span class="sub-toggle"></span></h4>-->
        <!--                            <ul class="mega-menu__list">-->
        <!--                                <li><a href="{{route('user.about-us')}}">About Us</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="{{route('user.contact-us')}}">Contact</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="{{route('user.faqs')}}">Faqs</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="comming-soon">Comming Soon</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="404">404 Page</a>-->
        <!--                                </li>-->
        <!--                            </ul>-->
        <!--                        </div>-->
        <!--                        <div class="mega-menu__column">-->
        <!--                            <h4>Vendor Pages<span class="sub-toggle"></span></h4>-->
        <!--                            <ul class="mega-menu__list">-->
        <!--                                <li><a href="become-a-vendor">Become a Vendor</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="vendor-store">Vendor Store</a>-->
        <!--                                </li>-->
        <!--                                <li><a href="vendor-dashboard">Vendor Dashboard</a>-->
        <!--                                </li>-->

        <!--                            </ul>-->
        <!--                        </div>-->
        <!--                    </div> --}}-->
        <!--                </li>-->
        <!--            </ul>-->
        <!--            <ul class="navigation__extra py-3">-->
        <!--                @if (!Auth::check())
-->
        <!--                    {{-- <li><a href="/login">Login</a></li> --}}-->
        <!--                    <li><a href="/profile" class="btn btn-dark btn-lg text-light fs-1">Sell on Lovecans</a></li>-->
        <!--
@endif-->
        <!--                {{-- <li><a href="/login">Buy</a></li> --}}-->
        <!--                {{-- <li><a href="#">Tract your order</a></li> --}}-->
        <!--                {{-- <li>-->
        <!--                    <div class="ps-dropdown"><a href="#">US Dollar</a>-->
        <!--                        <ul class="ps-dropdown-menu">-->
        <!--                            <li><a href="#">Us Dollar</a></li>-->
        <!--                            <li><a href="#">Euro</a></li>-->
        <!--                        </ul>-->
        <!--                    </div>-->
        <!--                </li> --}}-->
        <!--                {{-- <li>-->
        <!--                    <div class="ps-dropdown language"><a href="#"><img src="img/flag/en.png" alt="" />English</a>-->
        <!--                        <ul class="ps-dropdown-menu">-->
        <!--                            <li><a href="#"><img src="img/flag/germany.png" alt="" /> Germany</a></li>-->
        <!--                            <li><a href="#"><img src="img/flag/fr.png" alt="" /> France</a></li>-->
        <!--                        </ul>-->
        <!--                    </div>-->
        <!--                </li> --}}-->
        <!--            </ul>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</nav>-->
    </header>

    <header class="header header--mobile" data-sticky="true">
        <div class="header__top">
            <div class="header__left">
                <p>Welcome to Lovecans !</p>
            </div>
            <div class="header__right">
                <ul class="navigation__extra">
                    <li><a href="#">Sell on Lovecans</a></li>
                    <li><a href="#">Tract your order</a></li>
                    {{-- <li>
                        <div class="ps-dropdown"><a href="#">US Dollar</a>
                            <ul class="ps-dropdown-menu">
                                <li><a href="#">Us Dollar</a></li>
                                <li><a href="#">Euro</a></li>
                            </ul>
                        </div>
                    </li>
                    <li>
                        <div class="ps-dropdown language"><a href="#"><img src="img/flag/en.png" alt="" />English</a>
                            <ul class="ps-dropdown-menu">
                                <li><a href="#"><img src="img/flag/germany.png" alt="" /> Germany</a></li>
                                <li><a href="#"><img src="img/flag/fr.png" alt="" /> France</a></li>
                            </ul>
                        </div>
                    </li> --}}
                </ul>
            </div>
        </div>
        <div class="navigation--mobile">
            <div class="navigation__left"><a class="ps-logo" href="/"><img src="{{ asset('img/logo2.png') }}"
                        alt="" style="width: 60px;margin-top: 10px" /></a></div>
            <div class="navigation__right">
                <div class="header__actions">
                    <div class="ps-cart--mini mt-3">

                        <ul class=""
                            style="  list-style: none; display: flex; align-items: center; gap: 15px; padding: 0;margin: 0;">
                            <li style="display: flex;align-items: center;"><a
                            class="navigation__item menu ps-toggle--sidebar" href="#"><i
                            class="icon-menu"></i></a></li>

                                        
                            <li style="display: flex;align-items: center;"><i id="open_filter1"
                                    class="fa fa-filter fs-1" data-bs-toggle="tooltip" title="Filter"></i></li>
                            <li style="display: flex;align-items: center;"><i id="open_search1" class="fa fa-search"
                                    aria-hidden="true" data-bs-toggle="tooltip" title="Search"></i></li>
                            <li>
                                <a style="margin-top: 0 !important;" class="header__extra" href="/cart">
                                    <i class="icon-bag2"></i>
                                    <span><i class="show-itmes-cart">0</i></span>
                                </a>
                            </li>



                            <div class="header__center">
                                <form class="ps-form--quick-search" action="{{ route('user.detailed-search') }}"
                                    method="POST">
                                    @csrf
                                    <div class="form-group--icon" style="background-color: rgba(0, 0, 0, 0.5);">
                                        <div class="filter-container" id="filter_container1" style="display: none;">
                                            <div class="filter-content"
                                                style="position: relative; width: 90%; top: 20px; left: 20px;">
                                                <h4>Filters</h4>
                                                @php
                                                    $categories = App\Models\Category::all();
                                                @endphp
                                                <hr>
                                                <svg id="close_filter1" xmlns="http://www.w3.org/2000/svg"
                                                    width="24" height="24" viewBox="0 0 24 24" fill="white"
                                                    style="position: absolute; top: 19px; right: 10px; cursor: pointer;">
                                                    <path d="M6 6L18 18M6 18L18 6" stroke="black" stroke-width="2"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>

                                                <label for="type" class="">Type</label>
                                                <select name="type" id="type" class="bg-white form-control">
                                                    <option value="">Select Type</option>
                                                    @foreach ($categories as $category)
                                                        <option value="{{ $category->category }}">
                                                            {{ $category->category }}</option>
                                                    @endforeach
                                                </select>

                                                <label for="worn_days" class="mt-3">Worn Days</label>
                                                <input type="number" class="form-control" name="worn_days"
                                                    id="worn_days" placeholder="Enter number of days">

                                                <label for="price" class="mt-3 ">Price</label>
                                                <input type="number" class="form-control" name="price"
                                                    id="price" placeholder="Enter price">

                                                <div class="mt-4">
                                                    <button class="form-control text-white"
                                                        style="background-color: #665552;">OK</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div id="search_container1" class="search-container" style="display: none;">
                                        <div class="search-content"
                                            style="top: 30%; left: 20px; width: 90%; background: #EAD5C4;">
                                            <h4 class="text-left mt-4" style="font-size: 20px;">Search</h4>
                                            <input class="form-control mt-4" name="title" type="text"
                                                placeholder="Product name..." id="input-search" />
                                            <button id="search_button" class="btn btn-primary">Search</button>
                                            <svg id="close_search1" xmlns="http://www.w3.org/2000/svg" width="24"
                                                height="24" viewBox="0 0 24 24" fill="black"
                                                style="position: absolute; top: 10px; right: 10px; cursor: pointer;">
                                                <path d="M6 6L18 18M6 18L18 6" stroke="black" stroke-width="2"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </div>
                                    </div>


                                </form>
                            </div>


                            <script>
                                document.getElementById('open_filter1').addEventListener('click', function() {
                                    document.getElementById('filter_container1').style.display = 'flex';

                                    // Fix: Use querySelector for a single class element
                                    document.querySelector('.filter-overlay').style.display = 'block';

                                });

                                document.getElementById('close_filter1').addEventListener('click', function() {
                                    document.getElementById('filter_container1').style.display = 'none';

                                    // Fix: Hide overlay when closing filter
                                    document.querySelector('.filter-overlay').style.display = 'none';
                                });

                                document.getElementById('open_search1').addEventListener('click', function() {
                                    // alert('clicked');
                                    document.getElementById('search_container1').style.display = 'block';
                                    // Fix: Hide overlay when closing filter
                                    document.querySelector('.filter-overlay').style.display = 'block';
                                });

                                document.getElementById('close_search1').addEventListener('click', function() {
                                    // alert('clicked');
                                    document.getElementById('search_container1').style.display = 'none';
                                    // Fix: Hide overlay when closing filter
                                    document.querySelector('.filter-overlay').style.display = 'none';
                                });
                            </script>


                        </ul>

                    </div>

                </div>
            </div>
        </div>

    </header>

    <div class="mobile_menu_header">
        <ul class="mobile_menu_ul">
            <li><a href="/">Home</a>
            </li>
            <li><a href="/about-us">About</a>
            </li>

            <li class="nav-item dropdown" style="position: relative;">
                <a class="nav-link dropdown-toggle" href="#" role="button">
                    Categories
                </a>
                <ul class="dropdown-menu">
                    @php
                        $categories = App\Models\Category::all();
                    @endphp
                    @forelse ($categories as $category)
                        <li><a class="dropdown-item text-capitalize"
                                href="{{ route('category.subcategories', $category->id) }}"
                                value="{{ $category->id }}">{{ $category->category }}</a></li>
                    @empty
                        <span class="text-center text-danger text-capitalize">No category found</span>
                    @endforelse
                </ul>
            </li>
            {{-- <li><a href="{{ route('user.categories') }}">Category</a>
            </li> --}}
            <li><a href="{{ route('products.filter') }}">Products</a>
            </li>
            <li><a href="{{ route('user.medias') }}">Media</a>
            </li>
            <li><a href="/contact-us">Contact</a>
            </li>

            @if (!Auth::check())
                {{-- <li><a href="/login">Login</a></li> --}}
                <li class="slc"><a href="{{ route('register') }}"
                        class="btn 
                btn-sm text-light fs-1"
                        >Sell on Lovecans</a></li>
                <li class="slc" style="margin: 0 5px;"><a href="{{ route('login') }}"
                        class="btn 
                    btn-sm text-light fs-1"
                        >Login</a></li>
            @else
                <li class="slc"><a href="{{ route('profile.show') }}"
                        class="btn 
                btn-lg text-light fs-1">Dashboard</a></li>
                <li class="slc" ><a href="{{ route('logout') }}"
                        class="btn 
                btn-lg text-light fs-1">Logout</a></li>
            @endif


        </ul>
    </div>

    @yield('content')

    <style>
        .ps-footer__widgets {
            margin-left: 0;
        }
    </style>
    <footer class="ps-footer">
        <div class="ps-container">
            <div class="row">
                <div class="col-md-3">
                    <div class="pb-5">
                        <img src="{{ asset('img/logo2.png') }}" style="height: 10rem" alt="">
                    </div>
                </div>
                <div class="col-md-3">
                    <aside class="widget widget_footer mt-1">
                        <h4 class="heading">Quick links</h4>
                        <ul class="ps-list--link">
                            @if (auth()->check())
                                <li> <i class="fa-solid fa-chevron-right"></i> <a href="/profile">Seller Dashboard</a>
                                </li>
                            @endif
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('products.filter') }}">Detailed search</a></li>
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('user.vending-machines') }}">Vending machine locations</a></li>
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('user.help-support') }}">Help & Support</a></li>
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('user.how-to-sell') }}">How to sell</a></li>
                        </ul>
                    </aside>
                </div>
                <div class="col-md-3">
                    <aside class="widget widget_footer">
                        <h4 class="widget-title heading">Company</h4>
                        <ul class="ps-list--link mt-3">
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('user.about-us') }}">About Us</a></li>
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('user.contact-us') }}">Contact</a></li>
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('user.term-condition') }}">Terms and Conditions</a></li>
                            <li><i class="fa-solid fa-chevron-right"></i> <a
                                    href="{{ route('user.privacyPolicy') }}">Privacy Policy</a></li>

                            <li><i class="fa-solid fa-chevron-right"></i> <a href="{{ route('user.faqs') }}">FAQs</a>
                            </li>
                        </ul>
                    </aside>
                </div>
                <div class="col-md-3">
                    <aside class="widget widget_footer widget_contact-us">
                        <h4 class="widget-title heading">Contact us</h4>
                        <div class="widget_content mt-3">
                            <h3 class="mb-2">(800) 843-2446 </h3>
                            <!--<p>502 Lorem ipsum dolor sit<br>-->
                            <p style="color: #fff"> Fritz-Reuter-Straße 14a 13156 Berlin </p>
                            <p style="color: #fff"> info@lovecans.de</p>
                            {{-- <a href="#"><span class="__cf_email__" data-cfemail="e3808c8d97828097a38e8291978596919acd808c">[email&#160;protected]</span></a> --}}
                            </p>
                            <ul class="ps-list--social pb-1">
                                {{-- <li><a class="facebook" href="#"><i class="fa fa-facebook"></i></a></li> --}}
                                <li><a class="reddit" href="#"><i class="fa fa-reddit"></i></a></li>
                                <li><a class="instagram" href="#"><i class="fa fa-instagram"></i></a></li>
                            </ul>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
        <div class="ps-container p-0">
            <div class="ps-footer__widgets">






            </div>
            {{-- <div class="ps-footer__links">
                <p><strong>Consumer Electric:</strong><a href="#">Air Conditioners</a><a href="#">Audios &amp; Theaters</a><a href="#">Car Electronics</a><a href="#">Office Electronics</a><a href="#">TV Televisions</a><a href="#">Washing Machines</a>
                </p>
                <p><strong>Clothing &amp; Apparel:</strong><a href="#">Printers</a><a href="#">Projectors</a><a href="#">Scanners</a><a href="#">Store &amp; Business</a><a href="#">4K Ultra HD TVs</a><a href="#">LED TVs</a><a href="#">OLED TVs</a>
                </p>
                <p><strong>Home, Garden &amp; Kitchen:</strong><a href="#">Cookware</a><a href="#">Decoration</a><a href="#">Furniture</a><a href="#">Garden Tools</a><a href="#">Garden Equipments</a><a href="#">Powers And Hand Tools</a><a href="#">Utensil &amp; Gadget</a>
                </p>
                <p><strong>Health &amp; Beauty:</strong><a href="#">Hair Care</a><a href="#">Decoration</a><a href="#">Hair Care</a><a href="#">Makeup</a><a href="#">Body Shower</a><a href="#">Skin Care</a><a href="#">Cologine</a><a href="#">Perfume</a>
                </p>
                <p><strong>Jewelry &amp; Watches:</strong><a href="#">Necklace</a><a href="#">Pendant</a><a href="#">Diamond Ring</a><a href="#">Sliver Earing</a><a href="#">Leather Watcher</a><a href="#">Gucci</a>
                </p>
                <p><strong>Computer &amp; Technologies:</strong><a href="#">Desktop PC</a><a href="#">Laptop</a><a href="#">Smartphones</a><a href="#">Tablet</a><a href="#">Game Controller</a><a href="#">Audio &amp; Video</a><a href="#">Wireless Speaker</a><a href="#">Done</a>
                </p>
            </div> --}}
            <div class="ps-footer__copyright">
                <p>&copy; 2024 Lovecans. All Rights Reserved</p>
                <p><span>We Using Safe Payment For Lovecans</span>
                    {{-- <a href="#"><img src="img/payment-method/1.jpg" alt="" /></a> --}}
                    {{-- <a href="#"><img src="img/payment-method/2.jpg" alt="" /></a> --}}
                    <a href="#"><img src="img/payment-method/3.jpg" alt="" /></a>
                    {{-- <a href="#"><img src="img/payment-method/4.jpg" alt="" /></a> --}}
                    <a href="#"><img src="img/payment-method/5.jpg" alt="" /></a>
                </p>
            </div>
        </div>
    </footer>

    <div id="back2top"><i class="icon icon-arrow-up"></i></div>
    <div class="ps-site-overlay"></div>
    <div class="ps-panel--sidebar" id="cart-mobile">
        <div class="ps-panel__header">
            <h3>Shopping Cart</h3>
        </div>
        <div class="navigation__content">
            {{-- <div class="ps-cart--mobile">
                <div class="ps-cart__content">
                    <div class="ps-product--cart-mobile">
                        <div class="ps-product__thumbnail"><a href="#"><img src="img/products/clothing/7.jpg" alt=""></a></div>
                        <div class="ps-product__content"><a class="ps-product__remove" href="#"><i class="icon-cross"></i></a><a href="product-default.html">MVMTH Classical Leather Watch In Black</a>
                            <p><strong>Sold by:</strong> YOUNG SHOP</p><small>1 x $59.99</small>
                        </div>
                    </div>
                </div>
                <div class="ps-cart__footer">
                    <h3>Sub Total:<strong>$59.99</strong></h3>
                    <figure><a class="ps-btn" href="shopping-cart.html">View Cart</a><a class="ps-btn" href="checkout.html">Checkout</a></figure>
                </div>
            </div> --}}
        </div>
    </div>
    <!--include ../../data/menu/menu-product-categories-->
    {{-- <div class="ps-panel--sidebar" id="navigation-mobile">
        <div class="ps-panel__header">
            <h3>Categories</h3>
        </div>
        <div class="ps-panel__content">
            <div class="menu--product-categories">
                <div class="menu__toggle"><i class="icon-menu"></i><span> Shop by Department</span></div>
                <div class="menu__content">
                    <ul class="menu--mobile">
                        <li><a href="#">Hot Promotions</a>
                        </li>
                        <li class="menu-item-has-children has-mega-menu"><a href="#">Consumer Electronic</a><span class="sub-toggle"></span>
                            <div class="mega-menu">
                                <div class="mega-menu__column">
                                    <h4>Electronic<span class="sub-toggle"></span></h4>
                                    <ul class="mega-menu__list">
                                        <li><a href="#.html">Home Audio &amp; Theathers</a>
                                        </li>
                                        <li><a href="#.html">TV &amp; Videos</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="mega-menu__column">
                                    <h4>Accessories &amp; Parts<span class="sub-toggle"></span></h4>
                                    <ul class="mega-menu__list">
                                        <li><a href="#.html">Digital Cables</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </li>
                        <li><a href="#.html">Clothing &amp; Apparel</a>
                        </li>
                        <li><a href="#.html">Home, Garden &amp; Kitchen</a>
                        </li>
                        <li class="menu-item-has-children has-mega-menu"><a href="#">Computer &amp; Technology</a><span class="sub-toggle"></span>
                            <div class="mega-menu">
                                <div class="mega-menu__column">
                                    <h4>Computer &amp; Technologies<span class="sub-toggle"></span></h4>
                                    <ul class="mega-menu__list">
                                        <li><a href="#.html">Computer &amp; Tablets</a>
                                        </li>
                                        <li><a href="#.html">Laptop</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </li>
                        <li><a href="#.html">Babies &amp; Moms</a>
                        </li>
                        <li><a href="#.html">Sport &amp; Outdoor</a>
                        </li>
                    </ul>
                </div>
            </div>
            <!--+createMenu(product_categories, 'menu--mobile')-->
        </div>
    </div> --}}

    {{-- <div class="navigation--list">
        <div class="navigation__content">
            <a class="navigation__item ps-toggle--sidebar" href="#menu-mobile">
                <i class="icon-menu"></i><span> Menu</span>
            </a>
            <a class="navigation__item ps-toggle--sidebar" href="#navigation-mobile">
                <i class="icon-list4"></i><span> Categories</span>
            </a>
            <a class="navigation__item ps-toggle--sidebar" href="#search-sidebar">
                <i class="icon-magnifier"></i><span> Search</span>
            </a>
       
        </div>
         </div> --}}


    <div class="ps-panel--sidebar" id="search-sidebar">
        <div class="ps-panel__header">
            <form class="ps-form--search-mobile" action="{{ route('user.detailed-search') }}" method="POST">
                @csrf
                <div class="filter-container" id="filter_container_mobile" style="text-align: start">
                    <div class="filter-content text-start" style="width: 400px;height: 75%;overflow-y: auto">
                        <h4>Filters</h4>
                        @php
                            $categories = App\Models\Category::all();
                        @endphp
                        <hr>
                        <label for="type" class="text-white">Type</label>
                        <select name="type" id="type" class="bg-white form-control">
                            <option value="">Select Type</option>
                            @foreach ($categories as $category)
                                <option value="{{ $category->category }}">{{ $category->category }}</option>
                            @endforeach
                        </select>
                        <label for="worn_days" class="mt-3 text-white">Worn Days</label>
                        <input type="number" class="form-control" name="worn_days" id="worn_days"
                            placeholder="Enter number of days">

                        <label for="price" class="mt-3 text-white">Price</label>
                        <input type="number" class="form-control" name="price" id="price"
                            placeholder="Enter price">

                        <label for="upload_date" class="mt-3 text-white">Upload Date</label>
                        <input type="date" class="form-control" name="upload_date" id="upload_date">
                        <div class="mt-3">
                            <button type="button" id="close_filter_mobile"
                                class="w-100 form-control bg-dark text-white">OK</button>
                        </div>
                    </div>
                </div>
                <div class="form-group--nest">
                    <button id="open_filter_mobile" type="button" class="form-control"
                        style="width:fit-content;border-right: 1px solid #b47377">Filters</button>
                    <input class="form-control" name="title" type="text" placeholder="Product name...">
                    <button type="submit"><i class="icon-magnifier"></i></button>
                </div>
            </form>


        </div>
        <div class="navigation__content"></div>
    </div>
    <div class="ps-panel--sidebar" id="menu-mobile">
        <div class="ps-panel__header">
            <h3 class="mt-4">Menu</h3>
            <p>
                <a class="ps-toggle--sidebar" href="#menu-mobile">
                    <!-- <i class="icon-menu"></i> -->
                    <i class="fa fa-window-close" aria-hidden="true"></i>
                </a>
            </p>
            <!-- <p> X</p> -->
        </div>
        <div class="ps-panel__content">
            <ul class="menu--mobile">
                <li class="menu-item-has-children">
                    <a href="/">Home</a>

                </li>
                <li class="menu-item-has-children has-mega-menu">
                    <a href="/about-us">About</a>

                </li>
                <li class="menu-item-has-children has-mega-menu nav-item dropdown">

                    <a class="nav-link" href="#" role="button">
                        Categories
                    </a>

                    <span class="sub-toggle"></span>
                    <ul class="sub-menu">
                        @php
                            $categories = App\Models\Category::all();
                        @endphp
                        @forelse ($categories as $category)
                            <li>
                                <a class="dropdown-item text-capitalize"
                                    href="{{ route('category.subcategories', $category->id) }}"
                                    value="{{ $category->id }}">{{ $category->category }}</a>
                            </li>

                        @empty
                            <span class="text-center text-danger text-capitalize">No category found</span>
                        @endforelse
                    </ul>
                </li>
                <li class="menu-item-has-children has-mega-menu">
                    <a href="{{ route('products.filter') }}">Products</a>
                </li>
                <li class="menu-item-has-children has-mega-menu">
                    <a href="{{ route('user.medias') }}">Media</a>
                </li>
                <li class="menu-item-has-children has-mega-menu">
                    <a href="/contact-us">Contact</a>
                </li>


                @if (!Auth::check())
                    <li class="menu-item-has-children has-mega-menu">
                        <a href="/profile" class="btn btn-lg  fs-1">Sell on Lovecans</a>
                    </li>
                @endif








            </ul>

        </div>
    </div>
    <div id="loader-wrapper">
        <div class="loader-section section-left"></div>
        <div class="loader-section section-right"></div>
    </div>
    <div class="ps-search" id="site-search"><a class="ps-btn--close" href="#"></a>
        <div class="ps-search__content">
            <form class="ps-form--primary-search" action="#" method="post">
                <input class="form-control" type="text" placeholder="Search for...">
                <button><i class="aroma-magnifying-glass"></i></button>
            </form>
        </div>
    </div>
    <div class="modal fade" id="product-quickview" tabindex="-1" role="dialog"
        aria-labelledby="product-quickview" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content"><span class="modal-close" data-dismiss="modal"><i
                        class="icon-cross2"></i></span>
                <article class="ps-product--detail ps-product--fullwidth ps-product--quickview">
                    <div class="ps-product__header">
                        <div class="ps-product__thumbnail" data-vertical="false">
                            <div class="ps-product__images" data-arrow="true">
                                <div class="item"><img src="img/products/detail/fullwidth/1.jpg" alt="">
                                </div>
                                <div class="item"><img src="img/products/detail/fullwidth/2.jpg" alt="">
                                </div>
                                <div class="item"><img src="img/products/detail/fullwidth/3.jpg" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
        </div>
    </div>


    <style>
        .popup {
            display: none;
        }

        .popup-content {
            /* display: none; Hidden by default */
            display: flex;
            position: fixed;
            justify-content: space-between;
            align-content: center;
            top: 5px;
            right: 5px;
            width: fit-content;
            border-radius: 5px;
            padding: 10px;
            z-index: 1000;
        }

        .close-btn {
            margin: auto 10px;
            font-size: 18px;
            cursor: pointer;
            width: 50px;
            text-align: end;
        }

        .range-slider {
            position: relative;
            width: 100%;
            max-width: 400px;
            margin: 50px auto;
        }

        .range-values {
            position: absolute;
            top: -30px;
            left: 50%;
            transform: translateX(-50%);
            font-weight: bold;
            background: #EAD5C4 color: white;
            padding: 5px 10px;
            border-radius: 5px;
        }

        input[type="range"]::-webkit-slider-runnable-track {
            background: linear-gradient(to right, brown 0%, brown var(--progress), #ddd var(--progress), #ddd 100%);
        }
    </style>
    {{-- cart popup --}}

    <div id="popup" class="popup">
        <div class="popup-content bg-success text-white">
            <p class="text-white p-0 m-0">Item Has Been Added To Your Cart</p>
            <span class="close-btn" onclick="closePopup()">&times;</span>
        </div>
    </div>

    <script data-cfasync="false" src="../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/jquery.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/nouislider/nouislider.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/popper.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/owl-carousel/owl.carousel.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/imagesloaded.pkgd.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/masonry.pkgd.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/isotope.pkgd.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/jquery.matchHeight-min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/slick/slick/slick.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/jquery-bar-rating/dist/jquery.barrating.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/slick-animation.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/lightGallery-master/dist/js/lightgallery-all.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/sticky-sidebar/dist/sticky-sidebar.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/select2/dist/js/select2.full.min.js"></script>
    <script src="{{ asset('') }}assets/user/plugins/gmap3.min.js"></script>
    <!-- custom scripts-->
    <script src="{{ asset('') }}assets/user/js/main.js"></script>
    <script
        src="https://cloud.ccm19.de/app.js?apiKey=8d5f562d28f765cb3181c7fec7ad5124a2b04387769e9795&amp;domain=67da7015a8df0773a60554a2&amp;lang=de_DE"
        referrerpolicy="origin"></script>

    {{-- filter js --}}
    <script>
        const minPrice = document.getElementById("minPrice");
        const maxPrice = document.getElementById("maxPrice");
        const rangeValue = document.getElementById("rangeValue");

        function updateRange() {
            let min = parseInt(minPrice.value);
            let max = parseInt(maxPrice.value);
            if (min > max) {
                let temp = min;
                min = max;
                max = temp;
            }
            rangeValue.innerText = min + " - " + max;
        }

        minPrice.addEventListener("input", updateRange);
        maxPrice.addEventListener("input", updateRange);
    </script>
    <script>
        document.getElementById('open_filter').addEventListener('click', function() {
            // alert('hello');
            document.getElementById('filter_container').classList.add('active');
        })
        document.getElementById('close_filter').addEventListener('click', function() {
            document.getElementById('filter_container').classList.remove('active');
        })

        document.getElementById('open_filter_mobile').addEventListener('click', function() {
            document.getElementById('filter_container_mobile').classList.add('active');
        })
        document.getElementById('close_filter_mobile').addEventListener('click', function() {
            document.getElementById('filter_container_mobile').classList.remove('active');
        })
    </script>
    {{-- cart js --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // items in card

            let cart = JSON.parse(localStorage.getItem('cart')) || [];
            if (cart.length > 0) {
                // document.querySelector('#show-itmes-cart').innerHTML = cart.length;
                carts = document.querySelectorAll('.show-itmes-cart');
                carts[0].innerHTML = cart.length;
                carts[1].innerHTML = cart.length;
                // document.querySelector('.header__extra').querySelector('span').textContent = cart.length;
            }

            // Select all 'Add to Cart' buttons
            const addToCartButtons = document.querySelectorAll('.add-to-cart-btn');

            addToCartButtons.forEach(button => {
                button.addEventListener('click', function() {
                    // Retrieve product data
                    const productCard = button.closest('.product-card');
                    const productId = productCard.getAttribute('data-id');
                    const productName = productCard.getAttribute('data-name');
                    const productImage = productCard.getAttribute('data-image');
                    const productPrice = productCard.getAttribute('data-price');
                    const productDesc = productCard.getAttribute('data-desc');
                    const productType = productCard.getAttribute('data-type');
                    const user_name = productCard.getAttribute('user_name');
                    const days = productCard.getAttribute('data-days');
                    // Create a product object
                    const product = {
                        id: productId,
                        name: productName,
                        image: productImage,
                        price: productPrice,
                        quantity: 1, // Default quantity
                        description: productDesc,
                        type: productType,
                        days: days,
                        user_name:user_name,
                    };

                    // Get existing cart data from local storage
                    let cart = JSON.parse(localStorage.getItem('cart')) || [];
                    // console.log('cart data',product)
                    // Check if the product is already in the cart
                    const existingProduct = cart.find(item => item.id === productId && item.type === productType);

                    if (!existingProduct) {
                        // If no such product exists, add to cart
                        cart.push(product);
                        // Save updated cart to local storage
                        localStorage.setItem('cart', JSON.stringify(cart));

                        // Update cart UI count
                        const carts = document.querySelectorAll('.show-itmes-cart');
                        carts.forEach(cartElement => cartElement.innerHTML = cart.length);

                        // Show popup
                        showPopup();
                    } else {
                        console.log('Product with the same type already exists in the cart.');
                    }

                    // else {
                    //     // Add new product to the cart
                    //     cart.push(product);
                    // }

                    // Save updated cart back to local storage
                    localStorage.setItem('cart', JSON.stringify(cart));
                    // document.querySelector('#show-itmes-cart').innerHTML = cart.length;
                    cart = JSON.parse(localStorage.getItem('cart')) || [];
                    carts = document.querySelectorAll('.show-itmes-cart');
                    carts[0].innerHTML = cart.length;
                    carts[1].innerHTML = cart.length;
                });
            });
        });

        function showPopup() {
            document.getElementById("popup").style.display = "block";
        }

        function closePopup() {
            document.getElementById("popup").style.display = "none";
        }
    </script>

    <script>
        let cart = JSON.parse(localStorage.getItem('cart')) || [];
        if (cart.length > 0) {
            carts = document.querySelectorAll('.show-itmes-cart');
            carts[0].innerHTML = cart.length;
            carts[1].innerHTML = cart.length;
            // document.querySelector('.header__extra').querySelector('span').textContent = cart.length;
        }

        document.addEventListener("DOMContentLoaded", function() {
            let filterIcon = document.getElementById("open_filter");
            let filterContainer = document.getElementById("filter_container");
            let closeFilter = document.getElementById("close_filter");


            let filterIconMobile = document.getElementById("open_filter_mobile");
            let filterContainerMobile = document.getElementById("filter_container_mobile");
            let closeFilterMobile = document.getElementById("close_filter_mobile");

            // PC Filters - Show/Hide
            filterIcon.addEventListener("click", function() {
                filterContainer.style.display = "block";
            });

            closeFilter.addEventListener("click", function() {
                filterContainer.style.display = "none";
            });

            // Mobile Filters - Show/Hide
            filterIconMobile.addEventListener("click", function() {
                filterContainerMobile.style.display = "block";
            });

            closeFilterMobile.addEventListener("click", function() {
                filterContainerMobile.style.display = "none";
            });
        });
        document.addEventListener("DOMContentLoaded", function() {
            let filterIcon = document.getElementById("open_filter"); // Button to open filter
            let filterContainer = document.getElementById("filter_container");
            let closeFilter = document.getElementById("close_filter");
            let overlay = document.createElement("div"); // Create overlay

            overlay.classList.add("filter-overlay");
            document.body.appendChild(overlay);

            // Show filter in center
            filterIcon.addEventListener("click", function() {
                filterContainer.style.display = "block";
                overlay.style.display = "block";
            });

            // Hide filter
            closeFilter.addEventListener("click", function() {
                filterContainer.style.display = "none";
                overlay.style.display = "none";
            });

            // Hide filter when clicking outside
            overlay.addEventListener("click", function() {
                filterContainer.style.display = "none";
                overlay.style.display = "none";
            });
        });


        document.addEventListener("DOMContentLoaded", function() {
            let searchIcon = document.getElementById("open_search");
            let searchContainer = document.getElementById("search_container");
            let closeSearch = document.getElementById("close_search");
            let searchInput = document.getElementById("input-search");
            let searchButton = document.getElementById("search_button");
            let searchForm = document.querySelector(".ps-form--quick-search");

            // Hide search container on page load
            if (searchContainer) {
                searchContainer.style.display = "none";
            }

            searchIcon?.addEventListener("click", function() {
                searchContainer.style.display = "flex";
                document.body.style.overflow = "hidden"; // Disable scrolling
            });

            closeSearch?.addEventListener("click", function() {
                searchContainer.style.display = "none";
                document.body.style.overflow = "auto"; // Enable scrolling
            });

            searchButton?.addEventListener("click", function(event) {
                event.preventDefault();
                let query = searchInput.value.trim();

                if (query) {
                    let titleInput = document.createElement("input");
                    titleInput.type = "hidden";
                    titleInput.name = "title";
                    titleInput.value = query;
                    searchForm.appendChild(titleInput);
                    searchForm.submit();
                }
            });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let searchIcon = document.getElementById("open_search");
            let searchContainer = document.getElementById("search_container");
            let closeSearch = document.getElementById("close_search");
            let searchInput = document.getElementById("input-search"); // 🔹 Corrected ID
            let searchButton = document.getElementById("search_button");
            let searchForm = document.querySelector(".ps-form--quick-search"); // 🔹 Form reference

            searchContainer.style.display = "none";

            searchIcon?.addEventListener("click", function() {
                searchContainer.style.display = "flex";
                document.body.style.overflow = "hidden"; // Disable scrolling
            });

            closeSearch?.addEventListener("click", function() {
                searchContainer.style.display = "none";
                document.body.style.overflow = "auto"; // Enable scrolling
            });

            searchButton?.addEventListener("click", function(event) {
                event.preventDefault(); // Stop default behavior
                let query = searchInput.value.trim();

                if (query) {
                    let titleInput = document.createElement("input");
                    titleInput.type = "hidden";
                    titleInput.name = "title";
                    titleInput.value = query;
                    searchForm.appendChild(titleInput);
                    searchForm.submit(); // 🔹 Now submits as POST
                }
            });
        });


        document.addEventListener("DOMContentLoaded", function() {
            var dropdownToggle = document.querySelector(".dropdown-toggle");
            var dropdownMenu = document.querySelector(".dropdown-menu");

            // Dropdown toggle on click
            dropdownToggle.addEventListener("click", function(event) {
                event.preventDefault();
                dropdownMenu.classList.toggle("show");
            });

            document.addEventListener("click", function(event) {
                if (!dropdownToggle.contains(event.target) && !dropdownMenu.contains(event.target)) {
                    dropdownMenu.classList.remove("show");
                }
            });
        });


    document.addEventListener('DOMContentLoaded', function () {
        const toggleBtn = document.querySelector('.navigation__item');  // Get the button
        const mobileMenu = document.querySelector('.mobile_menu_header');  // Get the mobile menu

        // Click event to toggle the menu open/close
        toggleBtn.addEventListener('click', function (e) {
            e.preventDefault();  // Prevent default link behavior
            mobileMenu.classList.toggle('active');  // Toggle the 'active' class
        });

        // Optional: Close the menu if clicked outside
        document.addEventListener('click', function (e) {
            if (!mobileMenu.contains(e.target) && !toggleBtn.contains(e.target)) {
                mobileMenu.classList.remove('active');
            }
        });
    });
</script>



    </script>

</body>

</html>
