<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Order Has Been Sent</title>
    <style>

        .email-container {
            width: 100%;
            max-width: 650px;
            margin: 40px auto;
            background-color:powderblue;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 12px 20px rgba(0, 0, 0, 0.08);
        }

        .email-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .email-header h2 {
            font-size: 26px;
            color: #2c3e50;
            margin: 0;
            font-weight: 700;
            line-height: 1.3;
        }

        .email-header p {
            color: #7f8c8d;
            font-size: 16px;
        }

        .email-body {
            font-size: 16px;
            line-height: 1.8;
            color: #444;
        }

        .email-body p {
            margin-bottom: 15px;
        }

        .email-body h4 {
            color: #2980b9;
            font-size: 18px;
            margin-top: 20px;
            font-weight: 600;
        }

        ul {
            padding-left: 20px;
            list-style-type: none;
        }

        ul li {
            margin-bottom: 10px;
            font-size: 16px;
            color: #7f8c8d;
        }

        .link-button {
            display: inline-block;
            background-color: #2980b9;
            color: #fff;
            padding: 12px 25px;
            font-size: 16px;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 15px;
            transition: background-color 0.3s ease;
        }

        .link-button:hover {
            background-color: #3498db;
        }

        .footer {
            text-align: center;
            font-size: 14px;
            color: #bdc3c7;
            margin-top: 40px;
            line-height: 1.6;
        }

        .footer a {
            color: #2980b9;
            text-decoration: none;
        }

        @media screen and (max-width: 600px) {
            .email-container {
                padding: 20px;
            }

            .email-header h2 {
                font-size: 22px;
            }

            .email-body h4 {
                font-size: 16px;
            }

            .link-button {
                padding: 10px 20px;
            }
        }
    </style>
</head>
<body>

    <div class="email-container">
        <div class="email-header">
            <h2>Your Order (Order ID: {{ $order->order_detail_id }}) Has Been Sent</h2>
            <p>We are excited to inform you that your order has been successfully processed and shipped. Here are the details:</p>
        </div>

        <div class="email-body">
            <p>Dear {{ $order->orderDetail->first_name }},</p>
            <p>Thank you for your purchase! Your order has been sent, and you can find the details below:</p>

            <h4>Order Details:</h4>
            <ul>
                <li><strong>Product Name:</strong> {{ $order->ad->title }}</li>
                <li><strong>Quantity:</strong> {{ $order->quantity }}</li>
                <li><strong>Price:</strong> ${{ $order->ad->price }}</li>
            </ul>

            <p>For your convenience, we have attached the requested documents:</p>

            <h4>Download Your PDF Document:</h4>
            @if(isset($pdfPath) && $pdfPath)
                <a href="{{ asset('./storage/'. $pdfPath ) }}" class="link-button" download>Download PDF</a>
            @else
                <p>No PDF available.</p>
            @endif

            <h4>Watch Your Video:</h4>
            @if(isset($videoPath) && $videoPath)
                <a href="{{ asset('storage/' . $videoPath) }}" class="link-button">Watch Video</a>
            @else
                <p>No Video available.</p>
            @endif
        </div>

        <div class="footer">
            <p>If you have any questions, feel free to .</p>
        </div>
    </div>

</body>
</html>
