<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order In Progress</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #007BFF;
            color: white;
            padding: 10px 0;
            text-align: center;
            border-radius: 8px;
        }
        .content {
            margin-top: 20px;
        }
        .order-details {
            background-color: #f9f9f9;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }
        h3 {
            color: #007BFF;
        }
        p {
            font-size: 16px;
            line-height: 1.5;
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        li {
            margin: 8px 0;
            font-size: 16px;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 14px;
            color: #666;
        }
        .button {
            background-color: #28a745;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
            margin-top: 15px;
        }
        .button:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Order Status Update</h2>
        </div>

        <div class="content">
            <p>Dear {{ $order->orderDetail->first_name }},</p>
            <p>We are writing to inform you that your order (Order ID: {{ $order->order_detail_id }}) is now in progress.</p>

            <h4>Order Details:</h4>
            <div class="order-details">
                <ul>
                    <li><strong>Product Name:</strong> {{ $order->product_name }}</li>
                    <li><strong>Quantity:</strong> {{ $order->quantity }}</li>
                    <li><strong>Price:</strong> ${{ $order->price }}</li>
                    <li><strong>Status:</strong> {{ $order->status }}</li>
                </ul>
            </div>

            <p>Thank you for choosing us. We will keep you updated on the status of your order.</p>
        </div>

        <div class="footer">
            <p>If you have any questions, feel free to contact us.</p>
        </div>
    </div>
</body>
</html>
