<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Canceled</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 30px auto;
            background: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .header {
            background-color: #d9534f;
            color: white;
            padding: 15px;
            border-radius: 10px 10px 0 0;
        }

        .header h2 {
            margin: 0;
            font-size: 22px;
        }

        .content {
            padding: 20px;
            text-align: left;
        }

        .content p {
            font-size: 16px;
            color: #333;
            line-height: 1.5;
        }

        .order-details {
            background: #f8d7da;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }

        .order-details ul {
            list-style: none;
            padding: 0;
        }

        .order-details li {
            font-size: 14px;
            margin-bottom: 8px;
        }

        .order-details strong {
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Order Canceled</h2>
        </div>

        <div class="content">
            <p>Dear <strong>{{ $order->orderDetail->first_name }}</strong>,</p>
            <p>We regret to inform you that your order (Order ID: <strong>{{ $order->order_detail_id }}</strong>) has been canceled.</p>

            <h4>Order Details:</h4>
            <div class="order-details">
                <ul>
                    <li><strong>Product Name:</strong> {{ $order->product_name }}</li>
                    <li><strong>Quantity:</strong> {{ $order->quantity }}</li>
                    <li><strong>Price:</strong> ${{ $order->price }}</li>
                    <li><strong>Status:</strong> <span style="color: #d9534f;">Canceled</span></li>
                </ul>
            </div>

            <p>We're sorry for the cancel your order.</p>
        </div>

    </div>
</body>
</html>
